/*
 * Decompiled with CFR 0.152.
 */
package de.crafty.eiv.servercompat.util;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import de.crafty.eiv.servercompat.recipe.CompatRecipeManager;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.bukkit.craftbukkit.inventory.CraftRecipe;
import org.bukkit.inventory.RecipeChoice;

public class EivCompatTagUtil {
    private static <T> ListTag createRegistryList(List<T> objects, DefaultedRegistry<T> registry) {
        ListTag list = new ListTag();
        objects.stream().map(t -> StringTag.valueOf((String)EivCompatTagUtil.registryToString(t, registry))).forEach(arg_0 -> list.add(arg_0));
        return list;
    }

    private static <T> List<T> reconstructRegistryList(CompoundTag srcTag, String key, DefaultedRegistry<T> registry) {
        return srcTag.getListOrEmpty(key).stream().map(Tag::asString).map(s -> EivCompatTagUtil.stringToRegistry((String)s.orElseThrow(), registry)).filter(Objects::nonNull).toList();
    }

    public static CompoundTag encodeItemStackOnServer(ItemStack stack) {
        return (CompoundTag)ItemStack.CODEC.encode((Object)stack, (DynamicOps)CompatRecipeManager.INSTANCE.getServer().registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)new CompoundTag()).mapOrElse(tag -> tag.asCompound().orElseGet(CompoundTag::new), tagError -> new CompoundTag());
    }

    public static CompoundTag writeChoice(RecipeChoice choice) {
        if (choice == null) {
            return new CompoundTag();
        }
        Ingredient ingredient = CraftRecipe.toIngredient((RecipeChoice)choice, (boolean)false);
        if (ingredient.isEmpty()) {
            return new CompoundTag();
        }
        HolderSet.Direct set = HolderSet.direct(ingredient.items().toList());
        Either ingredientContent = set.unwrap();
        CompoundTag tag = new CompoundTag();
        if (ingredientContent.left().isPresent()) {
            tag.putString("tag", ((TagKey)ingredientContent.left().get()).location().toString());
            return tag;
        }
        if (ingredientContent.right().isEmpty()) {
            return new CompoundTag();
        }
        tag.put("items", (Tag)EivCompatTagUtil.createItemList(((List)ingredientContent.right().get()).stream().filter(Holder::isBound).map(Holder::value).toList()));
        return tag;
    }

    public static ListTag createItemList(List<Item> items) {
        return EivCompatTagUtil.createRegistryList(items, BuiltInRegistries.ITEM);
    }

    public static ListTag createBlockList(List<Block> blocks) {
        return EivCompatTagUtil.createRegistryList(blocks, BuiltInRegistries.BLOCK);
    }

    public static ListTag createFluidList(List<Fluid> fluids) {
        return EivCompatTagUtil.createRegistryList(fluids, BuiltInRegistries.FLUID);
    }

    public static <T> ListTag writeList(List<T> list, CompoundBuilder<T> builder) {
        ListTag tagList = new ListTag();
        list.stream().map(t -> builder.buildSingle(t, new CompoundTag())).forEach(arg_0 -> tagList.add(arg_0));
        return tagList;
    }

    private static <T> String registryToString(T object, DefaultedRegistry<T> registry) {
        return registry.getKey(object).toString();
    }

    private static <T> T stringToRegistry(String string, DefaultedRegistry<T> registry) {
        if (string.isEmpty()) {
            return null;
        }
        return registry.getOptional(ResourceLocation.tryParse((String)string)).orElse(null);
    }

    public static String itemToString(Item item) {
        return EivCompatTagUtil.registryToString(item, BuiltInRegistries.ITEM);
    }

    public static Item itemFromString(String s) {
        return (Item)EivCompatTagUtil.stringToRegistry(s, BuiltInRegistries.ITEM);
    }

    public static String blockToString(Block block) {
        return EivCompatTagUtil.registryToString(block, BuiltInRegistries.BLOCK);
    }

    public static Block blockFromString(String s) {
        return (Block)EivCompatTagUtil.stringToRegistry(s, BuiltInRegistries.BLOCK);
    }

    public static String fluidToString(Fluid fluid) {
        return EivCompatTagUtil.registryToString(fluid, BuiltInRegistries.FLUID);
    }

    public static Fluid fluidFromString(String s) {
        return (Fluid)EivCompatTagUtil.stringToRegistry(s, BuiltInRegistries.FLUID);
    }

    public static interface CompoundBuilder<T> {
        public CompoundTag buildSingle(T var1, CompoundTag var2);
    }
}

