#> nobuildlimit:image/set_image_data
#
# This function sets the image data.
#
# @input $(image_data) {string[][]} The data to set  
# @input $(width) {number} The width of the image  
# @input $(height) {number} The height of the image  
# @input $(background_color) {string} The background color of the image  
# @input $(description) {string[]} The description on the right hand side  
# @writes storage nobuildlimit:image image_data  
# @writes storage nobuildlimit:image width  
# @writes storage nobuildlimit:image height  
# @writes storage nobuildlimit:image background_color  
# @writes storage nobuildlimit:image description  
# @writes storage nobuildlimit:image pixel_character.blank  
# @writes storage nobuildlimit:image pixel_character.chat  
# @writes storage nobuildlimit:image pixel_character.lore

data remove storage nobuildlimit:image image_data
data remove storage nobuildlimit:image width
data remove storage nobuildlimit:image height
data remove storage nobuildlimit:image background_color
data remove storage nobuildlimit:image description

$data modify storage nobuildlimit:image image_data set value $(image_data)
$data modify storage nobuildlimit:image width set value $(width)
$data modify storage nobuildlimit:image height set value $(height)
$data modify storage nobuildlimit:image background_color set value "$(background_color)"
$data modify storage nobuildlimit:image description set value $(description)

data modify storage nobuildlimit:image pixel_character.blank set value "　"
data modify storage nobuildlimit:image pixel_character.pixel set value "▌▌"
data modify storage nobuildlimit:image pixel_character.line_break set value '\n'

function nobuildlimit:image/process/generate
