/*
 * Decompiled with CFR 0.152.
 */
package com.snowyhill.appletreemod.block;

import com.mojang.serialization.MapCodec;
import com.snowyhill.appletreemod.registry.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class DarkAppleFlowerLeavesBlock
extends LeavesBlock
implements BonemealableBlock {
    public static final MapCodec<DarkAppleFlowerLeavesBlock> CODEC = DarkAppleFlowerLeavesBlock.simpleCodec(DarkAppleFlowerLeavesBlock::new);
    public static final int MAX_AGE = 2;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_2;
    private static final VoxelShape LEAVES_SHAPE = Shapes.block();

    public MapCodec<DarkAppleFlowerLeavesBlock> codec() {
        return CODEC;
    }

    public DarkAppleFlowerLeavesBlock(BlockBehaviour.Properties p_57249_) {
        super(p_57249_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(7))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return LEAVES_SHAPE;
    }

    protected boolean isRandomlyTicking(BlockState pState) {
        return (Integer)pState.getValue((Property)AGE) < 2 || (Boolean)pState.getValue((Property)PERSISTENT) == false && (Integer)pState.getValue((Property)DISTANCE) == 7;
    }

    protected void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        int i = (Integer)pState.getValue((Property)AGE);
        if (i < 2 && pLevel.getRawBrightness(pPos.above(), 0) >= 9 && ForgeHooks.onCropsGrowPre((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (pRandom.nextInt(5) == 0 ? 1 : 0) != 0)) {
            BlockState blockstate = (BlockState)pState.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            pLevel.setBlock(pPos, blockstate, 2);
            pLevel.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pPos, GameEvent.Context.of((BlockState)blockstate));
            ForgeHooks.onCropsGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
        super.randomTick(pState, pLevel, pPos, pRandom);
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        int i = (Integer)pState.getValue((Property)AGE);
        if (pStack.is(Items.BONE_MEAL)) {
            if (this.isValidBonemealTarget((LevelReader)pLevel, pPos, pState)) {
                if (!pLevel.isClientSide) {
                    this.performBonemeal((ServerLevel)pLevel, pLevel.random, pPos, pState);
                }
                return ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return super.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHitResult);
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        int i = (Integer)pState.getValue((Property)AGE);
        if (i == 2) {
            if (!pLevel.isClientSide) {
                DarkAppleFlowerLeavesBlock.popResource((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)ModItems.DARK_APPLE.get(), 1));
                pLevel.playSound(null, pPos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + pLevel.random.nextFloat() * 0.4f);
                BlockState blockstate = (BlockState)pState.setValue((Property)AGE, (Comparable)Integer.valueOf(0));
                pLevel.setBlock(pPos, blockstate, 2);
                pLevel.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pPos, GameEvent.Context.of((Entity)pPlayer, (BlockState)blockstate));
            }
            return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
        }
        return super.useWithoutItem(pState, pLevel, pPos, pPlayer, pHitResult);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{AGE});
    }

    public boolean isValidBonemealTarget(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return (Integer)pState.getValue((Property)AGE) < 2;
    }

    public boolean isBonemealSuccess(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void performBonemeal(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        int before = (Integer)pState.getValue((Property)AGE);
        if (before < 2) {
            int after = before + 1;
            BlockState grown = (BlockState)pState.setValue((Property)AGE, (Comparable)Integer.valueOf(after));
            pLevel.setBlock(pPos, grown, 2);
            pLevel.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pPos, GameEvent.Context.of((BlockState)grown));
            pLevel.levelEvent(2005, pPos, 0);
            double cx = (double)pPos.getX() + 0.5;
            double cy = (double)pPos.getY() + 0.7;
            double cz = (double)pPos.getZ() + 0.5;
            int count = 6 + pRandom.nextInt(5);
            pLevel.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, cx, cy, cz, count, 0.25, 0.25, 0.25, 0.0);
            pLevel.playSound(null, pPos, SoundEvents.BONE_MEAL_USE, SoundSource.BLOCKS, 0.8f, 0.9f + pRandom.nextFloat() * 0.2f);
        }
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 60;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 30;
    }
}

