/*
 * Decompiled with CFR 0.152.
 */
package com.snowyhill.appletreemod.block;

import com.snowyhill.appletreemod.item.DarkAppleItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DarkApplePieBlock
extends Block {
    public static final IntegerProperty BITES = IntegerProperty.create((String)"bites", (int)0, (int)3);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape Q_NW = Block.box((double)1.0, (double)0.0, (double)1.0, (double)8.0, (double)8.0, (double)8.0);
    private static final VoxelShape Q_NE = Block.box((double)8.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)8.0);
    private static final VoxelShape Q_SW = Block.box((double)1.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)15.0);
    private static final VoxelShape Q_SE = Block.box((double)8.0, (double)0.0, (double)8.0, (double)15.0, (double)8.0, (double)15.0);
    private static final VoxelShape[] QUADS_CW = new VoxelShape[]{Q_NE, Q_SE, Q_SW, Q_NW};

    public DarkApplePieBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BITES, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> b) {
        b.add(new Property[]{BITES, FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection())).setValue((Property)BITES, (Comparable)Integer.valueOf(0));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!player.canEat(false)) {
            return InteractionResult.PASS;
        }
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        this.eatOneBite(level, pos, state, player);
        return InteractionResult.CONSUME;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!player.canEat(false)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        this.eatOneBite(level, pos, state, player);
        return ItemInteractionResult.CONSUME;
    }

    private void eatOneBite(Level level, BlockPos pos, BlockState state, Player player) {
        player.getFoodData().eat(4, 0.3f);
        level.playSound(null, pos, SoundEvents.GENERIC_EAT, SoundSource.PLAYERS, 1.0f, 1.0f);
        int bites = (Integer)state.getValue((Property)BITES);
        if (bites < 3) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 2);
        } else {
            level.removeBlock(pos, false);
        }
        if (!level.isClientSide) {
            DarkAppleItem.applyRandomDarkAppleEffect((LivingEntity)player, level);
        }
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return DarkApplePieBlock.shapeFor(state);
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return DarkApplePieBlock.shapeFor(state);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return DarkApplePieBlock.shapeFor(state);
    }

    private static VoxelShape shapeFor(BlockState state) {
        int bites = (Integer)state.getValue((Property)BITES);
        Direction f = (Direction)state.getValue((Property)FACING);
        int start = switch (f) {
            case Direction.EAST -> 1;
            case Direction.SOUTH -> 2;
            case Direction.WEST -> 3;
            default -> 0;
        };
        boolean[] removed = new boolean[4];
        for (int i = 0; i < bites; ++i) {
            removed[start + i & 3] = true;
        }
        VoxelShape acc = Shapes.empty();
        for (int i = 0; i < 4; ++i) {
            if (removed[i]) continue;
            acc = Shapes.or((VoxelShape)acc, (VoxelShape)QUADS_CW[i]);
        }
        return acc;
    }
}

