/*
 * Decompiled with CFR 0.152.
 */
package com.snowyhill.appletreemod.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public class ModStrippableLogBlock
extends RotatedPillarBlock {
    private final Supplier<Block> strippedLog;

    public ModStrippableLogBlock(BlockBehaviour.Properties properties, Supplier<Block> strippedLog) {
        super(properties);
        this.strippedLog = strippedLog;
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
        if (toolAction == ToolActions.AXE_STRIP) {
            BlockState result = (BlockState)this.strippedLog.get().defaultBlockState().setValue((Property)AXIS, (Comparable)((Direction.Axis)state.getValue((Property)AXIS)));
            if (!simulate && context.getLevel() != null) {
                context.getLevel().playSound(context.getPlayer(), context.getClickedPos(), SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return result;
        }
        return super.getToolModifiedState(state, context, toolAction, simulate);
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 5;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 5;
    }
}

