/*
 * Decompiled with CFR 0.152.
 */
package com.snowyhill.appletreemod.datagen;

import com.snowyhill.appletreemod.datagen.client.ENUSLanguageProvider;
import com.snowyhill.appletreemod.datagen.client.JAJPLanguageProvider;
import com.snowyhill.appletreemod.datagen.client.ModBlockStateProvider;
import com.snowyhill.appletreemod.datagen.client.ModItemModelProvider;
import com.snowyhill.appletreemod.datagen.server.ModBlockTagsProvider;
import com.snowyhill.appletreemod.datagen.server.ModGlobalLootModifierProvider;
import com.snowyhill.appletreemod.datagen.server.ModItemTagsProvider;
import com.snowyhill.appletreemod.datagen.server.ModRecipeProvider;
import com.snowyhill.appletreemod.datagen.server.ModWorldGenProvider;
import com.snowyhill.appletreemod.datagen.server.loot.ModLootTables;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="appletreemod", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModDataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookUpProvider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new JAJPLanguageProvider(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new ENUSLanguageProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new ModWorldGenProvider(packOutput, lookUpProvider));
        ModBlockTagsProvider blockTagsProvider = (ModBlockTagsProvider)generator.addProvider(event.includeServer(), (DataProvider)new ModBlockTagsProvider(packOutput, lookUpProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagsProvider(packOutput, lookUpProvider, blockTagsProvider.contentsGetter(), "appletreemod", existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(packOutput, lookUpProvider));
        generator.addProvider(event.includeServer(), (DataProvider)ModLootTables.create(packOutput, lookUpProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModGlobalLootModifierProvider(packOutput, lookUpProvider));
    }
}

