/*
 * Decompiled with CFR 0.152.
 */
package com.snowyhill.appletreemod.datagen.server;

import com.snowyhill.appletreemod.registry.ModBlocks;
import com.snowyhill.appletreemod.registry.ModItems;
import com.snowyhill.appletreemod.tag.ModTags;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;

public class ModRecipeProvider
extends RecipeProvider {
    public ModRecipeProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> lookUpProvider) {
        super(pOutput, lookUpProvider);
    }

    protected void buildRecipes(RecipeOutput pRecipeOutput) {
        ModRecipeProvider.woodFromLogs((RecipeOutput)pRecipeOutput, (ItemLike)((ItemLike)ModBlocks.APPLE_WOOD.get()), (ItemLike)((ItemLike)ModBlocks.APPLE_LOG.get()));
        ModRecipeProvider.woodFromLogs((RecipeOutput)pRecipeOutput, (ItemLike)((ItemLike)ModBlocks.STRIPPED_APPLE_WOOD.get()), (ItemLike)((ItemLike)ModBlocks.STRIPPED_APPLE_LOG.get()));
        ModRecipeProvider.planksFromLog((RecipeOutput)pRecipeOutput, (ItemLike)((ItemLike)ModBlocks.APPLE_PLANKS.get()), ModTags.Items.APPLE_LOG, (int)4);
        ModRecipeProvider.slab((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.APPLE_SLAB.get()), (ItemLike)((ItemLike)ModBlocks.APPLE_PLANKS.get()));
        ModRecipeProvider.stairs(pRecipeOutput, (ItemLike)ModBlocks.APPLE_STAIRS.get(), (ItemLike)ModBlocks.APPLE_PLANKS.get());
        ModRecipeProvider.fence(pRecipeOutput, (ItemLike)ModBlocks.APPLE_FENCE.get(), (ItemLike)ModBlocks.APPLE_PLANKS.get());
        ModRecipeProvider.fenceGate(pRecipeOutput, (ItemLike)ModBlocks.APPLE_FENCE_GATE.get(), (ItemLike)ModBlocks.APPLE_PLANKS.get());
        ModRecipeProvider.door(pRecipeOutput, (ItemLike)ModBlocks.APPLE_DOOR.get(), (ItemLike)ModBlocks.APPLE_PLANKS.get());
        ModRecipeProvider.trapdoor(pRecipeOutput, (ItemLike)ModBlocks.APPLE_TRAPDOOR.get(), (ItemLike)ModBlocks.APPLE_PLANKS.get());
        ModRecipeProvider.button(pRecipeOutput, (ItemLike)ModBlocks.APPLE_BUTTON.get(), (ItemLike)ModBlocks.APPLE_PLANKS.get());
        ModRecipeProvider.pressurePlate((RecipeOutput)pRecipeOutput, (ItemLike)((ItemLike)ModBlocks.APPLE_PRESSURE_PLATE.get()), (ItemLike)((ItemLike)ModBlocks.APPLE_PLANKS.get()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModBlocks.APPLE_PIE.get())).pattern("AAA").pattern("SES").pattern("WWW").define(Character.valueOf('A'), (ItemLike)Items.APPLE).define(Character.valueOf('S'), (ItemLike)Items.SUGAR).define(Character.valueOf('E'), (ItemLike)Items.EGG).define(Character.valueOf('W'), (ItemLike)Items.WHEAT).unlockedBy("has_apple", ModRecipeProvider.has((ItemLike)Items.APPLE)).save(pRecipeOutput);
        ModRecipeProvider.woodFromLogs((RecipeOutput)pRecipeOutput, (ItemLike)((ItemLike)ModBlocks.DARK_APPLE_WOOD.get()), (ItemLike)((ItemLike)ModBlocks.DARK_APPLE_LOG.get()));
        ModRecipeProvider.woodFromLogs((RecipeOutput)pRecipeOutput, (ItemLike)((ItemLike)ModBlocks.STRIPPED_DARK_APPLE_WOOD.get()), (ItemLike)((ItemLike)ModBlocks.STRIPPED_DARK_APPLE_LOG.get()));
        ModRecipeProvider.planksFromLog((RecipeOutput)pRecipeOutput, (ItemLike)((ItemLike)ModBlocks.DARK_APPLE_PLANKS.get()), ModTags.Items.DARK_APPLE_LOG, (int)4);
        ModRecipeProvider.slab((RecipeOutput)pRecipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.DARK_APPLE_SLAB.get()), (ItemLike)((ItemLike)ModBlocks.DARK_APPLE_PLANKS.get()));
        ModRecipeProvider.stairs(pRecipeOutput, (ItemLike)ModBlocks.DARK_APPLE_STAIRS.get(), (ItemLike)ModBlocks.DARK_APPLE_PLANKS.get());
        ModRecipeProvider.fence(pRecipeOutput, (ItemLike)ModBlocks.DARK_APPLE_FENCE.get(), (ItemLike)ModBlocks.DARK_APPLE_PLANKS.get());
        ModRecipeProvider.fenceGate(pRecipeOutput, (ItemLike)ModBlocks.DARK_APPLE_FENCE_GATE.get(), (ItemLike)ModBlocks.DARK_APPLE_PLANKS.get());
        ModRecipeProvider.door(pRecipeOutput, (ItemLike)ModBlocks.DARK_APPLE_DOOR.get(), (ItemLike)ModBlocks.DARK_APPLE_PLANKS.get());
        ModRecipeProvider.trapdoor(pRecipeOutput, (ItemLike)ModBlocks.DARK_APPLE_TRAPDOOR.get(), (ItemLike)ModBlocks.DARK_APPLE_PLANKS.get());
        ModRecipeProvider.button(pRecipeOutput, (ItemLike)ModBlocks.DARK_APPLE_BUTTON.get(), (ItemLike)ModBlocks.DARK_APPLE_PLANKS.get());
        ModRecipeProvider.pressurePlate((RecipeOutput)pRecipeOutput, (ItemLike)((ItemLike)ModBlocks.DARK_APPLE_PRESSURE_PLATE.get()), (ItemLike)((ItemLike)ModBlocks.DARK_APPLE_PLANKS.get()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModBlocks.DARK_APPLE_PIE.get())).pattern("AAA").pattern("SES").pattern("WWW").define(Character.valueOf('A'), (ItemLike)ModItems.DARK_APPLE.get()).define(Character.valueOf('S'), (ItemLike)Items.SUGAR).define(Character.valueOf('E'), (ItemLike)Items.EGG).define(Character.valueOf('W'), (ItemLike)Items.WHEAT).unlockedBy("has_apple", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.DARK_APPLE.get()))).save(pRecipeOutput);
    }

    protected static void oreSmelting(RecipeOutput pRecipeOutput, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup) {
        ModRecipeProvider.oreCooking(pRecipeOutput, RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, pIngredients, pCategory, pResult, pExperience, pCookingTime, pGroup, "_from_smelting");
    }

    protected static void oreBlasting(RecipeOutput pRecipeOutput, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup) {
        ModRecipeProvider.oreCooking(pRecipeOutput, RecipeSerializer.BLASTING_RECIPE, BlastingRecipe::new, pIngredients, pCategory, pResult, pExperience, pCookingTime, pGroup, "_from_blasting");
    }

    private static <T extends AbstractCookingRecipe> void oreCooking(RecipeOutput pRecipeOutput, RecipeSerializer<T> pSerializer, AbstractCookingRecipe.Factory<T> pRecipeFactory, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup, String pSuffix) {
        for (ItemLike itemlike : pIngredients) {
            SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{itemlike}), (RecipeCategory)pCategory, (ItemLike)pResult, (float)pExperience, (int)pCookingTime, pSerializer, pRecipeFactory).group(pGroup).unlockedBy(ModRecipeProvider.getHasName((ItemLike)itemlike), ModRecipeProvider.has((ItemLike)itemlike)).save(pRecipeOutput, "appletreemod:" + ModRecipeProvider.getItemName((ItemLike)pResult) + pSuffix + "_" + ModRecipeProvider.getItemName((ItemLike)itemlike));
        }
    }

    protected static void nineBlockStorageRecipes(RecipeOutput pRecipeOutput, RecipeCategory pUnpackedCategory, ItemLike pUnpacked, RecipeCategory pPackedCategory, ItemLike pPacked) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)pUnpackedCategory, (ItemLike)pUnpacked, (int)9).requires(pPacked).unlockedBy(ModRecipeProvider.getHasName((ItemLike)pPacked), ModRecipeProvider.has((ItemLike)pPacked)).save(pRecipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)pPackedCategory, (ItemLike)pPacked).define(Character.valueOf('#'), pUnpacked).pattern("###").pattern("###").pattern("###").unlockedBy(ModRecipeProvider.getHasName((ItemLike)pUnpacked), ModRecipeProvider.has((ItemLike)pUnpacked)).save(pRecipeOutput);
    }

    private static void stairs(RecipeOutput pRecipeOutput, ItemLike pResult, ItemLike pIngredient) {
        ModRecipeProvider.stairBuilder((ItemLike)pResult, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{pIngredient})).unlockedBy(ModRecipeProvider.getHasName((ItemLike)pIngredient), ModRecipeProvider.has((ItemLike)pIngredient)).save(pRecipeOutput);
    }

    private static void fence(RecipeOutput pRecipeOutput, ItemLike pResult, ItemLike pIngredient) {
        ModRecipeProvider.fenceBuilder((ItemLike)pResult, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{pIngredient})).unlockedBy(ModRecipeProvider.getHasName((ItemLike)pIngredient), ModRecipeProvider.has((ItemLike)pIngredient)).save(pRecipeOutput);
    }

    private static void fenceGate(RecipeOutput pRecipeOutput, ItemLike pResult, ItemLike pIngredient) {
        ModRecipeProvider.fenceGateBuilder((ItemLike)pResult, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{pIngredient})).unlockedBy(ModRecipeProvider.getHasName((ItemLike)pIngredient), ModRecipeProvider.has((ItemLike)pIngredient)).save(pRecipeOutput);
    }

    private static void door(RecipeOutput pRecipeOutput, ItemLike pResult, ItemLike pIngredient) {
        ModRecipeProvider.doorBuilder((ItemLike)pResult, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{pIngredient})).unlockedBy(ModRecipeProvider.getHasName((ItemLike)pIngredient), ModRecipeProvider.has((ItemLike)pIngredient)).save(pRecipeOutput);
    }

    private static void trapdoor(RecipeOutput pRecipeOutput, ItemLike pResult, ItemLike pIngredient) {
        ModRecipeProvider.trapdoorBuilder((ItemLike)pResult, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{pIngredient})).unlockedBy(ModRecipeProvider.getHasName((ItemLike)pIngredient), ModRecipeProvider.has((ItemLike)pIngredient)).save(pRecipeOutput);
    }

    private static void button(RecipeOutput pRecipeOutput, ItemLike pResult, ItemLike pIngredient) {
        ModRecipeProvider.buttonBuilder((ItemLike)pResult, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{pIngredient})).unlockedBy(ModRecipeProvider.getHasName((ItemLike)pIngredient), ModRecipeProvider.has((ItemLike)pIngredient)).save(pRecipeOutput);
    }
}

