/*
 * Decompiled with CFR 0.152.
 */
package com.snowyhill.appletreemod.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DarkAppleItem
extends Item {
    private static final boolean FIFTY_FIFTY = true;
    private static final List<WeightedEffect> POSITIVE = new ArrayList<WeightedEffect>();
    private static final List<WeightedEffect> NEGATIVE = new ArrayList<WeightedEffect>();

    public DarkAppleItem(Item.Properties props) {
        super(props);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        RandomSource rand;
        boolean choosePositive;
        List<WeightedEffect> pool;
        MobEffectInstance picked;
        ItemStack result = super.finishUsingItem(stack, level, entity);
        if (!level.isClientSide && (picked = DarkAppleItem.pickWeighted(pool = (choosePositive = (rand = level.getRandom()).nextBoolean()) ? POSITIVE : NEGATIVE, rand)) != null) {
            entity.addEffect(picked);
        }
        return result;
    }

    @Nullable
    private static MobEffectInstance pickWeighted(List<WeightedEffect> list, RandomSource rand) {
        if (list.isEmpty()) {
            return null;
        }
        int total = 0;
        for (WeightedEffect e : list) {
            total += Math.max(0, e.weight);
        }
        if (total <= 0) {
            return null;
        }
        int r = rand.nextInt(total);
        int acc = 0;
        for (WeightedEffect e : list) {
            if (r >= (acc += Math.max(0, e.weight))) continue;
            return e.newInstance();
        }
        return list.get(list.size() - 1).newInstance();
    }

    public static void applyRandomDarkAppleEffect(LivingEntity entity, Level level) {
        if (level.isClientSide) {
            return;
        }
        RandomSource rand = level.getRandom();
        boolean choosePositive = rand.nextBoolean();
        List<WeightedEffect> pool = choosePositive ? POSITIVE : NEGATIVE;
        MobEffectInstance picked = DarkAppleItem.pickWeighted(pool, rand);
        if (picked != null) {
            entity.addEffect(picked);
        }
    }

    static {
        POSITIVE.add(new WeightedEffect(() -> new MobEffectInstance(MobEffects.REGENERATION, 160, 1), 8));
        POSITIVE.add(new WeightedEffect(() -> new MobEffectInstance(MobEffects.ABSORPTION, 1200, 1), 7));
        POSITIVE.add(new WeightedEffect(() -> new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 1800, 1), 6));
        POSITIVE.add(new WeightedEffect(() -> new MobEffectInstance(MobEffects.DAMAGE_BOOST, 900, 1), 6));
        POSITIVE.add(new WeightedEffect(() -> new MobEffectInstance(MobEffects.JUMP, 1800, 1), 4));
        POSITIVE.add(new WeightedEffect(() -> new MobEffectInstance(MobEffects.LUCK, 2400, 0), 3));
        POSITIVE.add(new WeightedEffect(() -> new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 600, 0), 5));
        NEGATIVE.add(new WeightedEffect(() -> new MobEffectInstance(MobEffects.POISON, 140, 1), 8));
        NEGATIVE.add(new WeightedEffect(() -> new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 900, 1), 6));
        NEGATIVE.add(new WeightedEffect(() -> new MobEffectInstance(MobEffects.WEAKNESS, 1200, 0), 6));
        NEGATIVE.add(new WeightedEffect(() -> new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 1200, 1), 5));
        NEGATIVE.add(new WeightedEffect(() -> new MobEffectInstance(MobEffects.CONFUSION, 400, 0), 5));
        NEGATIVE.add(new WeightedEffect(() -> new MobEffectInstance(MobEffects.UNLUCK, 2400, 0), 3));
        NEGATIVE.add(new WeightedEffect(() -> new MobEffectInstance(MobEffects.BLINDNESS, 240, 0), 4));
    }

    private static class WeightedEffect {
        final EffectFactory factory;
        final int weight;

        WeightedEffect(EffectFactory factory, int weight) {
            this.factory = factory;
            this.weight = weight;
        }

        MobEffectInstance newInstance() {
            return this.factory.create();
        }
    }

    @FunctionalInterface
    private static interface EffectFactory {
        public MobEffectInstance create();
    }
}

