/*
 * Decompiled with CFR 0.152.
 */
package com.snowyhill.appletreemod.worldgen.biome;

import com.snowyhill.appletreemod.worldgen.placement.ModPlacement;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;

public class ModBiomeModifiers {
    public static final ResourceKey<BiomeModifier> ADD_APPLE_TREE = ModBiomeModifiers.createKey("add_apple_tree");
    public static final ResourceKey<BiomeModifier> ADD_DARK_APPLE_TREE = ModBiomeModifiers.createKey("add_dark_apple_tree");

    public static void bootstrap(BootstrapContext<BiomeModifier> context) {
        HolderGetter placedFeatures = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter biomes = context.lookup(Registries.BIOME);
        TagKey AppleTreeBiomeTag = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)new ResourceLocation("appletreemod", "apple_tree_spawnable"));
        context.register(ADD_APPLE_TREE, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(AppleTreeBiomeTag), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ModPlacement.APPLE_TREE)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        TagKey DarkAppleTreeBiomeTag = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)new ResourceLocation("appletreemod", "dark_apple_tree_spawnable"));
        context.register(ADD_DARK_APPLE_TREE, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(DarkAppleTreeBiomeTag), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ModPlacement.DARK_APPLE_TREE)}), GenerationStep.Decoration.VEGETAL_DECORATION));
    }

    private static ResourceKey<BiomeModifier> createKey(String name) {
        return ResourceKey.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("appletreemod", name));
    }
}

