/*
 * Decompiled with CFR 0.152.
 */
package com.snowyhill.appletreemod.worldgen.features.decorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.snowyhill.appletreemod.registry.ModBlocks;
import com.snowyhill.appletreemod.worldgen.features.decorators.ModTreeDecorators;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class DarkAppleOuterFlowersDecorator
extends TreeDecorator {
    public static final MapCodec<DarkAppleOuterFlowersDecorator> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.INT.optionalFieldOf("min_exposed_faces", (Object)2).forGetter(d -> d.minExposedFaces), (App)Codec.FLOAT.optionalFieldOf("outer_chance", (Object)Float.valueOf(0.5f)).forGetter(d -> Float.valueOf(d.outerChance))).apply((Applicative)inst, DarkAppleOuterFlowersDecorator::new));
    protected final int minExposedFaces;
    protected final float outerChance;

    public DarkAppleOuterFlowersDecorator(int minExposedFaces, float outerChance) {
        this.minExposedFaces = Math.max(1, minExposedFaces);
        this.outerChance = Math.max(0.0f, Math.min(1.0f, outerChance));
    }

    public DarkAppleOuterFlowersDecorator(int minExposedFaces) {
        this(minExposedFaces, 0.3f);
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)ModTreeDecorators.DARK_APPLE_OUTER_FLOWERS.get();
    }

    public void place(TreeDecorator.Context ctx) {
        LevelSimulatedReader level = ctx.level();
        HashSet logs = new HashSet(ctx.logs());
        HashSet leaves = new HashSet(ctx.leaves());
        BlockState flower = ((Block)ModBlocks.DARK_APPLE_FLOWER_LEAVES.get()).defaultBlockState();
        for (BlockPos pos : leaves) {
            RandomSource rand;
            boolean isAppleLeaves = level.isStateAtPosition(pos, s -> s.is((Block)ModBlocks.DARK_APPLE_LEAVES.get()));
            if (!isAppleLeaves) continue;
            int exposed = 0;
            boolean nearLog = false;
            for (Direction d : Direction.values()) {
                BlockPos n = pos.relative(d);
                if (level.isStateAtPosition(n, s -> s.isAir() || !s.getFluidState().isEmpty())) {
                    ++exposed;
                }
                if (!logs.contains(n) && !level.isStateAtPosition(n, s -> s.is(BlockTags.LOGS))) continue;
                nearLog = true;
            }
            if (nearLog || exposed < this.minExposedFaces || !((rand = RandomSource.create((long)(pos.asLong() ^ ctx.random().nextLong()))).nextFloat() < this.outerChance)) continue;
            ctx.setBlock(pos, flower);
        }
    }
}

