/*
 * Decompiled with CFR 0.152.
 */
package com.snowyhill.appletreemod.worldgen.placement;

import com.snowyhill.appletreemod.registry.ModBlocks;
import com.snowyhill.appletreemod.worldgen.features.ModFeatures;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class ModPlacement {
    public static final ResourceKey<PlacedFeature> APPLE_TREE = ModPlacement.createKey("apple_tree");
    public static final ResourceKey<PlacedFeature> DARK_APPLE_TREE = ModPlacement.createKey("dark_apple_tree");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        PlacementUtils.register(context, APPLE_TREE, (Holder)configuredFeatures.getOrThrow(ModFeatures.APPLE_TREE_KEY), (List)VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)0, (float)0.2f, (int)1), (Block)((Block)ModBlocks.APPLE_SAPLING.get())));
        PlacementUtils.register(context, DARK_APPLE_TREE, (Holder)configuredFeatures.getOrThrow(ModFeatures.DARK_APPLE_TREE_KEY), (List)VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)0, (float)0.5f, (int)1), (Block)((Block)ModBlocks.DARK_APPLE_SAPLING.get())));
    }

    private static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)new ResourceLocation("appletreemod", name));
    }

    private static List<PlacementModifier> orePlacement(PlacementModifier pCountPlacement, PlacementModifier pHeightRange) {
        return List.of(pCountPlacement, InSquarePlacement.spread(), pHeightRange, BiomeFilter.biome());
    }

    private static List<PlacementModifier> commonOrePlacement(int pCount, PlacementModifier pHeightRange) {
        return ModPlacement.orePlacement((PlacementModifier)CountPlacement.of((int)pCount), pHeightRange);
    }

    private static List<PlacementModifier> rareOrePlacement(int pChance, PlacementModifier pHeightRange) {
        return ModPlacement.orePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)pChance), pHeightRange);
    }
}

