/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Locale;
import org.bukkit.DyeColor;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.entity.Sittable;
import org.bukkit.entity.Tameable;
import org.bukkit.registry.RegistryAware;
import org.bukkit.util.OldEnum;
import org.jetbrains.annotations.NotNull;

public interface Cat
extends Tameable,
Sittable {
    @NotNull
    public Type getCatType();

    public void setCatType(@NotNull Type var1);

    @NotNull
    public DyeColor getCollarColor();

    public void setCollarColor(@NotNull DyeColor var1);

    public static interface Type
    extends OldEnum<Type>,
    Keyed,
    RegistryAware {
        public static final Type TABBY = Type.getType("tabby");
        public static final Type BLACK = Type.getType("black");
        public static final Type RED = Type.getType("red");
        public static final Type SIAMESE = Type.getType("siamese");
        public static final Type BRITISH_SHORTHAIR = Type.getType("british_shorthair");
        public static final Type CALICO = Type.getType("calico");
        public static final Type PERSIAN = Type.getType("persian");
        public static final Type RAGDOLL = Type.getType("ragdoll");
        public static final Type WHITE = Type.getType("white");
        public static final Type JELLIE = Type.getType("jellie");
        public static final Type ALL_BLACK = Type.getType("all_black");

        @NotNull
        private static Type getType(@NotNull String key) {
            return Registry.CAT_VARIANT.getOrThrow(NamespacedKey.minecraft(key));
        }

        @Override
        @Deprecated(since="1.21.4")
        @NotNull
        public NamespacedKey getKey();

        @Deprecated(since="1.21")
        @NotNull
        public static Type valueOf(@NotNull String name) {
            Type type = Registry.CAT_VARIANT.get(NamespacedKey.fromString(name.toLowerCase(Locale.ROOT)));
            Preconditions.checkArgument(type != null, "No cat type found with the name %s", (Object)name);
            return type;
        }

        @Deprecated(since="1.21")
        @NotNull
        public static Type[] values() {
            return Lists.newArrayList(Registry.CAT_VARIANT).toArray(new Type[0]);
        }
    }
}

