/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.smeltedores;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;

public class SmeltedOres
extends JavaPlugin
implements Listener {
    private FileConfiguration config;
    private Map<Material, Material> oreToSmelted;
    private Map<Material, Integer> dropQuantities;
    private Set<UUID> enabledPlayers;
    private boolean defaultEnabled;
    private boolean requirePermission;
    private String permission;
    private boolean fortuneEnabled;
    private double fortuneMultiplier;
    private double dropMultiplier;
    private boolean giveExperience;
    private double experienceMultiplier;
    private Random random;
    private boolean debugMode;

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.oreToSmelted = new HashMap<Material, Material>();
        this.dropQuantities = new HashMap<Material, Integer>();
        this.enabledPlayers = new HashSet<UUID>();
        this.random = new Random();
        this.loadConfiguration();
        this.getServer().getPluginManager().registerEvents(this, this);
        this.getLogger().info("SmeltedOres has been enabled!");
        this.getLogger().info("Loaded " + this.oreToSmelted.size() + " ore mappings.");
    }

    @Override
    public void onDisable() {
        this.oreToSmelted.clear();
        this.dropQuantities.clear();
        this.enabledPlayers.clear();
        this.getLogger().info("SmeltedOres has been disabled!");
    }

    private void loadConfiguration() {
        this.defaultEnabled = this.config.getBoolean("default-enabled", false);
        this.requirePermission = this.config.getBoolean("require-permission", true);
        this.permission = this.config.getString("permission", "smeltedores.use");
        this.fortuneEnabled = this.config.getBoolean("fortune-enabled", true);
        this.fortuneMultiplier = this.config.getDouble("fortune-multiplier", 1.0);
        this.dropMultiplier = this.config.getDouble("drop-multiplier", 1.0);
        this.giveExperience = this.config.getBoolean("give-experience", true);
        this.experienceMultiplier = this.config.getDouble("experience-multiplier", 1.0);
        this.debugMode = this.config.getBoolean("debug-mode", false);
        this.loadOreMappings();
        this.loadDropQuantities();
    }

    private void loadOreMappings() {
        this.oreToSmelted.clear();
        if (this.config.isConfigurationSection("ore-mappings")) {
            for (String key : this.config.getConfigurationSection("ore-mappings").getKeys(false)) {
                try {
                    Material oreMaterial = Material.valueOf(key.toUpperCase());
                    Material smeltedMaterial = Material.valueOf(this.config.getString("ore-mappings." + key).toUpperCase());
                    this.oreToSmelted.put(oreMaterial, smeltedMaterial);
                    this.getLogger().info("Added mapping: " + String.valueOf(oreMaterial) + " -> " + String.valueOf(smeltedMaterial));
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().warning("Invalid material in config: " + key + " or " + this.config.getString("ore-mappings." + key));
                }
            }
        }
        if (this.oreToSmelted.isEmpty()) {
            this.getLogger().warning("No valid ore mappings found in config. Adding defaults.");
            this.oreToSmelted.put(Material.IRON_ORE, Material.IRON_INGOT);
            this.oreToSmelted.put(Material.DEEPSLATE_IRON_ORE, Material.IRON_INGOT);
            this.oreToSmelted.put(Material.GOLD_ORE, Material.GOLD_INGOT);
            this.oreToSmelted.put(Material.DEEPSLATE_GOLD_ORE, Material.GOLD_INGOT);
            this.oreToSmelted.put(Material.COPPER_ORE, Material.COPPER_INGOT);
            this.oreToSmelted.put(Material.DEEPSLATE_COPPER_ORE, Material.COPPER_INGOT);
            this.oreToSmelted.put(Material.ANCIENT_DEBRIS, Material.NETHERITE_SCRAP);
            this.oreToSmelted.put(Material.SAND, Material.GLASS);
        }
    }

    private void loadDropQuantities() {
        this.dropQuantities.clear();
        if (this.config.isConfigurationSection("drop-quantities")) {
            for (String key : this.config.getConfigurationSection("drop-quantities").getKeys(false)) {
                try {
                    Material material = Material.valueOf(key.toUpperCase());
                    int quantity = this.config.getInt("drop-quantities." + key, 1);
                    this.dropQuantities.put(material, quantity);
                    this.getLogger().info("Added quantity: " + String.valueOf(material) + " -> " + quantity);
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().warning("Invalid material in drop quantities: " + key);
                }
            }
        }
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command can only be executed by a player!");
            return true;
        }
        Player player = (Player)sender;
        if (command.getName().equalsIgnoreCase("smeltedores")) {
            if (this.requirePermission && !player.hasPermission(this.permission)) {
                player.sendMessage("\u00a7cYou don't have permission to use this command!");
                return true;
            }
            if (args.length == 0) {
                this.toggleSmeltedOres(player);
                return true;
            }
            if (args.length == 1) {
                if (args[0].equalsIgnoreCase("on")) {
                    this.enableSmeltedOres(player);
                    return true;
                }
                if (args[0].equalsIgnoreCase("off")) {
                    this.disableSmeltedOres(player);
                    return true;
                }
                if (args[0].equalsIgnoreCase("status")) {
                    this.sendStatus(player);
                    return true;
                }
                if (args[0].equalsIgnoreCase("list") && player.hasPermission("smeltedores.admin")) {
                    this.sendMappingsList(player);
                    return true;
                }
                if (args[0].equalsIgnoreCase("debug") && player.hasPermission("smeltedores.admin")) {
                    this.debugMode = !this.debugMode;
                    player.sendMessage("\u00a76Debug mode is now " + (this.debugMode ? "\u00a7aenabled" : "\u00a7cdisabled"));
                    return true;
                }
                if (args[0].equalsIgnoreCase("reload") && player.hasPermission("smeltedores.admin")) {
                    this.reloadConfig();
                    this.config = this.getConfig();
                    this.loadConfiguration();
                    player.sendMessage("\u00a7aSmeltedOres configuration reloaded!");
                    return true;
                }
            }
            player.sendMessage("\u00a76--- SmeltedOres Commands ---");
            player.sendMessage("\u00a7e/smeltedores - Toggle auto-smelting");
            player.sendMessage("\u00a7e/smeltedores on - Enable auto-smelting");
            player.sendMessage("\u00a7e/smeltedores off - Disable auto-smelting");
            player.sendMessage("\u00a7e/smeltedores status - Show current status");
            if (player.hasPermission("smeltedores.admin")) {
                player.sendMessage("\u00a7e/smeltedores list - List all configured ore mappings");
                player.sendMessage("\u00a7e/smeltedores debug - Toggle debug mode");
                player.sendMessage("\u00a7e/smeltedores reload - Reload config");
            }
            return true;
        }
        return false;
    }

    private void toggleSmeltedOres(Player player) {
        UUID playerId = player.getUniqueId();
        if (this.defaultEnabled) {
            if (this.enabledPlayers.contains(playerId)) {
                this.enabledPlayers.remove(playerId);
                player.sendMessage("\u00a7aAuto-smelting has been turned on! (Back to default)");
            } else {
                this.enabledPlayers.add(playerId);
                player.sendMessage("\u00a7cAuto-smelting has been turned off!");
            }
        } else if (this.enabledPlayers.contains(playerId)) {
            this.enabledPlayers.remove(playerId);
            player.sendMessage("\u00a7cAuto-smelting has been turned off! (Back to default)");
        } else {
            this.enabledPlayers.add(playerId);
            player.sendMessage("\u00a7aAuto-smelting has been turned on!");
        }
    }

    private void enableSmeltedOres(Player player) {
        UUID playerId = player.getUniqueId();
        if (this.defaultEnabled) {
            this.enabledPlayers.remove(playerId);
        } else {
            this.enabledPlayers.add(playerId);
        }
        player.sendMessage("\u00a7aAuto-smelting has been turned on!");
    }

    private void disableSmeltedOres(Player player) {
        UUID playerId = player.getUniqueId();
        if (this.defaultEnabled) {
            this.enabledPlayers.add(playerId);
        } else {
            this.enabledPlayers.remove(playerId);
        }
        player.sendMessage("\u00a7cAuto-smelting has been turned off!");
    }

    private void sendStatus(Player player) {
        UUID playerId = player.getUniqueId();
        boolean enabled = this.isPlayerEnabled(player);
        player.sendMessage("\u00a76Auto-smelting is currently " + (enabled ? "\u00a7aenabled" : "\u00a7cdisabled") + "\u00a76 for you.");
        if (this.debugMode) {
            player.sendMessage("\u00a77DEBUG: defaultEnabled=" + this.defaultEnabled);
            player.sendMessage("\u00a77DEBUG: In enabledPlayers set: " + this.enabledPlayers.contains(playerId));
        }
    }

    private boolean isPlayerEnabled(Player player) {
        UUID playerId = player.getUniqueId();
        return this.defaultEnabled != this.enabledPlayers.contains(playerId);
    }

    private void sendMappingsList(Player player) {
        player.sendMessage("\u00a76--- SmeltedOres Mappings ---");
        for (Map.Entry<Material, Material> entry : this.oreToSmelted.entrySet()) {
            int quantity = this.dropQuantities.getOrDefault(entry.getKey(), 1);
            player.sendMessage("\u00a7e" + String.valueOf(entry.getKey()) + " \u00a77\u2192 \u00a76" + quantity + "x " + String.valueOf(entry.getValue()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        Material blockType = block.getType();
        if (this.requirePermission && !player.hasPermission(this.permission)) {
            if (this.debugMode) {
                player.sendMessage("\u00a77DEBUG: No permission.");
            }
            return;
        }
        boolean autoSmeltEnabled = this.isPlayerEnabled(player);
        if (!autoSmeltEnabled) {
            if (this.debugMode && this.oreToSmelted.containsKey(blockType)) {
                player.sendMessage("\u00a77DEBUG: Auto-smelting disabled for player.");
            }
            return;
        }
        if (this.oreToSmelted.containsKey(blockType)) {
            if (this.debugMode) {
                player.sendMessage("\u00a77DEBUG: Processing " + String.valueOf(blockType) + " for auto-smelting.");
            }
            Material smeltedMaterial = this.oreToSmelted.get(blockType);
            int dropAmount = this.calculateDropAmount(player, block, blockType);
            if (this.debugMode) {
                player.sendMessage("\u00a77DEBUG: Will drop " + dropAmount + "x " + String.valueOf(smeltedMaterial));
            }
            event.setDropItems(false);
            ItemStack smeltedItem = new ItemStack(smeltedMaterial, dropAmount);
            block.getWorld().dropItemNaturally(block.getLocation(), smeltedItem);
            if (this.giveExperience) {
                float experience = 1.0f;
                if ((experience = (float)((double)experience * this.experienceMultiplier)) > 0.0f) {
                    event.setExpToDrop(Math.round(experience));
                    if (this.debugMode) {
                        player.sendMessage("\u00a77DEBUG: Set exp to " + Math.round(experience));
                    }
                }
            }
        } else if (this.debugMode && autoSmeltEnabled) {
            player.sendMessage("\u00a77DEBUG: Block " + String.valueOf(blockType) + " not in mapping list.");
        }
    }

    private int calculateDropAmount(Player player, Block block, Material blockType) {
        int fortuneLevel;
        ItemMeta meta;
        ItemStack tool;
        int baseAmount = this.dropQuantities.getOrDefault(blockType, 1);
        baseAmount = (int)Math.ceil((double)baseAmount * this.dropMultiplier);
        if (this.fortuneEnabled && player.getInventory().getItemInMainHand() != null && (tool = player.getInventory().getItemInMainHand()).hasItemMeta() && (meta = tool.getItemMeta()).hasEnchant(Enchantment.FORTUNE) && (fortuneLevel = meta.getEnchantLevel(Enchantment.FORTUNE)) > 0) {
            for (int i = 0; i < fortuneLevel; ++i) {
                if (!((double)this.random.nextFloat() <= 0.33 * this.fortuneMultiplier)) continue;
                ++baseAmount;
            }
            if (this.debugMode) {
                player.sendMessage("\u00a77DEBUG: Applied Fortune " + fortuneLevel + " to drops.");
            }
        }
        return Math.max(1, baseAmount);
    }
}

