/*
 * Decompiled with CFR 0.152.
 */
package de.n8M4.deathcoords;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.joml.Matrix4f;

@Mod(value="deathcoords")
public class Deathcoords {
    public static final String MODID = "deathcoords";
    private static String deathMessage = "";
    private static boolean displayMessage = false;
    private static boolean wasDead = false;

    public Deathcoords() {
        MinecraftForge.EVENT_BUS.register((Object)new HudOverlayRenderer());
        MinecraftForge.EVENT_BUS.register((Object)new DeathEventHandler());
        NetworkHandler.register();
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"display_death").executes(context -> {
            displayMessage = !displayMessage;
            return 1;
        }));
    }

    @Mod.EventBusSubscriber(modid="deathcoords", value={Dist.CLIENT})
    public static class HudOverlayRenderer {
        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public void onRenderGui(RenderGuiEvent.Post event) {
            if (!displayMessage) {
                return;
            }
            PoseStack poseStack = event.getGuiGraphics().m_280168_();
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == null) {
                return;
            }
            int screenWidth = mc.m_91268_().m_85445_();
            int screenHeight = mc.m_91268_().m_85446_();
            int x = screenWidth / 2 - mc.f_91062_.m_92895_(deathMessage) / 2;
            int y = screenHeight - 55;
            MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 0.0f);
            Matrix4f matrix = poseStack.m_85850_().m_252922_();
            mc.f_91062_.m_271703_(deathMessage, (float)x, (float)y, 0xFFFFFF, true, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            bufferSource.m_109911_();
            poseStack.m_85849_();
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public void onClientTick(TickEvent.ClientTickEvent event) {
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            if (player != null) {
                boolean isDead;
                boolean bl = isDead = player.m_21223_() <= 0.0f;
                if (isDead && !wasDead) {
                    String location = DeathEventHandler.getStringFromCoords((Player)player);
                    if (!ClientModState.SERVER_HAS_MOD) {
                        player.m_5661_((Component)Component.m_237113_((String)("\u00a7aYou died at " + location)), false);
                    }
                }
                wasDead = isDead;
            }
        }

        @SubscribeEvent
        public static void onPlayerLogin(ClientPlayerNetworkEvent.LoggingIn event) {
            ClientModState.SERVER_HAS_MOD = false;
        }
    }

    @Mod.EventBusSubscriber(modid="deathcoords", value={Dist.CLIENT})
    public static class DeathEventHandler {
        @SubscribeEvent
        public void onPlayerDeath(LivingDeathEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7aYou died at " + DeathEventHandler.getStringFromCoords(player))));
            }
        }

        public static String getStringFromCoords(Player player) {
            deathMessage = "\u00a72[\u00a76x: " + (int)player.m_20185_() + "\u00a72]\u00a7r, \u00a72[\u00a76y: " + (int)player.m_20186_() + "\u00a72]\u00a7r, \u00a72[\u00a76z: " + (int)player.m_20189_() + "\u00a72]\u00a7a, in \u00a76" + String.valueOf(player.m_9236_().m_46472_().m_135782_());
            return deathMessage;
        }

        @SubscribeEvent
        public void registerCommands(RegisterClientCommandsEvent event) {
            Deathcoords.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }
    }

    public class NetworkHandler {
        public static SimpleChannel CHANNEL;

        public static void register() {
            CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(Deathcoords.MODID, "network")).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).networkProtocolVersion(() -> "1").simpleChannel();
            int id = 0;
            CHANNEL.messageBuilder(ServerHasModPacket.class, id++).encoder(ServerHasModPacket::encode).decoder(ServerHasModPacket::decode).consumerMainThread(ServerHasModPacket::handle).add();
        }
    }

    public record ServerHasModPacket() {
        public static void encode(ServerHasModPacket msg, FriendlyByteBuf buf) {
        }

        public static ServerHasModPacket decode(FriendlyByteBuf buf) {
            return new ServerHasModPacket();
        }

        public static void handle(ServerHasModPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ClientModState.SERVER_HAS_MOD = true;
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class ClientModState {
        public static boolean SERVER_HAS_MOD = false;
    }

    @Mod.EventBusSubscriber(modid="deathcoords")
    public static class ServerEvents {
        @SubscribeEvent
        public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new ServerHasModPacket());
            }
        }
    }
}

