/*
 * Decompiled with CFR 0.152.
 */
package designermodeling;

import designermodeling.Data;
import designermodeling.Objects;
import designermodeling.Process;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class Network {
    private static final SimpleNetworkWrapper DISPATCHER = NetworkRegistry.INSTANCE.newSimpleChannel("designermodeling");
    private static byte PACKET_ID;

    public static void register() {
        Network.register(Server.PacketSendGenServer.class, Side.SERVER);
        Network.register(Server.PacketSetRotateServer.class, Side.SERVER);
        Network.register(Server.PacketControlServer.class, Side.SERVER);
        Network.register(Client.PacketSendGenClient.class, Side.CLIENT);
        Network.register(Client.PacketSetRotateClient.class, Side.CLIENT);
        Network.register(Client.PacketControlClient.class, Side.CLIENT);
    }

    public static void sendToClient(IMessage message, EntityPlayerMP player) {
        DISPATCHER.sendTo(message, player);
    }

    public static void sendToServer(IMessage message) {
        DISPATCHER.sendToServer(message);
    }

    public static <REQ extends IMessage & IMessageHandler<REQ, IMessage>> void register(Class<REQ> message, Side side) {
        byte by = PACKET_ID;
        PACKET_ID = (byte)(by + 1);
        DISPATCHER.registerMessage(message, message, (int)by, side);
    }

    protected static class Client {
        protected Client() {
        }

        public static class PacketControlClient
        implements IMessageHandler<PacketControlClient, IMessage>,
        IMessage {
            int x;
            int y;
            int z;

            public PacketControlClient() {
            }

            public PacketControlClient(int x, int y, int z) {
                this.x = x;
                this.y = y;
                this.z = z;
            }

            public void fromBytes(ByteBuf buf) {
                NBTTagCompound tag = new NBTTagCompound();
                tag = ByteBufUtils.readTag((ByteBuf)buf);
                this.x = tag.func_74762_e("SlotX");
                this.y = tag.func_74762_e("SlotY");
                this.z = tag.func_74762_e("SlotZ");
            }

            public void toBytes(ByteBuf buf) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("SlotX", this.x);
                tag.func_74768_a("SlotY", this.y);
                tag.func_74768_a("SlotZ", this.z);
                ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
            }

            public IMessage onMessage(PacketControlClient message, MessageContext ctx) {
                Minecraft.func_71410_x().func_152344_a(() -> {
                    if (Minecraft.func_71410_x().field_71439_g.field_70170_p.field_72995_K) {
                        Process.Containers.dm con = (Process.Containers.dm)Minecraft.func_71410_x().field_71439_g.field_71070_bA;
                        ((Objects.TileEntity.dm)con.dm).setSlotY(message.y);
                        con.field_75151_b.clear();
                        con.addSlot(con.playerInventory, con.dm, message.x, message.y, message.z);
                    }
                });
                return null;
            }
        }

        public static class PacketSetRotateClient
        implements IMessageHandler<PacketSetRotateClient, IMessage>,
        IMessage {
            int x;
            int y;
            int z;
            int floor;
            int i;
            int r;

            public PacketSetRotateClient() {
            }

            public PacketSetRotateClient(int x, int y, int z, int floor, int i, int r) {
                this.x = x;
                this.y = y;
                this.z = z;
                this.floor = floor;
                this.i = i;
                this.r = r;
            }

            public void fromBytes(ByteBuf buf) {
                NBTTagCompound tag = new NBTTagCompound();
                tag = ByteBufUtils.readTag((ByteBuf)buf);
                this.x = tag.func_74762_e("getX");
                this.y = tag.func_74762_e("getY");
                this.z = tag.func_74762_e("getZ");
                this.floor = tag.func_74762_e("getFloor");
                this.i = tag.func_74762_e("Index");
                this.r = tag.func_74762_e("Rotate");
            }

            public void toBytes(ByteBuf buf) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("getX", this.x);
                tag.func_74768_a("getY", this.y);
                tag.func_74768_a("getZ", this.z);
                tag.func_74768_a("getFloor", this.floor);
                tag.func_74768_a("Index", this.i);
                tag.func_74768_a("Rotate", this.r);
                ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
            }

            public IMessage onMessage(PacketSetRotateClient message, MessageContext ctx) {
                Minecraft.func_71410_x().func_152344_a(() -> new Data.Client().setRotate(message.x, message.y, message.z, message.floor, message.i, message.r));
                return null;
            }
        }

        public static class PacketSendGenClient
        implements IMessageHandler<PacketSendGenClient, IMessage>,
        IMessage {
            int[] itemArray;
            int[] metaArray;
            int floor;
            int x;
            int y;
            int z;

            public PacketSendGenClient() {
            }

            public PacketSendGenClient(int floor, int[] itemArray, int[] metaArray, int x, int y, int z) {
                this.floor = floor;
                this.x = x;
                this.y = y;
                this.z = z;
                this.itemArray = itemArray;
                this.metaArray = metaArray;
            }

            public void fromBytes(ByteBuf buf) {
                NBTTagCompound tag = new NBTTagCompound();
                tag = ByteBufUtils.readTag((ByteBuf)buf);
                this.floor = tag.func_74762_e("getFloor");
                this.itemArray = tag.func_74759_k("getItemArray");
                this.metaArray = tag.func_74759_k("getMetaArray");
                this.x = tag.func_74762_e("getX");
                this.y = tag.func_74762_e("getY");
                this.z = tag.func_74762_e("getZ");
            }

            public void toBytes(ByteBuf buf) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("getFloor", this.floor);
                tag.func_74783_a("getItemArray", this.itemArray);
                tag.func_74783_a("getMetaArray", this.metaArray);
                tag.func_74768_a("getX", this.x);
                tag.func_74768_a("getY", this.y);
                tag.func_74768_a("getZ", this.z);
                ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
            }

            public IMessage onMessage(PacketSendGenClient message, MessageContext ctx) {
                Minecraft.func_71410_x().func_152344_a(() -> new Data.Client().updateDM(message.floor, message.itemArray, message.metaArray, message.x, message.y, message.z));
                return null;
            }
        }
    }

    protected static class Server {
        protected Server() {
        }

        public static class PacketControlServer
        implements IMessageHandler<PacketControlServer, IMessage>,
        IMessage {
            int x;
            int y;
            int z;

            public PacketControlServer() {
            }

            public PacketControlServer(int x, int y, int z) {
                this.x = x;
                this.y = y;
                this.z = z;
            }

            public void fromBytes(ByteBuf buf) {
                NBTTagCompound tag = new NBTTagCompound();
                tag = ByteBufUtils.readTag((ByteBuf)buf);
                this.x = tag.func_74762_e("SlotX");
                this.y = tag.func_74762_e("SlotY");
                this.z = tag.func_74762_e("SlotZ");
            }

            public void toBytes(ByteBuf buf) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("SlotX", this.x);
                tag.func_74768_a("SlotY", this.y);
                tag.func_74768_a("SlotZ", this.z);
                ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
            }

            public IMessage onMessage(PacketControlServer message, MessageContext ctx) {
                ctx.getServerHandler().field_147369_b.func_184102_h().func_152344_a(() -> {
                    if (!ctx.getServerHandler().field_147369_b.field_70170_p.field_72995_K) {
                        Process.Containers.dm con = (Process.Containers.dm)ctx.getServerHandler().field_147369_b.field_71070_bA;
                        ((Objects.TileEntity.dm)con.dm).setSlotY(message.y);
                        con.field_75151_b.clear();
                        con.addSlot(con.playerInventory, con.dm, message.x, message.y, message.z);
                        Network.sendToClient(new PacketControlServer(message.x, message.y, message.z), ctx.getServerHandler().field_147369_b);
                    }
                });
                return null;
            }
        }

        public static class PacketSetRotateServer
        implements IMessageHandler<PacketSetRotateServer, IMessage>,
        IMessage {
            int x;
            int y;
            int z;
            int floor;
            int i;

            public PacketSetRotateServer() {
            }

            public PacketSetRotateServer(int x, int y, int z, int floor, int i) {
                this.x = x;
                this.y = y;
                this.z = z;
                this.floor = floor;
                this.i = i;
            }

            public void fromBytes(ByteBuf buf) {
                NBTTagCompound tag = new NBTTagCompound();
                tag = ByteBufUtils.readTag((ByteBuf)buf);
                this.x = tag.func_74762_e("getX");
                this.y = tag.func_74762_e("getY");
                this.z = tag.func_74762_e("getZ");
                this.floor = tag.func_74762_e("getFloor");
                this.i = tag.func_74762_e("Index");
            }

            public void toBytes(ByteBuf buf) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("getX", this.x);
                tag.func_74768_a("getY", this.y);
                tag.func_74768_a("getZ", this.z);
                tag.func_74768_a("getFloor", this.floor);
                tag.func_74768_a("Index", this.i);
                ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
            }

            public IMessage onMessage(PacketSetRotateServer message, MessageContext ctx) {
                ctx.getServerHandler().field_147369_b.func_184102_h().func_152344_a(() -> {
                    BlockPos pos = new BlockPos(message.x, message.y, message.z);
                    World world = ctx.getServerHandler().field_147369_b.field_70170_p;
                    Objects.TileEntity.dm tileentity = (Objects.TileEntity.dm)world.func_175625_s(pos);
                    tileentity.func_70296_d();
                    int rotate = tileentity.getRotate(message.floor, message.i);
                    rotate = rotate < 11 ? ++rotate : 0;
                    tileentity.setRotate(message.floor, message.i, rotate);
                    for (EntityPlayer player : world.field_73010_i) {
                        EntityPlayerMP spe = (EntityPlayerMP)player;
                        if (!(spe instanceof EntityPlayerMP) || !(tileentity instanceof Objects.TileEntity.dm)) continue;
                        Network.sendToClient(new Client.PacketSetRotateClient(message.x, message.y, message.z, message.floor, message.i, rotate), spe);
                    }
                });
                return null;
            }
        }

        public static class PacketSendGenServer
        implements IMessageHandler<PacketSendGenServer, IMessage>,
        IMessage {
            int x;
            int y;
            int z;

            public PacketSendGenServer() {
            }

            public PacketSendGenServer(int x, int y, int z) {
                this.x = x;
                this.y = y;
                this.z = z;
            }

            public void fromBytes(ByteBuf buf) {
                NBTTagCompound tag = new NBTTagCompound();
                tag = ByteBufUtils.readTag((ByteBuf)buf);
                this.x = tag.func_74762_e("getX");
                this.y = tag.func_74762_e("getY");
                this.z = tag.func_74762_e("getZ");
            }

            public void toBytes(ByteBuf buf) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("getX", this.x);
                tag.func_74768_a("getY", this.y);
                tag.func_74768_a("getZ", this.z);
                ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
            }

            public IMessage onMessage(PacketSendGenServer message, MessageContext ctx) {
                ctx.getServerHandler().field_147369_b.func_184102_h().func_152344_a(() -> {
                    World world = ctx.getServerHandler().field_147369_b.field_70170_p;
                    Objects.TileEntity.dm tileentity = (Objects.TileEntity.dm)world.func_175625_s(new BlockPos(message.x, message.y, message.z));
                    if (tileentity instanceof Objects.TileEntity.dm) {
                        for (int y = 0; y < tileentity.chestContents.size(); ++y) {
                            for (int id = 0; id < tileentity.chestContents.get(y).size(); ++id) {
                                tileentity.setSingleArray(y, id, Item.func_150891_b((Item)((ItemStack)tileentity.chestContents.get(y).get(id)).func_77973_b()), ((ItemStack)tileentity.chestContents.get(y).get(id)).func_77960_j());
                            }
                        }
                        tileentity.func_70296_d();
                        for (EntityPlayer player : world.field_73010_i) {
                            EntityPlayerMP spe = (EntityPlayerMP)player;
                            for (int id = 0; id < tileentity.itemGrid.length; ++id) {
                                Network.sendToClient(new Client.PacketSendGenClient(id, tileentity.getMultiArrayItem(id), tileentity.getMultiArrayMeta(id), message.x, message.y, message.z), spe);
                            }
                        }
                    }
                });
                return null;
            }
        }
    }
}

