/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.databindings.api;

import com.github.franckyi.databindings.api.DataBindings;
import com.github.franckyi.databindings.api.ObservableBooleanValue;
import com.github.franckyi.databindings.api.ObservableDoubleValue;
import com.github.franckyi.databindings.api.ObservableIntegerValue;
import com.github.franckyi.databindings.api.ObservableObjectValue;
import com.github.franckyi.databindings.api.ObservableStringValue;
import com.github.franckyi.databindings.api.event.ObservableValueChangeListener;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;

public interface ObservableValue<T>
extends Supplier<T> {
    @Override
    public T get();

    public void addListener(ObservableValueChangeListener<? super T> var1);

    default public ObservableValueChangeListener<? super T> addListener(Consumer<? super T> listener) {
        ObservableValueChangeListener<Object> realListener = (oldVal, newVal) -> listener.accept(newVal);
        this.addListener(realListener);
        return realListener;
    }

    default public ObservableValueChangeListener<? super T> addListener(Runnable listener) {
        ObservableValueChangeListener<Object> realListener = (oldVal, newVal) -> listener.run();
        this.addListener(realListener);
        return realListener;
    }

    public void removeListener(ObservableValueChangeListener<? super T> var1);

    public static <T> ObservableValue<T> unmodifiable(final T value) {
        return new Unmodifiable<T>(){

            @Override
            public T get() {
                return value;
            }
        };
    }

    public static <T> ObservableValue<T> observe(Supplier<T> valueSupplier, ObservableValue<?> ... triggers) {
        return DataBindings.getMappingFactory().createMapping(valueSupplier, triggers);
    }

    default public <X> ObservableObjectValue<X> map(Function<T, X> mapper) {
        return ObservableObjectValue.observe(() -> mapper.apply(this.get()), this);
    }

    default public <X> ObservableObjectValue<X> map(Function<T, X> mapper, X orIfNull) {
        return ObservableObjectValue.observe(() -> this.get() == null ? orIfNull : mapper.apply(this.get()), this);
    }

    default public ObservableStringValue mapToString(Function<T, String> mapper) {
        return ObservableStringValue.observe(() -> (String)mapper.apply(this.get()), new ObservableValue[]{this});
    }

    default public ObservableStringValue mapToString(Function<T, String> mapper, String orIfNull) {
        return ObservableStringValue.observe(() -> this.get() == null ? orIfNull : (String)mapper.apply(this.get()), new ObservableValue[]{this});
    }

    default public ObservableBooleanValue mapToBoolean(Predicate<T> mapper) {
        return ObservableBooleanValue.observe(() -> mapper.test(this.get()), this);
    }

    default public ObservableBooleanValue mapToBoolean(Predicate<T> mapper, boolean orIfNull) {
        return ObservableBooleanValue.observe(() -> this.get() == null ? orIfNull : mapper.test(this.get()), this);
    }

    default public ObservableIntegerValue mapToInt(ToIntFunction<T> mapper) {
        return ObservableIntegerValue.observe(() -> mapper.applyAsInt(this.get()), this);
    }

    default public ObservableIntegerValue mapToInt(ToIntFunction<T> mapper, int orIfNull) {
        return ObservableIntegerValue.observe(() -> this.get() == null ? orIfNull : mapper.applyAsInt(this.get()), this);
    }

    default public ObservableDoubleValue mapToDouble(ToDoubleFunction<T> mapper) {
        return ObservableDoubleValue.observe(() -> mapper.applyAsDouble(this.get()), this);
    }

    default public ObservableDoubleValue mapToDouble(ToDoubleFunction<T> mapper, double orIfNull) {
        return ObservableDoubleValue.observe(() -> this.get() == null ? orIfNull : mapper.applyAsDouble(this.get()), this);
    }

    default public <X> ObservableObjectValue<X> mapToObservable(Function<T, ObservableValue<X>> mapper, X orIfNull) {
        return this.mapToObservable(mapper, ObservableValue.unmodifiable(orIfNull));
    }

    default public <X> ObservableObjectValue<X> mapToObservable(Function<T, ObservableValue<X>> mapper, ObservableValue<X> orIfNull) {
        return this.mapToObservable(t -> t == null ? orIfNull : (ObservableValue)mapper.apply(t));
    }

    default public <X> ObservableObjectValue<X> mapToObservable(Function<T, ObservableValue<X>> mapper) {
        return DataBindings.getMappingFactory().createPropertyMapping(() -> (ObservableValue)mapper.apply(this.get()), this);
    }

    default public ObservableStringValue mapToObservableString(Function<T, ObservableValue<String>> mapper, String orIfNull) {
        return this.mapToObservableString(mapper, ObservableStringValue.unmodifiable(orIfNull));
    }

    default public ObservableStringValue mapToObservableString(Function<T, ObservableValue<String>> mapper, ObservableValue<String> orIfNull) {
        return this.mapToObservableString(t -> t == null ? orIfNull : (ObservableValue)mapper.apply(t));
    }

    default public ObservableStringValue mapToObservableString(Function<T, ObservableValue<String>> mapper) {
        return DataBindings.getMappingFactory().createStringPropertyMapping(() -> (ObservableValue)mapper.apply(this.get()), this);
    }

    default public ObservableBooleanValue mapToObservableBoolean(Function<T, ObservableValue<Boolean>> mapper, boolean orIfNull) {
        return this.mapToObservableBoolean(mapper, orIfNull ? ObservableBooleanValue.TRUE : ObservableBooleanValue.FALSE);
    }

    default public ObservableBooleanValue mapToObservableBoolean(Function<T, ObservableValue<Boolean>> mapper, ObservableValue<Boolean> orIfNull) {
        return this.mapToObservableBoolean(t -> t == null ? orIfNull : (ObservableValue)mapper.apply(t));
    }

    default public ObservableBooleanValue mapToObservableBoolean(Function<T, ObservableValue<Boolean>> mapper) {
        return DataBindings.getMappingFactory().createBooleanPropertyMapping(() -> (ObservableValue)mapper.apply(this.get()), this);
    }

    default public ObservableIntegerValue mapToObservableInteger(Function<T, ObservableValue<Integer>> mapper, int orIfNull) {
        return this.mapToObservableInteger(mapper, ObservableIntegerValue.unmodifiable(orIfNull));
    }

    default public ObservableIntegerValue mapToObservableInteger(Function<T, ObservableValue<Integer>> mapper, ObservableValue<Integer> orIfNull) {
        return this.mapToObservableInteger(t -> t == null ? orIfNull : (ObservableValue)mapper.apply(t));
    }

    default public ObservableIntegerValue mapToObservableInteger(Function<T, ObservableValue<Integer>> mapper) {
        return DataBindings.getMappingFactory().createIntegerPropertyMapping(() -> (ObservableValue)mapper.apply(this.get()), this);
    }

    default public ObservableDoubleValue mapToObservableDouble(Function<T, ObservableValue<Double>> mapper, double orIfNull) {
        return this.mapToObservableDouble(mapper, ObservableDoubleValue.unmodifiable(orIfNull));
    }

    default public ObservableDoubleValue mapToObservableDouble(Function<T, ObservableValue<Double>> mapper, ObservableValue<Double> orIfNull) {
        return this.mapToObservableDouble(t -> t == null ? orIfNull : (ObservableValue)mapper.apply(t));
    }

    default public ObservableDoubleValue mapToObservableDouble(Function<T, ObservableValue<Double>> mapper) {
        return DataBindings.getMappingFactory().createDoublePropertyMapping(() -> (ObservableValue)mapper.apply(this.get()), this);
    }

    default public ObservableBooleanValue isNull() {
        return this.mapToBoolean(Objects::isNull);
    }

    default public ObservableBooleanValue notNull() {
        return this.mapToBoolean(Objects::nonNull);
    }

    default public ObservableBooleanValue is(T value) {
        return this.mapToBoolean(t -> t == value);
    }

    default public ObservableBooleanValue isEqual(T value) {
        return this.mapToBoolean(t -> Objects.equals(t, value));
    }

    public static abstract class Unmodifiable<T>
    implements ObservableValue<T> {
        @Override
        public void addListener(ObservableValueChangeListener<? super T> listener) {
        }

        @Override
        public void removeListener(ObservableValueChangeListener<? super T> listener) {
        }
    }
}

