/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.databindings.base;

import com.github.franckyi.databindings.api.ObservableBooleanValue;
import com.github.franckyi.databindings.api.ObservableDoubleValue;
import com.github.franckyi.databindings.api.ObservableIntegerValue;
import com.github.franckyi.databindings.api.ObservableObjectValue;
import com.github.franckyi.databindings.api.ObservableStringValue;
import com.github.franckyi.databindings.api.ObservableValue;
import com.github.franckyi.databindings.api.Property;
import com.github.franckyi.databindings.api.event.ObservableValueChangeListener;

public abstract class AbstractReadOnlyProperty<T>
implements ObservableValue<T> {
    protected final Property<T> property;

    protected AbstractReadOnlyProperty(Property<T> property) {
        this.property = property;
    }

    @Override
    public T get() {
        return this.property.get();
    }

    @Override
    public void addListener(ObservableValueChangeListener<? super T> listener) {
        this.property.addListener(listener);
    }

    @Override
    public void removeListener(ObservableValueChangeListener<? super T> listener) {
        this.property.removeListener(listener);
    }

    public String toString() {
        return this.property.toString();
    }

    public static class ReadOnlyStringProperty
    extends AbstractReadOnlyProperty<String>
    implements ObservableStringValue {
        public ReadOnlyStringProperty(Property<String> property) {
            super(property);
        }
    }

    public static class ReadOnlyObjectProperty<T>
    extends AbstractReadOnlyProperty<T>
    implements ObservableObjectValue<T> {
        public ReadOnlyObjectProperty(Property<T> property) {
            super(property);
        }
    }

    public static class ReadOnlyIntegerProperty
    extends AbstractReadOnlyProperty<Integer>
    implements ObservableIntegerValue {
        public ReadOnlyIntegerProperty(Property<Integer> property) {
            super(property);
        }
    }

    public static class ReadOnlyDoubleProperty
    extends AbstractReadOnlyProperty<Double>
    implements ObservableDoubleValue {
        public ReadOnlyDoubleProperty(Property<Double> property) {
            super(property);
        }
    }

    public static class ReadOnlyBooleanProperty
    extends AbstractReadOnlyProperty<Boolean>
    implements ObservableBooleanValue {
        public ReadOnlyBooleanProperty(Property<Boolean> property) {
            super(property);
        }
    }
}

