/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.api.util;

import java.util.Objects;

public final class Insets {
    public static final Insets NONE = new Insets(0);
    private final int top;
    private final int right;
    private final int bottom;
    private final int left;

    public Insets(int value) {
        this(value, value);
    }

    public Insets(int topBottom, int rightLeft) {
        this(topBottom, rightLeft, topBottom);
    }

    public Insets(int top, int rightLeft, int bottom) {
        this(top, rightLeft, bottom, rightLeft);
    }

    public Insets(int top, int right, int bottom, int left) {
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.left = left;
    }

    public int getTop() {
        return this.top;
    }

    public int getRight() {
        return this.right;
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getLeft() {
        return this.left;
    }

    public int getHorizontal() {
        return this.getLeft() + this.getRight();
    }

    public int getVertical() {
        return this.getTop() + this.getBottom();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Insets insets = (Insets)o;
        return this.top == insets.top && this.right == insets.right && this.bottom == insets.bottom && this.left == insets.left;
    }

    public int hashCode() {
        return Objects.hash(this.top, this.right, this.bottom, this.left);
    }

    public String toString() {
        return "Insets{top=" + this.top + ", right=" + this.right + ", bottom=" + this.bottom + ", left=" + this.left + "}";
    }
}

