/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.base.node;

import com.github.franckyi.databindings.api.ObservableList;
import com.github.franckyi.databindings.api.event.ObservableListChangeEvent;
import com.github.franckyi.databindings.base.ObservableArrayList;
import com.github.franckyi.guapi.api.EventTarget;
import com.github.franckyi.guapi.api.Guapi;
import com.github.franckyi.guapi.api.event.MouseEvent;
import com.github.franckyi.guapi.api.node.Group;
import com.github.franckyi.guapi.api.node.Node;
import com.github.franckyi.guapi.api.util.ScreenEventType;
import com.github.franckyi.guapi.base.node.AbstractNode;
import java.util.Collection;

public abstract class AbstractGroup
extends AbstractNode
implements Group {
    protected final ObservableList<Node> children = new ChildrenList();
    protected boolean shouldUpdateChildren = true;

    protected AbstractGroup(Collection<? extends Node> children) {
        this.getChildren().addListener(this::onChildrenChange);
        this.paddingProperty().addListener(this::shouldComputeSizeAndChildrenPos);
        this.xProperty().addListener(this::shouldUpdateChildren);
        this.yProperty().addListener(this::shouldUpdateChildren);
        this.widthProperty().addListener(this::shouldComputeSizeAndChildrenPos);
        this.heightProperty().addListener(this::shouldComputeSizeAndChildrenPos);
        this.getChildren().addAll(children);
    }

    @Override
    public ObservableList<Node> getChildren() {
        return this.children;
    }

    @Override
    public void doTick() {
        super.doTick();
        this.getChildren().forEach(EventTarget::doTick);
    }

    @Override
    public boolean checkRender() {
        boolean res = super.checkRender();
        if (this.shouldUpdateChildren) {
            this.shouldUpdateChildren = false;
            this.updateChildren();
            res = true;
        }
        return res;
    }

    @Override
    public void shouldUpdateChildren() {
        this.shouldUpdateChildren = true;
    }

    protected abstract void updateChildren();

    @Override
    public <E extends MouseEvent> void handleMouseEvent(ScreenEventType<E> target, E event) {
        if (this.inBounds(event.getMouseX(), event.getMouseY())) {
            for (Node node : this.getChildren()) {
                node.handleMouseEvent(target, event);
                if (event.getTarget() == null) continue;
                break;
            }
            if (event.getTarget() == null) {
                event.setTarget(this);
                this.notifyEvent(target, event);
            }
        }
    }

    @Override
    public int getMaxChildrenWidth() {
        if (this.getMaxWidth() != Integer.MAX_VALUE) {
            return this.getMaxWidth() - this.getPadding().getHorizontal();
        }
        if (this.getParentPrefWidth() != -1) {
            return this.getParentPrefWidth() - this.getPadding().getVertical();
        }
        if (this.getPrefWidth() != -1) {
            return this.getPrefWidth() - this.getPadding().getHorizontal();
        }
        if (!this.parentProperty().hasValue()) {
            return this.getWidth() - this.getPadding().getHorizontal();
        }
        return this.getParent().getMaxChildrenWidth() - this.getPadding().getHorizontal();
    }

    @Override
    public int getMaxChildrenHeight() {
        if (this.getMaxHeight() != Integer.MAX_VALUE) {
            return this.getMaxHeight() - this.getPadding().getVertical();
        }
        if (this.getParentPrefHeight() != -1) {
            return this.getParentPrefHeight() - this.getPadding().getVertical();
        }
        if (this.getPrefHeight() != -1) {
            return this.getPrefHeight() - this.getPadding().getVertical();
        }
        if (!this.parentProperty().hasValue()) {
            return this.getHeight() - this.getPadding().getVertical();
        }
        return this.getParent().getMaxChildrenHeight() - this.getPadding().getVertical();
    }

    private void onChildrenChange(ObservableListChangeEvent<? extends Node> event) {
        event.getRemoved(true).forEach(entry -> {
            if (((Node)entry.getValue()).getParent() == this) {
                ((Node)entry.getValue()).setParent(null);
                ((Node)entry.getValue()).setParentPrefWidth(-1);
                ((Node)entry.getValue()).setParentPrefHeight(-1);
            }
        });
        event.getAdded(true).forEach(entry -> ((Node)entry.getValue()).setParent(this));
        this.shouldComputeSizeAndChildrenPos();
    }

    private void shouldComputeSizeAndChildrenPos() {
        this.shouldComputeSize();
        this.shouldUpdateChildren();
    }

    private static class ChildrenList
    extends ObservableArrayList<Node> {
        private ChildrenList() {
        }

        @Override
        protected boolean canAdd(Node element) {
            if (element.getParent() != null) {
                Guapi.getDefaultLogger().error(Guapi.LOG_MARKER, "Can't add Node \"" + String.valueOf(element) + "\" to Group: already present in Parent \"" + String.valueOf(element.getParent()) + "\"");
                return false;
            }
            return true;
        }

        @Override
        protected Collection<? extends Node> canAddAll(Collection<? extends Node> c) {
            return super.canAddAll(c).stream().distinct().filter(this::canAdd).toList();
        }
    }
}

