/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.base.node;

import com.github.franckyi.databindings.api.BooleanProperty;
import com.github.franckyi.databindings.api.IntegerProperty;
import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.franckyi.databindings.api.ObservableBooleanValue;
import com.github.franckyi.databindings.api.ObservableIntegerValue;
import com.github.franckyi.databindings.api.ObservableList;
import com.github.franckyi.databindings.api.ObservableObjectValue;
import com.github.franckyi.guapi.api.Guapi;
import com.github.franckyi.guapi.api.event.ScreenEvent;
import com.github.franckyi.guapi.api.event.ScreenEventListener;
import com.github.franckyi.guapi.api.node.Node;
import com.github.franckyi.guapi.api.node.Parent;
import com.github.franckyi.guapi.api.node.Scene;
import com.github.franckyi.guapi.api.node.ScreenEventHandler;
import com.github.franckyi.guapi.api.theme.Skin;
import com.github.franckyi.guapi.api.util.Insets;
import com.github.franckyi.guapi.api.util.ScreenEventType;
import com.github.franckyi.guapi.base.event.ScreenEventHandlerDelegate;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public abstract class AbstractNode
implements Node {
    protected final IntegerProperty xProperty = IntegerProperty.create();
    protected final IntegerProperty yProperty = IntegerProperty.create();
    protected final IntegerProperty widthProperty = IntegerProperty.create();
    protected final IntegerProperty heightProperty = IntegerProperty.create();
    private final IntegerProperty minWidthProperty = IntegerProperty.create();
    private final IntegerProperty minHeightProperty = IntegerProperty.create();
    private final IntegerProperty prefWidthProperty = IntegerProperty.create(-1);
    private final IntegerProperty prefHeightProperty = IntegerProperty.create(-1);
    private final IntegerProperty maxWidthProperty = IntegerProperty.create(Integer.MAX_VALUE);
    private final IntegerProperty maxHeightProperty = IntegerProperty.create(Integer.MAX_VALUE);
    private final IntegerProperty parentPrefWidthProperty = IntegerProperty.create(-1);
    private final IntegerProperty parentPrefHeightProperty = IntegerProperty.create(-1);
    protected final IntegerProperty computedWidthProperty = IntegerProperty.create();
    private final ObservableIntegerValue computedWidthPropertyReadOnly = ObservableIntegerValue.readOnly(this.computedWidthProperty);
    protected final IntegerProperty computedHeightProperty = IntegerProperty.create();
    private final ObservableIntegerValue computedHeightPropertyReadOnly = ObservableIntegerValue.readOnly(this.computedHeightProperty);
    private final IntegerProperty backgroundColorProperty = IntegerProperty.create(DEFAULT_BACKGROUND_COLOR);
    private final ObjectProperty<Insets> paddingProperty = ObjectProperty.create(Insets.NONE);
    private final ObservableList<class_2561> tooltip = ObservableList.create();
    protected final ObjectProperty<Parent> parentProperty = ObjectProperty.create();
    protected final ObjectProperty<Scene> sceneProperty = ObjectProperty.create();
    private final ObservableObjectValue<Scene> scenePropertyReadOnly = ObservableObjectValue.readOnly(this.sceneProperty);
    private final BooleanProperty visibleProperty = BooleanProperty.create(true);
    private final BooleanProperty disableProperty = BooleanProperty.create();
    private final ObservableBooleanValue disabledProperty = this.disableProperty().or(this.parentProperty().mapToObservableBoolean(Parent::disabledProperty, false));
    private final ObservableBooleanValue rootProperty = this.sceneProperty().mapToObservable(Scene::rootProperty, (Node)null).is(this);
    private final ObservableBooleanValue focusedProperty = this.sceneProperty().mapToObservable(Scene::focusedProperty, (Node)null).is(this);
    private final ObservableBooleanValue hoveredProperty = this.sceneProperty().mapToObservable(Scene::hoveredProperty, (Node)null).is(this);
    protected Skin<? super Node> skin;
    protected final ScreenEventHandler eventHandlerDelegate = new ScreenEventHandlerDelegate();
    protected boolean shouldComputeSize = true;
    protected boolean shouldUpdateSize = true;

    protected AbstractNode() {
        this.minWidthProperty().addListener(this::shouldUpdateSize);
        this.minHeightProperty().addListener(this::shouldUpdateSize);
        this.prefWidthProperty().addListener(this::shouldUpdateSize);
        this.prefHeightProperty().addListener(this::shouldUpdateSize);
        this.maxWidthProperty().addListener(this::shouldUpdateSize);
        this.maxHeightProperty().addListener(this::shouldUpdateSize);
        this.parentPrefWidthProperty().addListener(this::shouldUpdateSize);
        this.parentPrefHeightProperty().addListener(this::shouldUpdateSize);
        this.computedWidthProperty().addListener(this::shouldUpdateSize);
        this.computedHeightProperty().addListener(this::shouldUpdateSize);
        this.widthProperty().addListener(this::updateParentWidth);
        this.heightProperty().addListener(this::updateParentHeight);
        this.paddingProperty().addListener(this::shouldUpdateSize);
        this.parentProperty().addListener(this::updateScene);
    }

    @Override
    public IntegerProperty xProperty() {
        return this.xProperty;
    }

    @Override
    public IntegerProperty yProperty() {
        return this.yProperty;
    }

    @Override
    public IntegerProperty widthProperty() {
        return this.widthProperty;
    }

    @Override
    public IntegerProperty heightProperty() {
        return this.heightProperty;
    }

    @Override
    public IntegerProperty minWidthProperty() {
        return this.minWidthProperty;
    }

    @Override
    public IntegerProperty minHeightProperty() {
        return this.minHeightProperty;
    }

    @Override
    public IntegerProperty prefWidthProperty() {
        return this.prefWidthProperty;
    }

    @Override
    public IntegerProperty prefHeightProperty() {
        return this.prefHeightProperty;
    }

    @Override
    public IntegerProperty maxWidthProperty() {
        return this.maxWidthProperty;
    }

    @Override
    public IntegerProperty maxHeightProperty() {
        return this.maxHeightProperty;
    }

    @Override
    public IntegerProperty parentPrefWidthProperty() {
        return this.parentPrefWidthProperty;
    }

    @Override
    public IntegerProperty parentPrefHeightProperty() {
        return this.parentPrefHeightProperty;
    }

    @Override
    public ObservableIntegerValue computedWidthProperty() {
        return this.computedWidthPropertyReadOnly;
    }

    protected void setComputedWidth(int value) {
        this.computedWidthProperty.setValue(value);
    }

    @Override
    public ObservableIntegerValue computedHeightProperty() {
        return this.computedHeightPropertyReadOnly;
    }

    protected void setComputedHeight(int value) {
        this.computedHeightProperty.setValue(value);
    }

    @Override
    public IntegerProperty backgroundColorProperty() {
        return this.backgroundColorProperty;
    }

    @Override
    public ObjectProperty<Insets> paddingProperty() {
        return this.paddingProperty;
    }

    @Override
    public ObservableList<class_2561> getTooltip() {
        return this.tooltip;
    }

    @Override
    public ObjectProperty<Parent> parentProperty() {
        return this.parentProperty;
    }

    @Override
    public ObservableObjectValue<Scene> sceneProperty() {
        return this.scenePropertyReadOnly;
    }

    @Override
    public BooleanProperty visibleProperty() {
        return this.visibleProperty;
    }

    @Override
    public BooleanProperty disableProperty() {
        return this.disableProperty;
    }

    @Override
    public ObservableBooleanValue disabledProperty() {
        return this.disabledProperty;
    }

    @Override
    public ObservableBooleanValue rootProperty() {
        return this.rootProperty;
    }

    @Override
    public ObservableBooleanValue focusedProperty() {
        return this.focusedProperty;
    }

    @Override
    public ObservableBooleanValue hoveredProperty() {
        return this.hoveredProperty;
    }

    protected <N extends Node> Skin<? super N> getSkin() {
        if (this.skin == null) {
            this.skin = Guapi.getTheme().supplySkin(this, this.getType());
        }
        return this.skin;
    }

    protected abstract <N extends Node> Class<N> getType();

    protected void resetSkin() {
        this.skin = null;
    }

    @Override
    public <E extends ScreenEvent> void handleEvent(ScreenEventType<E> target, E event) {
        target.ifMouseEvent(event, this::handleMouseEvent, () -> this.notifyEvent(target, event));
    }

    protected <E extends ScreenEvent> void notifyEvent(ScreenEventType<E> target, E event) {
        target.onEvent(this, event);
        this.eventHandlerDelegate.handleEvent(target, event);
        this.getSkin().onEvent(target, event);
    }

    @Override
    public <E extends ScreenEvent> void addListener(ScreenEventType<E> target, ScreenEventListener<E> listener) {
        this.eventHandlerDelegate.addListener(target, listener);
    }

    @Override
    public <E extends ScreenEvent> void removeListener(ScreenEventType<E> target, ScreenEventListener<E> listener) {
        this.eventHandlerDelegate.removeListener(target, listener);
    }

    @Override
    public boolean preRender(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        boolean res = this.checkRender();
        if (this.isVisible()) {
            res |= this.getSkin().preRender(this, guiGraphics, mouseX, mouseY, delta);
        }
        return res;
    }

    @Override
    public void render(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        if (this.isVisible()) {
            this.getSkin().render(this, guiGraphics, mouseX, mouseY, delta);
        }
    }

    @Override
    public void postRender(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        if (this.isVisible()) {
            this.getSkin().postRender(this, guiGraphics, mouseX, mouseY, delta);
        }
    }

    @Override
    public void doTick() {
        this.getSkin().doTick();
    }

    @Override
    public boolean checkRender() {
        boolean res = false;
        if (this.shouldComputeSize) {
            this.computeSize();
            res = true;
        }
        if (this.shouldUpdateSize) {
            this.updateSize();
            res = true;
        }
        return res;
    }

    @Override
    public void shouldComputeSize() {
        this.shouldComputeSize = true;
    }

    protected void computeSize() {
        this.shouldComputeSize = false;
        this.computeWidth();
        this.computeHeight();
    }

    private void computeWidth() {
        this.setComputedWidth(this.getSkin().computeWidth(this) + this.getPadding().getHorizontal());
    }

    private void computeHeight() {
        this.setComputedHeight(this.getSkin().computeHeight(this) + this.getPadding().getVertical());
    }

    protected void shouldUpdateSize() {
        this.shouldUpdateSize = true;
    }

    protected void updateSize() {
        this.shouldUpdateSize = false;
        this.updateWidth();
        this.updateHeight();
    }

    private void updateWidth() {
        int width = this.getPrefWidth();
        if (width == -1) {
            width = this.getParentPrefWidth() != -1 ? this.getParentPrefWidth() : this.getComputedWidth();
        }
        width = Math.max(Math.min(width, this.getMaxWidth()), this.getMinWidth());
        if (this.parentProperty().hasValue()) {
            width = Math.min(width, this.getParent().getMaxChildrenWidth());
        }
        this.setWidth(width);
    }

    private void updateHeight() {
        int height = this.getPrefHeight();
        if (height == -1) {
            height = this.getParentPrefHeight() != -1 ? this.getParentPrefHeight() : this.getComputedHeight();
        }
        height = Math.max(Math.min(height, this.getMaxHeight()), this.getMinHeight());
        if (this.parentProperty().hasValue()) {
            height = Math.min(height, this.getParent().getMaxChildrenHeight());
        }
        this.setHeight(height);
    }

    private void updateParentWidth() {
        if (this.getParent() != null) {
            this.getParent().shouldComputeSize();
            this.getParent().shouldUpdateChildren();
        }
    }

    private void updateParentHeight() {
        if (this.getParent() != null) {
            this.getParent().shouldComputeSize();
            this.getParent().shouldUpdateChildren();
        }
    }

    private void updateScene(Parent newVal) {
        if (this.sceneProperty.isBound()) {
            this.sceneProperty.unbind();
        }
        if (newVal != null) {
            this.sceneProperty.bind(newVal.sceneProperty());
        } else {
            this.sceneProperty.setValue(null);
        }
    }
}

