/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client;

import com.github.franckyi.guapi.api.Guapi;
import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.franckyi.guapi.api.node.Node;
import com.github.franckyi.guapi.api.node.Scene;
import com.github.franckyi.guapi.api.node.builder.SceneBuilder;
import com.github.rinorsi.cadeditor.client.ClientConfiguration;
import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.context.BlockEditorContext;
import com.github.rinorsi.cadeditor.client.context.EditorContext;
import com.github.rinorsi.cadeditor.client.context.EntityEditorContext;
import com.github.rinorsi.cadeditor.client.context.ItemEditorContext;
import com.github.rinorsi.cadeditor.client.screen.model.BlockEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.ConfigEditorScreenModel;
import com.github.rinorsi.cadeditor.client.screen.model.EntityEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.NBTEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.SNBTEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.UpdateLogScreenModel;
import com.github.rinorsi.cadeditor.client.screen.model.VaultScreenModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.ColorSelectionScreenModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.ListSelectionScreenModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.ListSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.mvc.ColorSelectionScreenMVC;
import com.github.rinorsi.cadeditor.client.screen.mvc.ConfigEditorMVC;
import com.github.rinorsi.cadeditor.client.screen.mvc.ListSelectionScreenMVC;
import com.github.rinorsi.cadeditor.client.screen.mvc.NBTEditorMVC;
import com.github.rinorsi.cadeditor.client.screen.mvc.SNBTEditorMVC;
import com.github.rinorsi.cadeditor.client.screen.mvc.StandardEditorMVC;
import com.github.rinorsi.cadeditor.client.screen.mvc.UpdateLogScreenMVC;
import com.github.rinorsi.cadeditor.client.screen.mvc.VaultScreenMVC;
import com.github.rinorsi.cadeditor.client.util.ScreenScalingManager;
import com.github.rinorsi.cadeditor.common.EditorType;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ModScreenHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void openSettingsScreen() {
        ModScreenHandler.openScaledScreen(GuapiHelper.mvc(ConfigEditorMVC.INSTANCE, new ConfigEditorScreenModel()));
    }

    public static void openUpdateLogScreen() {
        ModScreenHandler.openScaledScreen(GuapiHelper.mvc(UpdateLogScreenMVC.INSTANCE, new UpdateLogScreenModel()));
    }

    public static void openListSelectionScreen(class_5250 title, String attributeName, List<? extends ListSelectionElementModel> items, Consumer<String> action) {
        ModScreenHandler.openListSelectionScreen(title, attributeName, items, action, false, null, Set.of());
    }

    public static void openListSelectionScreen(class_5250 title, String attributeName, List<? extends ListSelectionElementModel> items, Consumer<String> action, boolean multiSelect, Consumer<List<class_2960>> multiAction, Set<class_2960> initiallySelected) {
        ModScreenHandler.openScaledScreen(GuapiHelper.mvc(ListSelectionScreenMVC.INSTANCE, new ListSelectionScreenModel(title, attributeName, items, action, multiSelect, multiAction, initiallySelected)));
    }

    public static void openColorSelectionScreen(ColorSelectionScreenModel.Target target, int color, Consumer<String> action) {
        ModScreenHandler.openScaledScreen(GuapiHelper.mvc(ColorSelectionScreenMVC.INSTANCE, new ColorSelectionScreenModel(target, action, color)));
    }

    public static void openVault() {
        ModScreenHandler.openScaledScreen(GuapiHelper.mvc(VaultScreenMVC.INSTANCE, new VaultScreenModel()));
    }

    private static void openScaledScreen(Node root) {
        ModScreenHandler.openScaledScreen(root, false);
    }

    private static void openScaledScreen(Node root, boolean replace) {
        Consumer<Scene> action = replace ? Guapi.getScreenHandler()::replaceScene : Guapi.getScreenHandler()::showScene;
        try {
            action.accept((Scene)((SceneBuilder)GuapiHelper.scene(root, true, true).show(scene -> {
                ScreenScalingManager.get().setBaseScale(ClientConfiguration.INSTANCE.getEditorScale());
                scene.widthProperty().addListener(ScreenScalingManager.get()::refresh);
                scene.heightProperty().addListener(ScreenScalingManager.get()::refresh);
            })).hide(scene -> {
                ClientConfiguration.INSTANCE.setEditorScale(ScreenScalingManager.get().getScaleAndReset());
                ClientConfiguration.save();
            }));
        }
        catch (Exception e) {
            LOGGER.error("\u6253\u5f00\u754c\u9762\u65f6\u51fa\u9519", (Throwable)e);
            ClientUtil.showMessage((class_2561)ModTexts.Messages.ERROR_GENERIC);
        }
    }

    public static void openEditor(EditorType editorType, EditorContext<?> context) {
        ModScreenHandler.openEditor(editorType, context, false);
    }

    public static void openEditor(EditorType editorType, EditorContext<?> context, boolean replace) {
        if (editorType != EditorType.STANDARD && context.getTag() == null) {
            ClientUtil.showMessage((class_2561)ModTexts.Messages.NO_BLOCK_DATA);
            return;
        }
        ModScreenHandler.openScaledScreen(switch (editorType) {
            default -> throw new MatchException(null, null);
            case EditorType.STANDARD -> {
                if (context instanceof ItemEditorContext) {
                    ItemEditorContext ctx = (ItemEditorContext)context;
                    yield GuapiHelper.mvc(StandardEditorMVC.INSTANCE, new ItemEditorModel(ctx));
                }
                if (context instanceof BlockEditorContext) {
                    BlockEditorContext ctx = (BlockEditorContext)context;
                    yield GuapiHelper.mvc(StandardEditorMVC.INSTANCE, new BlockEditorModel(ctx));
                }
                if (context instanceof EntityEditorContext) {
                    EntityEditorContext ctx = (EntityEditorContext)context;
                    yield GuapiHelper.mvc(StandardEditorMVC.INSTANCE, new EntityEditorModel(ctx));
                }
                throw new IllegalStateException("context should be an instance of ItemEditorContext, BlockEditorContext or EntityEditorContext");
            }
            case EditorType.NBT -> GuapiHelper.mvc(NBTEditorMVC.INSTANCE, new NBTEditorModel(context));
            case EditorType.SNBT -> GuapiHelper.mvc(SNBTEditorMVC.INSTANCE, new SNBTEditorModel(context));
        }, replace);
    }
}

