/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.controller;

import com.github.franckyi.guapi.api.Guapi;
import com.github.franckyi.guapi.api.mvc.AbstractController;
import com.github.rinorsi.cadeditor.client.screen.controller.EditorController;
import com.github.rinorsi.cadeditor.client.screen.model.NBTEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.NBTTagModel;
import com.github.rinorsi.cadeditor.client.screen.view.NBTEditorView;
import com.github.rinorsi.cadeditor.common.EditorType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class NBTEditorController
extends AbstractController<NBTEditorModel, NBTEditorView>
implements EditorController<NBTEditorModel, NBTEditorView> {
    public NBTEditorController(NBTEditorModel model, NBTEditorView view) {
        super(model, view);
    }

    @Override
    public void bind() {
        EditorController.super.bind();
        ((NBTEditorView)this.view).addOpenEditorButton(() -> ((NBTEditorModel)this.model).changeEditor(EditorType.STANDARD));
        ((NBTEditorView)this.view).addOpenSNBTEditorButton(() -> ((NBTEditorModel)this.model).changeEditor(EditorType.SNBT));
        ((NBTEditorView)this.view).getTagTree().rootItemProperty().bind(((NBTEditorModel)this.model).rootTagProperty());
        ((NBTEditorView)this.view).getTagTree().focusedElementProperty().addListener(this::updateEnabledButtons);
        ((NBTEditorView)this.view).setOnButtonClick(this::onButtonClick);
        ((NBTEditorView)this.view).getDoneButton().onAction(((NBTEditorModel)this.model)::update);
        ((NBTEditorView)this.view).getCancelButton().onAction(Guapi.getScreenHandler()::hideScene);
    }

    private void onButtonClick(NBTEditorView.ButtonType target) {
        NBTTagModel tag = (NBTTagModel)((NBTEditorView)this.view).getTagTree().getFocusedElement();
        NBTTagModel parent = (NBTTagModel)tag.getParent();
        switch (target) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BYTE_ARRAY: 
            case STRING: 
            case LIST: 
            case COMPOUND: 
            case INT_ARRAY: 
            case LONG_ARRAY: {
                this.addChildTag(tag, this.createEmptyTag(target.getType()));
                break;
            }
            case MOVE_UP: {
                int index0 = parent.getChildren().indexOf(tag);
                Collections.swap(parent.getChildren(), index0, index0 - 1);
                this.updateEnabledButtons(tag);
                break;
            }
            case MOVE_DOWN: {
                int index1 = parent.getChildren().indexOf(tag);
                Collections.swap(parent.getChildren(), index1, index1 + 1);
                this.updateEnabledButtons(tag);
                break;
            }
            case ADD: {
                switch (tag.getTagType()) {
                    case 7: {
                        this.addChildTag(tag, (byte)1, "0");
                        break;
                    }
                    case 11: {
                        this.addChildTag(tag, (byte)3, "0");
                        break;
                    }
                    case 12: {
                        this.addChildTag(tag, (byte)4, "0");
                        break;
                    }
                    case 9: {
                        if (tag.getChildren().isEmpty()) break;
                        this.addChildTag(tag, this.createEmptyTag(((NBTTagModel)tag.getChildren().get(0)).getTagType()));
                    }
                }
                break;
            }
            case CUT: {
                ((NBTEditorModel)this.model).setClipboardTag(tag);
            }
            case DELETE: {
                parent.getChildren().remove(tag);
                ((NBTEditorView)this.view).getTagTree().setFocusedElement(null);
                break;
            }
            case COPY: {
                ((NBTEditorModel)this.model).setClipboardTag(tag.createClipboardTag());
                this.updateEnabledButtons(tag);
                break;
            }
            case PASTE: {
                NBTTagModel clipboardTag = ((NBTEditorModel)this.model).getClipboardTag();
                if (clipboardTag.canBuild()) {
                    this.addChildTag(tag, clipboardTag.build(), clipboardTag.getName());
                    break;
                }
                this.addChildTag(tag, clipboardTag.getTagType(), clipboardTag.getValue());
            }
        }
    }

    private void updateEnabledButtons(NBTTagModel newVal) {
        ((NBTEditorView)this.view).getAddTagButton().setActive(false);
        ArrayList<NBTEditorView.ButtonType> buttons = new ArrayList<NBTEditorView.ButtonType>();
        NBTTagModel clipboardTag = ((NBTEditorModel)this.model).getClipboardTag();
        if (newVal != null) {
            switch (newVal.getTagType()) {
                case 10: {
                    buttons.add(NBTEditorView.ButtonType.ADD);
                    if (clipboardTag == null || !clipboardTag.canBuild()) break;
                    buttons.add(NBTEditorView.ButtonType.PASTE);
                    break;
                }
                case 7: {
                    if (clipboardTag != null && !clipboardTag.canBuild() && clipboardTag.getTagType() == 1) {
                        buttons.add(NBTEditorView.ButtonType.PASTE);
                    }
                    buttons.add(NBTEditorView.ButtonType.ADD);
                    break;
                }
                case 11: {
                    if (clipboardTag != null && !clipboardTag.canBuild() && clipboardTag.getTagType() == 3) {
                        buttons.add(NBTEditorView.ButtonType.PASTE);
                    }
                    buttons.add(NBTEditorView.ButtonType.ADD);
                    break;
                }
                case 12: {
                    if (clipboardTag != null && !clipboardTag.canBuild() && clipboardTag.getTagType() == 4) {
                        buttons.add(NBTEditorView.ButtonType.PASTE);
                    }
                    buttons.add(NBTEditorView.ButtonType.ADD);
                    break;
                }
                case 9: {
                    if (newVal.getChildren().isEmpty()) {
                        buttons.add(NBTEditorView.ButtonType.ADD);
                        if (clipboardTag == null || !clipboardTag.canBuild()) break;
                        buttons.add(NBTEditorView.ButtonType.PASTE);
                        break;
                    }
                    buttons.add(NBTEditorView.ButtonType.ADD);
                    if (clipboardTag == null || !clipboardTag.canBuild() || clipboardTag.getTagType() != ((NBTTagModel)newVal.getChildren().get(0)).getTagType()) break;
                    buttons.add(NBTEditorView.ButtonType.PASTE);
                }
            }
            if (newVal.getParent() != null) {
                NBTTagModel parent = (NBTTagModel)newVal.getParent();
                if (parent.getChildren().indexOf(newVal) != 0) {
                    buttons.add(NBTEditorView.ButtonType.MOVE_UP);
                }
                if (parent.getChildren().indexOf(newVal) != parent.getChildren().size() - 1) {
                    buttons.add(NBTEditorView.ButtonType.MOVE_DOWN);
                }
                buttons.add(NBTEditorView.ButtonType.DELETE);
                buttons.add(NBTEditorView.ButtonType.CUT);
            }
            buttons.add(NBTEditorView.ButtonType.COPY);
        }
        ((NBTEditorView)this.view).getEnabledButtons().setAll((Collection<NBTEditorView.ButtonType>)buttons);
    }

    private void addChildTag(NBTTagModel parent, class_2520 newTag) {
        this.addChildTag(parent, newTag, "");
    }

    private void addChildTag(NBTTagModel parent, class_2520 newTag, String name) {
        this.addChildTag(parent, new NBTTagModel(newTag, parent, parent.getTagType() != 9 ? name : null, null));
    }

    private void addChildTag(NBTTagModel parent, byte target, String value) {
        this.addChildTag(parent, new NBTTagModel(target, parent, value));
    }

    private void addChildTag(NBTTagModel parent, NBTTagModel tag) {
        parent.getChildren().add(tag);
        parent.setExpanded(true);
        ((NBTEditorView)this.view).getTagTree().setScrollTo(tag);
        ((NBTEditorView)this.view).getTagTree().setFocusedElement(tag);
    }

    private class_2520 createEmptyTag(byte type) {
        return switch (type) {
            case 1 -> class_2481.field_21026;
            case 2 -> class_2516.method_23254((short)0);
            case 3 -> class_2497.method_23247((int)0);
            case 4 -> class_2503.method_23251((long)0L);
            case 5 -> class_2494.field_21034;
            case 6 -> class_2489.field_21030;
            case 7 -> new class_2479(new byte[0]);
            case 8 -> class_2519.method_23256((String)"");
            case 9 -> new class_2499();
            case 10 -> new class_2487();
            case 11 -> new class_2495(new int[0]);
            case 12 -> new class_2501(new long[0]);
            default -> null;
        };
    }
}

