/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.controller.entry.item;

import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.franckyi.guapi.api.util.Predicates;
import com.github.rinorsi.cadeditor.client.ClientCache;
import com.github.rinorsi.cadeditor.client.ModScreenHandler;
import com.github.rinorsi.cadeditor.client.screen.controller.entry.SelectionEntryController;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEnchantmentsCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.EnchantmentEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.ListSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.view.entry.item.EnchantmentEntryView;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class EnchantmentEntryController
extends SelectionEntryController<EnchantmentEntryModel, EnchantmentEntryView> {
    public EnchantmentEntryController(EnchantmentEntryModel model, EnchantmentEntryView view) {
        super(model, view);
    }

    @Override
    public void bind() {
        super.bind();
        ((EnchantmentEntryView)this.view).getPlusButton().onAction(() -> ((EnchantmentEntryModel)this.model).levelProperty().incr());
        ((EnchantmentEntryView)this.view).getMinusButton().onAction(() -> ((EnchantmentEntryModel)this.model).levelProperty().decr());
        ((EnchantmentEntryView)this.view).getLevelField().setValidator(Predicates.range(0, 256));
        ((EnchantmentEntryView)this.view).getLevelField().textProperty().addListener(value -> {
            if (((EnchantmentEntryView)this.view).getLevelField().isValid()) {
                int level = Integer.parseInt(value);
                ((EnchantmentEntryModel)this.model).setLevel(level);
                ((EnchantmentEntryView)this.view).getPlusButton().setDisable(level == 255);
                ((EnchantmentEntryView)this.view).getMinusButton().setDisable(level == 0);
            } else {
                ((EnchantmentEntryView)this.view).getPlusButton().setDisable(true);
                ((EnchantmentEntryView)this.view).getMinusButton().setDisable(true);
            }
        });
        ((EnchantmentEntryView)this.view).getLevelField().setText(Integer.toString(((EnchantmentEntryModel)this.model).getLevel()));
        ((EnchantmentEntryModel)this.model).levelProperty().addListener(value -> ((EnchantmentEntryView)this.view).getLevelField().setText(Integer.toString(value)));
        ((EnchantmentEntryModel)this.model).validProperty().bind(((EnchantmentEntryView)this.view).getLevelField().validProperty());
        ((EnchantmentEntryModel)this.model).valueProperty().addListener(this::updatePreview);
        this.updatePreview((String)((EnchantmentEntryModel)this.model).getValue());
    }

    @Override
    protected void openSelectionScreen() {
        ItemEnchantmentsCategoryModel category = (ItemEnchantmentsCategoryModel)((EnchantmentEntryModel)this.model).getCategory();
        HashSet<class_2960> selected = new HashSet<class_2960>(category.getExistingEnchantmentIds());
        class_2960 currentId = this.parseResourceLocation((String)((EnchantmentEntryModel)this.model).getValue());
        if (currentId != null) {
            selected.add(currentId);
        }
        List<? extends ListSelectionElementModel> items = ((EnchantmentEntryModel)this.model).getSelectionItems();
        ModScreenHandler.openListSelectionScreen(((EnchantmentEntryModel)this.model).getSelectionScreenTitle(), (String)(((String)((EnchantmentEntryModel)this.model).getValue()).contains(":") ? (String)((EnchantmentEntryModel)this.model).getValue() : "minecraft:" + (String)((EnchantmentEntryModel)this.model).getValue()), items, ((EnchantmentEntryModel)this.model)::setValue, true, ids -> {
            if (ids.isEmpty()) {
                return;
            }
            ((EnchantmentEntryModel)this.model).setValue(((class_2960)ids.get(0)).toString());
            for (int i = 1; i < ids.size(); ++i) {
                category.addEnchantmentEntryIfAbsent(((class_2960)ids.get(i)).toString(), ((EnchantmentEntryModel)this.model).getLevel());
            }
        }, selected);
    }

    private void updatePreview(String value) {
        class_2960 id = this.parseResourceLocation(value);
        if (id == null) {
            ((EnchantmentEntryView)this.view).setPreviewVisible(false);
            return;
        }
        ClientCache.findEnchantmentSelectionItem(id).ifPresentOrElse(item -> {
            ((EnchantmentEntryView)this.view).getPreviewItemView().setItem(item.getItem());
            ((EnchantmentEntryView)this.view).getPreviewLabel().setLabel((class_2561)GuapiHelper.translated(item.getName()).method_27692(class_124.field_1080));
            ((EnchantmentEntryView)this.view).setPreviewVisible(true);
        }, () -> ((EnchantmentEntryView)this.view).setPreviewVisible(false));
    }
}

