/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4174;
import net.minecraft.class_7923;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9336;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FoodComponentState {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean enabled;
    private boolean hasEverBeenEnabled;
    private int nutrition = 4;
    private float saturation = 0.3f;
    private boolean alwaysEat;
    private float eatSeconds = 1.6f;
    private String usingConvertsToId = "";
    private Optional<class_1799> originalUsingConvertsTo = Optional.empty();
    private List<class_4174.class_9423> effects = new ArrayList<class_4174.class_9423>();

    public void loadFrom(class_1799 stack) {
        class_4174 properties = (class_4174)stack.method_57824(class_9334.field_50075);
        if (properties != null) {
            this.hasEverBeenEnabled = true;
            this.setEnabled(true);
            this.nutrition = properties.comp_2491();
            this.saturation = properties.comp_2492();
            this.alwaysEat = properties.comp_2493();
            this.eatSeconds = properties.comp_2494();
            this.originalUsingConvertsTo = properties.comp_2794().map(class_1799::method_7972);
            this.usingConvertsToId = this.originalUsingConvertsTo.map(class_1799::method_7909).map(item -> class_7923.field_41178.method_10221(item).toString()).orElse("");
            this.effects = new ArrayList<class_4174.class_9423>(properties.comp_2495());
            LOGGER.info("Loaded food component for {} -> converts_to='{}' preservedStack={}", (Object)this.describeStack(stack), (Object)this.usingConvertsToId, (Object)this.originalUsingConvertsTo.map(this::describeStack).orElse("<empty>"));
        } else {
            this.hasEverBeenEnabled = false;
            this.setEnabled(false);
            this.nutrition = 4;
            this.saturation = 0.3f;
            this.alwaysEat = false;
            this.eatSeconds = 1.6f;
            this.originalUsingConvertsTo = Optional.empty();
            this.usingConvertsToId = "";
            this.effects = new ArrayList<class_4174.class_9423>();
            LOGGER.info("Food component not present on {}. State reset.", (Object)this.describeStack(stack));
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            this.hasEverBeenEnabled = true;
        }
    }

    public int getNutrition() {
        return this.nutrition;
    }

    public void setNutrition(int nutrition) {
        this.nutrition = Math.max(0, nutrition);
    }

    public float getSaturation() {
        return this.saturation;
    }

    public void setSaturation(float saturation) {
        this.saturation = Math.max(0.0f, saturation);
    }

    public boolean isAlwaysEat() {
        return this.alwaysEat;
    }

    public void setAlwaysEat(boolean alwaysEat) {
        this.alwaysEat = alwaysEat;
    }

    public float getEatSeconds() {
        return this.eatSeconds;
    }

    public void setEatSeconds(float eatSeconds) {
        this.eatSeconds = Math.max(0.1f, eatSeconds);
    }

    public String getUsingConvertsToId() {
        return this.usingConvertsToId;
    }

    public void setUsingConvertsToId(String usingConvertsToId) {
        this.usingConvertsToId = usingConvertsToId == null ? "" : usingConvertsToId.trim();
    }

    public void prepareForInitialEnable(class_1799 stack) {
        if (this.hasEverBeenEnabled) {
            return;
        }
        this.setNutrition(0);
        this.setSaturation(0.0f);
        this.setAlwaysEat(true);
        this.setEatSeconds(1.6f);
        this.usingConvertsToId = "";
        this.originalUsingConvertsTo = Optional.empty();
        LOGGER.info("Prepared initial food state for {} -> converts_to cleared", (Object)this.describeStack(stack));
    }

    public List<class_4174.class_9423> getEffects() {
        return List.copyOf(this.effects);
    }

    public void setEffects(List<class_4174.class_9423> newEffects) {
        this.effects = new ArrayList<class_4174.class_9423>(newEffects);
    }

    public Optional<class_1799> resolveUsingConvertsTo() {
        if (this.usingConvertsToId.isBlank()) {
            LOGGER.info("resolveUsingConvertsTo skipped because id blank (state currently disabled?).");
            return Optional.empty();
        }
        class_2960 rl = class_2960.method_12829((String)this.usingConvertsToId);
        if (rl == null) {
            LOGGER.warn("Failed to parse using_converts_to id '{}'", (Object)this.usingConvertsToId);
            return Optional.empty();
        }
        class_1792 item = class_7923.field_41178.method_17966(rl).orElse(null);
        if (item == null) {
            LOGGER.warn("Unknown using_converts_to item id '{}'", (Object)this.usingConvertsToId);
            return Optional.empty();
        }
        Optional<class_1799> preserved = this.originalUsingConvertsTo.filter(stack -> class_7923.field_41178.method_10221((Object)stack.method_7909()).equals((Object)rl)).map(class_1799::method_7972);
        if (preserved.isPresent()) {
            LOGGER.info("Reusing preserved using_converts_to stack: {}", (Object)this.describeStack(preserved.get()));
            return preserved;
        }
        class_1799 result = item.method_7854();
        if (result.method_7960()) {
            result = new class_1799((class_1935)item);
        }
        class_1799 prepared = this.prepareConvertStack(result);
        LOGGER.info("Built new using_converts_to stack for '{}' -> {}", (Object)this.usingConvertsToId, (Object)this.describeStack(prepared));
        return Optional.of(prepared);
    }

    public List<class_4174.class_9423> copyEffectsForComponent() {
        if (this.effects.isEmpty()) {
            return List.of();
        }
        return List.copyOf(this.effects);
    }

    public void updateOriginalUsingConvertsTo(Optional<class_1799> stack) {
        this.originalUsingConvertsTo = stack.filter(s -> !s.method_7960()).map(this::prepareConvertStack);
        LOGGER.info("Updated preserved using_converts_to stack to {}", (Object)this.originalUsingConvertsTo.map(this::describeStack).orElse("<empty>"));
    }

    private class_1799 prepareConvertStack(class_1799 source) {
        if (source.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 sanitized = new class_1799((class_1935)source.method_7909());
        sanitized.method_7939(1);
        class_9323 components = source.method_57353();
        if (!components.method_57837()) {
            class_9326.class_9327 builder = class_9326.method_57841();
            for (class_9336 component : components) {
                class_9331 type = component.comp_2443();
                if (type == class_9334.field_50075) continue;
                builder.method_57855(component);
            }
            class_9326 filtered = builder.method_57852();
            if (!filtered.method_57848()) {
                sanitized.method_57366(filtered);
            }
        }
        sanitized.method_57381(class_9334.field_50075);
        LOGGER.info("Sanitized convert stack -> {}", (Object)this.describeStack(sanitized));
        return sanitized;
    }

    private String describeStack(class_1799 stack) {
        if (stack.method_7960()) {
            return "<empty>";
        }
        class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
        StringBuilder builder = new StringBuilder(id.toString());
        builder.append(" x").append(stack.method_7947());
        class_2561 name = (class_2561)stack.method_57824(class_9334.field_49631);
        if (name != null) {
            builder.append(" name=\"").append(name.getString()).append("\"");
        }
        if (stack.method_57824(class_9334.field_50075) != null) {
            builder.append(" [has food]");
        }
        return builder.toString();
    }
}

