/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.FoodComponentState;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.FoodEffectEntryModel;
import com.github.rinorsi.cadeditor.client.util.CompatFood;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4174;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public class ItemFoodEffectsCategoryModel
extends ItemEditorCategoryModel {
    private static final int MAX_DURATION_TICKS = 72000;
    private static final int MAX_AMPLIFIER = 255;
    private final FoodComponentState state;
    private List<class_4174.class_9423> stagedEffects = List.of();

    public ItemFoodEffectsCategoryModel(ItemEditorModel editor) {
        super((class_2561)ModTexts.gui("food_effects"), editor);
        this.state = editor.getFoodState();
    }

    @Override
    protected void setupEntries() {
        this.state.getEffects().forEach(effect -> this.getEntries().add(this.createFoodEffectEntry((class_4174.class_9423)effect)));
    }

    @Override
    public int getEntryListStart() {
        return 0;
    }

    @Override
    public EntryModel createNewListEntry() {
        return this.createFoodEffectEntry(null);
    }

    @Override
    public int getEntryHeight() {
        return 50;
    }

    @Override
    protected class_5250 getAddListEntryButtonTooltip() {
        return ModTexts.EFFECT;
    }

    @Override
    public void apply() {
        if (!this.state.isEnabled()) {
            this.stagedEffects = List.of();
            return;
        }
        this.stagedEffects = new ArrayList<class_4174.class_9423>();
        super.apply();
        this.state.setEffects(this.stagedEffects);
        this.getParent().applyFoodComponent();
    }

    private EntryModel createFoodEffectEntry(class_4174.class_9423 effect) {
        if (effect != null) {
            class_1293 instance = effect.comp_2496();
            String id = instance.method_5579().method_40230().map(key -> key.method_29177().toString()).orElse("minecraft:empty");
            return new FoodEffectEntryModel(this, id, instance.method_5578(), instance.method_5584(), instance.method_5591(), instance.method_5581(), instance.method_5592(), effect.comp_2497(), this::addFoodEffect);
        }
        String defaultId = class_1294.field_5904.method_40230().map(key -> key.method_29177().toString()).orElse("minecraft:movement_speed");
        return new FoodEffectEntryModel(this, defaultId, 0, 1, false, true, true, 1.0, this::addFoodEffect);
    }

    private void addFoodEffect(String id, int amplifier, int duration, boolean ambient, boolean showParticles, boolean showIcon, float probability) {
        ArrayList list;
        Optional registryOpt = ClientUtil.registryAccess().method_46759(class_7924.field_41208);
        if (registryOpt.isEmpty()) {
            return;
        }
        class_2960 rl = class_2960.method_12829((String)id);
        if (rl == null) {
            return;
        }
        class_6880 holder = ((class_7225.class_7226)registryOpt.get()).method_46746(class_5321.method_29179((class_5321)class_7924.field_41208, (class_2960)rl)).orElse(null);
        if (holder == null) {
            return;
        }
        int clampedDuration = Math.max(1, Math.min(duration, 72000));
        int clampedAmplifier = Math.max(0, Math.min(amplifier, 255));
        class_1293 instance = new class_1293(holder, clampedDuration, clampedAmplifier, ambient, showParticles, showIcon);
        List<class_4174.class_9423> list2 = this.stagedEffects;
        if (list2 instanceof ArrayList) {
            ArrayList existing;
            list = existing = (ArrayList)list2;
        } else {
            this.stagedEffects = list = new ArrayList();
        }
        CompatFood.makePossibleEffect(instance, probability).ifPresent(list::add);
    }
}

