/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.BooleanEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.IntegerEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.ItemSelectionEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.RaritySelectionEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3902;
import net.minecraft.class_7923;
import net.minecraft.class_9280;
import net.minecraft.class_9300;
import net.minecraft.class_9334;

public class ItemGeneralCategoryModel
extends ItemEditorCategoryModel {
    private BooleanEntryModel foodToggleEntry;

    public ItemGeneralCategoryModel(ItemEditorModel editor) {
        super((class_2561)ModTexts.GENERAL, editor);
    }

    @Override
    protected void setupEntries() {
        class_1799 stack = this.getParent().getContext().getItemStack();
        String currentId = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
        int currentCount = stack.method_7947();
        int currentDamage = stack.method_7963() ? stack.method_7919() : 0;
        boolean isUnbreakable = stack.method_57826(class_9334.field_49630);
        this.getEntries().add(new ItemSelectionEntryModel((CategoryModel)this, ModTexts.ITEM_ID, currentId, this::setItemId));
        this.getEntries().add(new IntegerEntryModel((CategoryModel)this, ModTexts.COUNT, currentCount, this::setCount));
        this.getEntries().add(new IntegerEntryModel((CategoryModel)this, ModTexts.DAMAGE, currentDamage, this::setDamage));
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.UNBREAKABLE, isUnbreakable, this::setUnbreakable));
        this.getEntries().add(new RaritySelectionEntryModel((CategoryModel)this, ModTexts.gui("rarity"), this.getRarityString(stack), this::setRarity));
        this.getEntries().add(new IntegerEntryModel((CategoryModel)this, ModTexts.gui("custom_model_data"), this.getCustomModelData(stack), this::setCustomModelData));
        this.getEntries().add(new IntegerEntryModel((CategoryModel)this, ModTexts.gui("repair_cost"), this.getRepairCost(stack), this::setRepairCost));
        this.getEntries().add(new BooleanEntryModel((CategoryModel)this, ModTexts.gui("glint_override"), this.getGlintOverride(stack), this::setGlintOverride));
        this.foodToggleEntry = new BooleanEntryModel((CategoryModel)this, ModTexts.gui("food_enabled"), this.getParent().getFoodState().isEnabled(), this::setFoodEnabled);
        this.getEntries().add(this.foodToggleEntry);
    }

    private void setDamage(int value) {
        class_1799 stack = this.getParent().getContext().getItemStack();
        if (!stack.method_7963()) {
            return;
        }
        int max = stack.method_7936();
        int clamped = Math.max(0, Math.min(value, Math.max(0, max - 1)));
        stack.method_7974(clamped);
    }

    private void setUnbreakable(boolean value) {
        class_1799 stack = this.getParent().getContext().getItemStack();
        if (value) {
            stack.method_57379(class_9334.field_49630, (Object)new class_9300(true));
        } else {
            stack.method_57381(class_9334.field_49630);
        }
    }

    private void setCount(int value) {
        class_1799 stack = this.getParent().getContext().getItemStack();
        int clamped = Math.max(1, Math.min(999, value));
        stack.method_7939(clamped);
    }

    private void setItemId(String id) {
        try {
            class_2960 rl = class_2960.method_60654((String)id);
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(rl);
            if (item != null) {
                class_1799 old = this.getParent().getContext().getItemStack();
                int count = old.method_7947();
                class_1799 repl = new class_1799((class_1935)item, count);
                this.getParent().handleStackReplaced(repl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getRarityString(class_1799 stack) {
        class_1814 r = (class_1814)stack.method_57824(class_9334.field_50073);
        return r != null ? r.method_15434() : "common";
    }

    private void setRarity(String name) {
        class_1799 stack = this.getParent().getContext().getItemStack();
        try {
            class_1814 r;
            String n = name == null ? "" : name.toLowerCase();
            int i = n.indexOf(58);
            if (i >= 0) {
                n = n.substring(i + 1);
            }
            switch (n) {
                case "uncommon": {
                    class_1814 class_18142 = class_1814.field_8907;
                    break;
                }
                case "rare": {
                    class_1814 class_18142 = class_1814.field_8903;
                    break;
                }
                case "epic": {
                    class_1814 class_18142 = class_1814.field_8904;
                    break;
                }
                default: {
                    class_1814 class_18142 = r = class_1814.field_8906;
                }
            }
            if (r == class_1814.field_8906) {
                stack.method_57381(class_9334.field_50073);
            } else {
                stack.method_57379(class_9334.field_50073, (Object)r);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getCustomModelData(class_1799 stack) {
        class_9280 cmd = (class_9280)stack.method_57824(class_9334.field_49637);
        return cmd != null ? cmd.comp_2382() : 0;
    }

    private void setCustomModelData(int value) {
        class_1799 stack = this.getParent().getContext().getItemStack();
        if (value > 0) {
            stack.method_57379(class_9334.field_49637, (Object)new class_9280(value));
        } else {
            stack.method_57381(class_9334.field_49637);
        }
    }

    private int getRepairCost(class_1799 stack) {
        Integer v = (Integer)stack.method_57824(class_9334.field_49639);
        return v != null ? v : 0;
    }

    private void setRepairCost(int value) {
        class_1799 stack = this.getParent().getContext().getItemStack();
        if (value > 0) {
            stack.method_57379(class_9334.field_49639, (Object)value);
        } else {
            stack.method_57381(class_9334.field_49639);
        }
    }

    private boolean getGlintOverride(class_1799 stack) {
        Boolean b = (Boolean)stack.method_57824(class_9334.field_49641);
        return b != null && b != false;
    }

    private void setGlintOverride(boolean value) {
        class_1799 stack = this.getParent().getContext().getItemStack();
        if (value) {
            stack.method_57379(class_9334.field_49641, (Object)true);
        } else {
            stack.method_57381(class_9334.field_49641);
        }
    }

    private void setCreativeSlotLock(boolean value) {
        class_1799 stack = this.getParent().getContext().getItemStack();
        if (value) {
            stack.method_57379(class_9334.field_49640, (Object)class_3902.field_17274);
        } else {
            stack.method_57381(class_9334.field_49640);
        }
    }

    private void setFoodEnabled(boolean value) {
        if (value) {
            this.getParent().enableFoodComponent();
        } else {
            this.getParent().disableFoodComponent();
        }
    }

    public void syncFoodToggle() {
        if (this.foodToggleEntry == null) {
            return;
        }
        boolean enabled = this.getParent().getFoodState().isEnabled();
        this.foodToggleEntry.setValue(enabled);
        if (this.foodToggleEntry.valueChangedProperty().getValue()) {
            this.foodToggleEntry.apply();
        }
    }
}

