/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.category.item;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.ItemEditorModel;
import com.github.rinorsi.cadeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.PotionEffectEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.PotionSelectionEntryModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9334;

public class ItemPotionEffectsCategoryModel
extends ItemEditorCategoryModel {
    private class_2499 potionEffectList;

    public ItemPotionEffectsCategoryModel(ItemEditorModel editor) {
        super((class_2561)ModTexts.POTION_EFFECTS, editor);
    }

    @Override
    protected void setupEntries() {
        class_1799 stack = this.getParent().getContext().getItemStack();
        class_1844 contents = (class_1844)stack.method_57824(class_9334.field_49651);
        String potionId = "";
        int customColor = Integer.MIN_VALUE;
        if (contents != null) {
            potionId = contents.comp_2378().flatMap(h -> h.method_40230().map(k -> Optional.of(k.method_29177().toString())).orElse(Optional.empty())).orElse("");
            customColor = contents.comp_2379().orElse(Integer.MIN_VALUE);
            contents.comp_2380().forEach(e -> this.getEntries().add(this.createPotionEffectEntry(ItemPotionEffectsCategoryModel.toTag(e))));
        } else {
            potionId = this.getTag().method_10558("Potion");
            customColor = this.getCustomPotionColor();
            this.getTag().method_10554("custom_potion_effects", 10).stream().map(class_2487.class::cast).map(this::createPotionEffectEntry).forEach(this.getEntries()::add);
        }
        this.getEntries().add(0, new PotionSelectionEntryModel(this, ModTexts.DEFAULT_POTION, potionId, customColor, p -> this.getOrCreateTag().method_10582("Potion", p), this::setCustomPotionColor));
    }

    @Override
    public int getEntryListStart() {
        return 1;
    }

    @Override
    public EntryModel createNewListEntry() {
        return this.createPotionEffectEntry(null);
    }

    @Override
    public int getEntryHeight() {
        return 50;
    }

    @Override
    protected class_5250 getAddListEntryButtonTooltip() {
        return ModTexts.EFFECT;
    }

    private int getCustomPotionColor() {
        return this.getTag().method_10573("CustomPotionColor", 3) ? this.getTag().method_10550("CustomPotionColor") : Integer.MIN_VALUE;
    }

    private void setCustomPotionColor(int color) {
        if (color != Integer.MIN_VALUE) {
            this.getOrCreateTag().method_10569("CustomPotionColor", color);
        } else {
            this.getOrCreateTag().method_10551("CustomPotionColor");
        }
    }

    private EntryModel createPotionEffectEntry(class_2487 tag) {
        if (tag != null) {
            String id = tag.method_10558("id");
            int amplifier = tag.method_10550("amplifier");
            int duration = tag.method_10573("duration", 3) ? tag.method_10550("duration") : 1;
            boolean ambient = tag.method_10577("ambient");
            boolean showParticles = !tag.method_10573("show_particles", 1) || tag.method_10577("show_particles");
            boolean showIcon = tag.method_10577("show_icon");
            return new PotionEffectEntryModel(this, id, amplifier, duration, ambient, showParticles, showIcon, this::addPotionEffect);
        }
        String defaultId = class_1294.field_5904.method_40230().map(key -> key.method_29177().toString()).orElse("minecraft:movement_speed");
        return new PotionEffectEntryModel(this, defaultId, 0, 1, false, true, true, this::addPotionEffect);
    }

    @Override
    public void apply() {
        this.potionEffectList = new class_2499();
        super.apply();
        class_1799 stack = this.getParent().getContext().getItemStack();
        class_7225.class_7874 registry = ClientUtil.registryAccess();
        Optional potionLookupOpt = registry.method_46759(class_7924.field_41215);
        Optional effectLookupOpt = registry.method_46759(class_7924.field_41208);
        ArrayList<class_1293> effects = new ArrayList<class_1293>();
        for (class_2520 t : this.potionEffectList) {
            class_5321 key;
            Optional holderOpt;
            if (!(t instanceof class_2487)) continue;
            class_2487 c = (class_2487)t;
            String id = c.method_10558("id");
            int amplifier = c.method_10550("amplifier");
            int duration = c.method_10573("duration", 3) ? c.method_10550("duration") : 1;
            boolean ambient = c.method_10577("ambient");
            boolean showParticles = !c.method_10573("show_particles", 1) || c.method_10577("show_particles");
            boolean showIcon = c.method_10577("show_icon");
            if (!effectLookupOpt.isPresent()) continue;
            class_7225.class_7226 effectLookup = (class_7225.class_7226)effectLookupOpt.get();
            class_2960 rl = class_2960.method_12829((String)id);
            if (rl == null || !(holderOpt = effectLookup.method_46746(key = class_5321.method_29179((class_5321)class_7924.field_41208, (class_2960)rl))).isPresent()) continue;
            class_6880 holder = (class_6880)holderOpt.get();
            effects.add(new class_1293(holder, duration, amplifier, ambient, showParticles, showIcon));
        }
        String potionStr = this.getOrCreateTag().method_10558("Potion");
        int customColor = this.getCustomPotionColor();
        class_1844 contents = null;
        if (potionLookupOpt.isPresent()) {
            Optional potHolder;
            class_7225.class_7226 potionLookup = (class_7225.class_7226)potionLookupOpt.get();
            class_2960 rl = potionStr.isEmpty() ? class_2960.method_60654((String)"minecraft:empty") : class_2960.method_12829((String)potionStr);
            Optional<Object> pot = Optional.empty();
            if (rl != null && (potHolder = potionLookup.method_46746(class_5321.method_29179((class_5321)class_7924.field_41215, (class_2960)rl))).isPresent()) {
                pot = Optional.of((class_6880)potHolder.get());
            }
            contents = new class_1844(pot, customColor != Integer.MIN_VALUE ? Optional.of(customColor) : Optional.empty(), effects);
        }
        if (contents != null) {
            stack.method_57379(class_9334.field_49651, contents);
        } else {
            stack.method_57381(class_9334.field_49651);
        }
        if (this.getData().method_10573("tag", 10)) {
            class_2487 tag = this.getTag();
            tag.method_10551("Potion");
            tag.method_10551("CustomPotionColor");
            tag.method_10551("custom_potion_effects");
        }
    }

    private void addPotionEffect(String id, int amplifier, int duration, boolean ambient, boolean showParticles, boolean showIcon) {
        class_2487 tag = new class_2487();
        tag.method_10582("id", id);
        tag.method_10569("amplifier", amplifier);
        tag.method_10569("duration", duration);
        tag.method_10556("ambient", ambient);
        tag.method_10556("show_particles", showParticles);
        tag.method_10556("show_icon", showIcon);
        this.potionEffectList.add((Object)tag);
    }

    private static class_2487 toTag(class_1293 e) {
        class_2487 tag = new class_2487();
        String id = e.method_5579().method_40230().map(k -> k.method_29177().toString()).orElse("");
        tag.method_10582("id", id);
        tag.method_10569("amplifier", e.method_5578());
        tag.method_10569("duration", e.method_5584());
        tag.method_10556("ambient", e.method_5591());
        tag.method_10556("show_particles", e.method_5581());
        tag.method_10556("show_icon", e.method_5592());
        return tag;
    }
}

