/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.entry;

import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.franckyi.databindings.api.ObservableBooleanValue;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.LabeledEntryModel;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_5250;

public abstract class ValueEntryModel<T>
extends LabeledEntryModel {
    protected T defaultValue;
    private final ObjectProperty<T> valueProperty;
    private final ObservableBooleanValue valueChangedProperty;
    protected Predicate<T> validator;
    protected final Consumer<T> action;

    protected ValueEntryModel(CategoryModel category, class_5250 label, T value, Consumer<T> action) {
        this(category, label, value, action, t -> true);
    }

    protected ValueEntryModel(CategoryModel category, class_5250 label, T value, Consumer<T> action, Predicate<T> validator) {
        super(category, label);
        this.defaultValue = value;
        this.valueProperty = ObjectProperty.create(value);
        this.valueChangedProperty = this.valueProperty.mapToBoolean(v -> !Objects.equals(v, this.defaultValue));
        this.validator = validator;
        this.action = action;
    }

    @Override
    public void reset() {
        this.valueProperty.setValue(this.defaultValue);
    }

    public T getValue() {
        return this.valueProperty().getValue();
    }

    public ObjectProperty<T> valueProperty() {
        return this.valueProperty;
    }

    public void setValue(T value) {
        this.valueProperty().setValue(value);
    }

    public ObservableBooleanValue valueChangedProperty() {
        return this.valueChangedProperty;
    }

    public boolean validate(T value) {
        return this.validator.test(value);
    }

    @Override
    public void apply() {
        this.action.accept(this.getValue());
        this.defaultValue = this.getValue();
    }
}

