/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.entry.item;

import com.github.franckyi.databindings.api.BooleanProperty;
import com.github.franckyi.databindings.api.IntegerProperty;
import com.github.rinorsi.cadeditor.client.ClientCache;
import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.EntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.SelectionEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.ListSelectionElementModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.List;
import net.minecraft.class_5250;

public class PotionEffectEntryModel
extends SelectionEntryModel {
    private final IntegerProperty amplifierProperty;
    private final IntegerProperty durationProperty;
    private final BooleanProperty ambientProperty;
    private final BooleanProperty showParticlesProperty;
    private final BooleanProperty showIconProperty;
    private final BooleanProperty useSecondsProperty;
    private final PotionEffectConsumer callback;
    private boolean defaultUseSeconds;

    public PotionEffectEntryModel(CategoryModel category, String id, int amplifier, int duration, boolean ambient, boolean showParticles, boolean showIcon, PotionEffectConsumer callback) {
        super(category, (class_5250)null, id, (String s) -> {});
        this.amplifierProperty = IntegerProperty.create(amplifier);
        this.durationProperty = IntegerProperty.create(duration);
        this.ambientProperty = BooleanProperty.create(ambient);
        this.showParticlesProperty = BooleanProperty.create(showParticles);
        this.showIconProperty = BooleanProperty.create(showIcon);
        boolean useSeconds = duration % 20 == 0;
        this.useSecondsProperty = BooleanProperty.create(useSeconds);
        this.callback = callback;
        this.defaultUseSeconds = useSeconds;
    }

    @Override
    public void apply() {
        this.callback.consume((String)this.getValue(), this.getAmplifier(), this.getDuration(), this.isAmbient(), this.isShowParticles(), this.isShowIcon());
        this.defaultUseSeconds = this.isUseSeconds();
    }

    @Override
    public void reset() {
        super.reset();
        this.setUseSeconds(this.defaultUseSeconds);
    }

    public int getAmplifier() {
        return this.amplifierProperty().getValue();
    }

    public IntegerProperty amplifierProperty() {
        return this.amplifierProperty;
    }

    public void setAmplifier(int value) {
        this.amplifierProperty().setValue(value);
    }

    public int getDuration() {
        return this.durationProperty().getValue();
    }

    public IntegerProperty durationProperty() {
        return this.durationProperty;
    }

    public void setDuration(int value) {
        this.durationProperty().setValue(value);
    }

    public boolean isAmbient() {
        return this.ambientProperty().getValue();
    }

    public BooleanProperty ambientProperty() {
        return this.ambientProperty;
    }

    public void setAmbient(boolean value) {
        this.ambientProperty().setValue(value);
    }

    public boolean isShowParticles() {
        return this.showParticlesProperty().getValue();
    }

    public BooleanProperty showParticlesProperty() {
        return this.showParticlesProperty;
    }

    public void setShowParticles(boolean value) {
        this.showParticlesProperty().setValue(value);
    }

    public boolean isShowIcon() {
        return this.showIconProperty().getValue();
    }

    public BooleanProperty showIconProperty() {
        return this.showIconProperty;
    }

    public void setShowIcon(boolean value) {
        this.showIconProperty().setValue(value);
    }

    public boolean isUseSeconds() {
        return this.useSecondsProperty().getValue();
    }

    public BooleanProperty useSecondsProperty() {
        return this.useSecondsProperty;
    }

    public void setUseSeconds(boolean value) {
        this.useSecondsProperty().setValue(value);
    }

    @Override
    public EntryModel.Type getType() {
        return EntryModel.Type.POTION_EFFECT;
    }

    @Override
    public List<String> getSuggestions() {
        return ClientCache.getEffectSuggestions();
    }

    @Override
    public class_5250 getSelectionScreenTitle() {
        return ModTexts.EFFECTS;
    }

    @Override
    public List<? extends ListSelectionElementModel> getSelectionItems() {
        return ClientCache.getEffectSelectionItems();
    }

    @FunctionalInterface
    public static interface PotionEffectConsumer {
        public void consume(String var1, int var2, int var3, boolean var4, boolean var5, boolean var6);
    }
}

