/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.model.entry.item;

import com.github.rinorsi.cadeditor.client.screen.model.category.CategoryModel;
import com.github.rinorsi.cadeditor.client.screen.model.entry.SelectionEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.ListSelectionElementModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class RaritySelectionEntryModel
extends SelectionEntryModel {
    private static final List<String> VALUES = List.of("common", "uncommon", "rare", "epic");

    public RaritySelectionEntryModel(CategoryModel category, class_5250 label, String value, Consumer<String> action) {
        super(category, label, RaritySelectionEntryModel.normalize(value), action);
    }

    private static String normalize(String v) {
        if (v == null || v.isEmpty()) {
            return "common";
        }
        String s = v.contains(":") ? v.substring(v.indexOf(58) + 1) : v;
        s = s.toLowerCase();
        return VALUES.contains(s) ? s : "common";
    }

    @Override
    public void setValue(String value) {
        super.setValue(RaritySelectionEntryModel.normalize(value));
    }

    @Override
    public List<String> getSuggestions() {
        return VALUES;
    }

    @Override
    public class_5250 getSelectionScreenTitle() {
        return ModTexts.gui("rarity");
    }

    @Override
    public List<? extends ListSelectionElementModel> getSelectionItems() {
        ArrayList<ListSelectionElementModel> list = new ArrayList<ListSelectionElementModel>();
        for (String s : VALUES) {
            String key = "cadeditor.gui.rarity." + s;
            list.add(new ListSelectionElementModel(key, class_2960.method_60654((String)("minecraft:" + s))));
        }
        return list;
    }
}

