/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.view;

import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.franckyi.guapi.api.node.HBox;
import com.github.franckyi.guapi.api.node.Node;
import com.github.franckyi.guapi.api.node.TexturedButton;
import com.github.franckyi.guapi.api.node.builder.TexturedButtonBuilder;
import com.github.rinorsi.cadeditor.client.ModTextures;
import com.github.rinorsi.cadeditor.client.screen.view.CategoryEntryScreenView;
import com.github.rinorsi.cadeditor.client.util.texteditor.StyleType;
import com.github.rinorsi.cadeditor.client.util.texteditor.TextEditorActionHandler;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class StandardEditorView
extends CategoryEntryScreenView {
    private List<TexturedButton> colorButtons;
    private TexturedButton customColorButton;
    private TexturedButtonBuilder chooseCustomColorButton;
    private HBox textEditorButtons;
    private Supplier<TextEditorActionHandler> textEditorSupplier;

    @Override
    public void build() {
        super.build();
        this.colorButtons = Arrays.asList(this.createTextColorButton("black", ModTextures.COLOR_BLACK, ModTexts.BLACK), this.createTextColorButton("dark_blue", ModTextures.COLOR_DARK_BLUE, ModTexts.DARK_BLUE), this.createTextColorButton("dark_green", ModTextures.COLOR_DARK_GREEN, ModTexts.DARK_GREEN), this.createTextColorButton("dark_aqua", ModTextures.COLOR_DARK_AQUA, ModTexts.DARK_AQUA), this.createTextColorButton("dark_red", ModTextures.COLOR_DARK_RED, ModTexts.DARK_RED), this.createTextColorButton("dark_purple", ModTextures.COLOR_DARK_PURPLE, ModTexts.DARK_PURPLE), this.createTextColorButton("gold", ModTextures.COLOR_GOLD, ModTexts.GOLD), this.createTextColorButton("gray", ModTextures.COLOR_GRAY, ModTexts.GRAY), this.createTextColorButton("dark_gray", ModTextures.COLOR_DARK_GRAY, ModTexts.DARK_GRAY), this.createTextColorButton("blue", ModTextures.COLOR_BLUE, ModTexts.BLUE), this.createTextColorButton("green", ModTextures.COLOR_GREEN, ModTexts.GREEN), this.createTextColorButton("aqua", ModTextures.COLOR_AQUA, ModTexts.AQUA), this.createTextColorButton("red", ModTextures.COLOR_RED, ModTexts.RED), this.createTextColorButton("light_purple", ModTextures.COLOR_LIGHT_PURPLE, ModTexts.LIGHT_PURPLE), this.createTextColorButton("yellow", ModTextures.COLOR_YELLOW, ModTexts.YELLOW), this.createTextColorButton("white", ModTextures.COLOR_WHITE, ModTexts.WHITE));
        this.textEditorButtons = (HBox)GuapiHelper.hBox(buttons -> {
            buttons.add(GuapiHelper.hBox(middle -> {
                middle.add(this.createTextButton(StyleType.BOLD, ModTextures.TEXT_BOLD, ModTexts.BOLD));
                middle.add(this.createTextButton(StyleType.ITALIC, ModTextures.TEXT_ITALIC, ModTexts.ITALIC));
                middle.add(this.createTextButton(StyleType.UNDERLINED, ModTextures.TEXT_UNDERLINED, ModTexts.UNDERLINED));
                middle.add(this.createTextButton(StyleType.STRIKETHROUGH, ModTextures.TEXT_STRIKETHROUGH, ModTexts.STRIKETHROUGH));
                middle.add(this.createTextButton(StyleType.OBFUSCATED, ModTextures.TEXT_OBFUSCATED, ModTexts.OBFUSCATED));
                middle.spacing(2);
            }));
            buttons.add(GuapiHelper.hBox(right -> {
                right.add((Node)((TexturedButtonBuilder)GuapiHelper.texturedButton(ModTextures.RESET_COLOR, 7, 16, false).tooltip(new class_2561[]{ModTexts.RESET_COLOR})).action(e -> {
                    if (this.textEditorSupplier != null) {
                        e.consume();
                        this.textEditorSupplier.get().removeColorFormatting();
                    }
                }));
                right.add(GuapiHelper.vBox(colors -> {
                    colors.add(GuapiHelper.hBox(2, this.colorButtons.subList(0, this.colorButtons.size() / 2)));
                    colors.add(GuapiHelper.hBox(2, this.colorButtons.subList(this.colorButtons.size() / 2, this.colorButtons.size())));
                    colors.spacing(2);
                }));
                this.customColorButton = (TexturedButton)((TexturedButtonBuilder)((TexturedButtonBuilder)GuapiHelper.texturedButton(null, 1, 1, false).prefSize(7, 16)).visible(false)).tooltip(new class_2561[]{ModTexts.CUSTOM_COLOR});
                right.add(this.customColorButton);
                this.chooseCustomColorButton = (TexturedButtonBuilder)GuapiHelper.texturedButton(ModTextures.COLOR_CUSTOM, 16, 16, false).tooltip(new class_2561[]{ModTexts.choose(ModTexts.CUSTOM_COLOR)});
                right.add(this.chooseCustomColorButton);
                right.spacing(2);
            }));
            buttons.spacing(10);
        }).align(GuapiHelper.CENTER_RIGHT);
        this.buttonBarRight.getChildren().add(0, this.textEditorButtons);
    }

    private TexturedButtonBuilder createTextButton(StyleType target, class_2960 id, class_5250 tooltipText) {
        return (TexturedButtonBuilder)((TexturedButtonBuilder)GuapiHelper.texturedButton(id, 16, 16, false).tooltip(new class_2561[]{tooltipText})).action(e -> {
            if (this.textEditorSupplier != null) {
                e.consume();
                this.textEditorSupplier.get().addStyleFormatting(target);
            }
        });
    }

    private TexturedButtonBuilder createTextColorButton(String color, class_2960 id, class_5250 tooltipText) {
        return (TexturedButtonBuilder)((TexturedButtonBuilder)GuapiHelper.texturedButton(id, 7, 7, false).tooltip(new class_2561[]{tooltipText})).action(e -> {
            if (this.textEditorSupplier != null) {
                e.consume();
                this.textEditorSupplier.get().addColorFormatting(color);
            }
        });
    }

    public TexturedButton getCustomColorButton() {
        return this.customColorButton;
    }

    public TexturedButton getChooseCustomColorButton() {
        return this.chooseCustomColorButton;
    }

    public HBox getTextEditorButtons() {
        return this.textEditorButtons;
    }

    public void setTextEditorSupplier(Supplier<TextEditorActionHandler> supplier) {
        this.textEditorSupplier = supplier;
    }
}

