/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.view;

import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.franckyi.guapi.api.node.Button;
import com.github.franckyi.guapi.api.node.HBox;
import com.github.franckyi.guapi.api.node.Label;
import com.github.franckyi.guapi.api.node.ListView;
import com.github.franckyi.guapi.api.node.Node;
import com.github.franckyi.guapi.api.node.builder.HBoxBuilder;
import com.github.franckyi.guapi.api.node.builder.LabelBuilder;
import com.github.franckyi.guapi.api.node.builder.ListViewBuilder;
import com.github.franckyi.guapi.api.node.builder.VBoxBuilder;
import com.github.rinorsi.cadeditor.client.UpdateLogRegistry;
import com.github.rinorsi.cadeditor.client.screen.model.UpdateLogScreenModel;
import com.github.rinorsi.cadeditor.client.screen.view.ScreenView;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class UpdateLogScreenView
extends ScreenView {
    private Label introLabel;
    private ListView<UpdateLogRegistry.UpdateLogEntry> versionList;
    private ListView<UpdateLogScreenModel.SectionLine> detailList;
    private Label versionTitle;
    private Label versionMeta;
    private Button markReadButton;
    private Button markAllReadButton;
    private Button copyButton;
    private HBox unreadBadge;
    private final Map<String, Label> versionUnreadIndicators = new HashMap<String, Label>();
    private boolean hasUnreadLatest;
    private String latestUnreadVersion = "";

    @Override
    public void build() {
        super.build();
        this.buttonBarCenter.getChildren().add(GuapiHelper.hBox(center -> {
            this.markAllReadButton = GuapiHelper.button((class_2561)ModTexts.UPDATE_LOG_MARK_ALL_READ);
            center.add(this.markAllReadButton);
            this.markReadButton = GuapiHelper.button((class_2561)ModTexts.UPDATE_LOG_MARK_READ);
            center.add(this.markReadButton);
            this.copyButton = GuapiHelper.button((class_2561)ModTexts.UPDATE_LOG_COPY);
            center.add(this.copyButton);
            center.spacing(6);
        }));
        this.setUnreadBadgeVisible(false);
    }

    @Override
    protected class_5250 getHeaderLabelText() {
        return ModTexts.UPDATE_LOG_TITLE;
    }

    @Override
    protected Node createEditor() {
        return GuapiHelper.hBox(root -> {
            root.add(GuapiHelper.vBox(left -> {
                left.add((Node)GuapiHelper.label((class_2561)ModTexts.UPDATE_LOG_RECENT).textAlign(GuapiHelper.CENTER_LEFT));
                this.versionList = GuapiHelper.listView(UpdateLogRegistry.UpdateLogEntry.class, list -> ((ListViewBuilder)((ListViewBuilder)list.itemHeight(18)).childrenFocusable(false)).renderer(entry -> {
                    LabelBuilder indicator = (LabelBuilder)((LabelBuilder)((LabelBuilder)GuapiHelper.label((class_2561)GuapiHelper.text("\u25cf").method_27692(class_124.field_1065)).textAlign(GuapiHelper.CENTER)).prefWidth(12)).visible(false);
                    this.versionUnreadIndicators.put(entry.version(), indicator);
                    LabelBuilder rowLabel = (LabelBuilder)((LabelBuilder)GuapiHelper.label((class_2561)entry.displayName()).textAlign(GuapiHelper.CENTER_LEFT)).padding(4);
                    rowLabel.onMouseClick(() -> this.versionList.setFocusedElement((UpdateLogRegistry.UpdateLogEntry)entry));
                    HBoxBuilder row = GuapiHelper.hBox(item -> {
                        item.add(indicator);
                        item.add(rowLabel, 1);
                        ((HBoxBuilder)item.spacing(4)).align(GuapiHelper.CENTER_LEFT);
                    });
                    row.onMouseClick(() -> this.versionList.setFocusedElement((UpdateLogRegistry.UpdateLogEntry)entry));
                    indicator.setVisible(this.hasUnreadLatest && entry.version().equals(this.latestUnreadVersion));
                    return row;
                }));
                left.add(this.versionList, 1);
                ((VBoxBuilder)left.spacing(5)).fillWidth();
            }), 2);
            root.add(GuapiHelper.vBox(right -> {
                right.add(GuapiHelper.hBox(titleRow -> {
                    this.versionTitle = GuapiHelper.label().textAlign(GuapiHelper.CENTER_LEFT);
                    titleRow.add(this.versionTitle, 1);
                    this.unreadBadge = GuapiHelper.hBox(badge -> {
                        badge.add(GuapiHelper.label((class_2561)ModTexts.UPDATE_LOG_NEW));
                        ((HBoxBuilder)((HBoxBuilder)badge.padding(2, 6)).backgroundColor(-1426107051)).align(GuapiHelper.CENTER);
                    });
                    titleRow.add(this.unreadBadge);
                    ((HBoxBuilder)titleRow.align(GuapiHelper.CENTER_LEFT)).spacing(5);
                }));
                this.versionMeta = GuapiHelper.label().textAlign(GuapiHelper.CENTER_LEFT);
                right.add(this.versionMeta);
                this.introLabel = GuapiHelper.label().textAlign(GuapiHelper.CENTER_LEFT);
                right.add(this.introLabel);
                this.detailList = GuapiHelper.listView(UpdateLogScreenModel.SectionLine.class, list -> ((ListViewBuilder)((ListViewBuilder)((ListViewBuilder)list.itemHeight(18)).childrenFocusable(false)).renderer(line -> ((LabelBuilder)GuapiHelper.label((class_2561)line.text()).textAlign(GuapiHelper.CENTER_LEFT)).padding(4))).padding(4));
                right.add(this.detailList, 1);
                ((VBoxBuilder)right.spacing(5)).fillWidth();
            }), 5);
            ((HBoxBuilder)root.fillHeight()).spacing(10);
        });
    }

    public Label getIntroLabel() {
        return this.introLabel;
    }

    public ListView<UpdateLogRegistry.UpdateLogEntry> getVersionList() {
        return this.versionList;
    }

    public ListView<UpdateLogScreenModel.SectionLine> getDetailList() {
        return this.detailList;
    }

    public Button getMarkReadButton() {
        return this.markReadButton;
    }

    public Button getMarkAllReadButton() {
        return this.markAllReadButton;
    }

    public Button getCopyButton() {
        return this.copyButton;
    }

    public void renderEntry(UpdateLogRegistry.UpdateLogEntry entry) {
        if (entry == null) {
            this.versionTitle.setLabel((class_2561)GuapiHelper.EMPTY_TEXT);
            this.versionMeta.setLabel((class_2561)GuapiHelper.EMPTY_TEXT);
            this.introLabel.setLabel((class_2561)GuapiHelper.EMPTY_TEXT);
            return;
        }
        this.versionTitle.setLabel((class_2561)entry.displayName());
        this.versionMeta.setLabel((class_2561)entry.dateLabel());
    }

    public void setUnreadBadgeVisible(boolean visible) {
        this.unreadBadge.setVisible(visible);
    }

    public void resetVersionIndicators() {
        this.versionUnreadIndicators.clear();
    }

    public void updateUnreadState(boolean hasUnread, String latestVersion) {
        this.hasUnreadLatest = hasUnread;
        this.latestUnreadVersion = latestVersion == null ? "" : latestVersion;
        this.updateVersionIndicators();
    }

    private void updateVersionIndicators() {
        this.versionUnreadIndicators.forEach((version, indicator) -> indicator.setVisible(this.hasUnreadLatest && version.equals(this.latestUnreadVersion)));
    }
}

