/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.common.logic;

import com.github.rinorsi.cadeditor.common.CommonUtil;
import com.github.rinorsi.cadeditor.common.ModTexts;
import com.github.rinorsi.cadeditor.common.logic.PermissionLogic;
import com.github.rinorsi.cadeditor.common.network.BlockEditorPacket;
import com.github.rinorsi.cadeditor.common.network.BlockInventoryItemEditorPacket;
import com.github.rinorsi.cadeditor.common.network.EntityEditorPacket;
import com.github.rinorsi.cadeditor.common.network.EntityInventoryItemEditorPacket;
import com.github.rinorsi.cadeditor.common.network.MainHandItemEditorPacket;
import com.github.rinorsi.cadeditor.common.network.PlayerInventoryItemEditorPacket;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2649;
import net.minecraft.class_2653;
import net.minecraft.class_2680;
import net.minecraft.class_2739;
import net.minecraft.class_2744;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ServerEditorUpdateLogic {
    private static final class_2561 VERIFICATION_FAILED = class_2561.method_43470((String)"Update verification failed; inventory re-synced. Please check the item.");
    private static final Logger LOGGER = LogManager.getLogger();

    private ServerEditorUpdateLogic() {
    }

    public static void onMainHandItemEditorUpdate(class_3222 player, MainHandItemEditorPacket.Update response) {
        class_1799 normalizedStack = ServerEditorUpdateLogic.normalize(response.getItemStack());
        if (!PermissionLogic.hasPermission(player)) {
            CommonUtil.showItemUpdateFailure((class_1657)player, normalizedStack, (class_2561)ModTexts.errorPermissionDenied(ModTexts.ITEM));
            return;
        }
        try {
            int hotbarIdx = player.method_31548().field_7545;
            player.method_31548().method_5447(hotbarIdx, normalizedStack.method_7972());
            player.method_6122(class_1268.field_5808, normalizedStack.method_7972());
            player.method_31548().method_5431();
            if (player.field_7512 != null) {
                player.field_7512.method_7623();
            }
            ServerEditorUpdateLogic.syncMainHand(player);
            ServerEditorUpdateLogic.queueMainHandVerification(player, normalizedStack);
        }
        catch (Exception e) {
            LOGGER.error("Failed to apply main hand item update for {}", (Object)player.method_7334().getName(), (Object)e);
            CommonUtil.showItemUpdateFailure((class_1657)player, normalizedStack, (class_2561)ModTexts.Messages.ERROR_GENERIC);
        }
    }

    public static void onPlayerInventoryItemEditorUpdate(class_3222 player, PlayerInventoryItemEditorPacket.Update response) {
        class_1799 normalizedStack = ServerEditorUpdateLogic.normalize(response.getItemStack());
        if (!PermissionLogic.hasPermission(player)) {
            CommonUtil.showItemUpdateFailure((class_1657)player, normalizedStack, (class_2561)ModTexts.errorPermissionDenied(ModTexts.ITEM));
            return;
        }
        try {
            player.method_31548().method_5447(response.getSlot(), normalizedStack.method_7972());
            player.method_31548().method_5431();
            if (player.field_7512 != null) {
                player.field_7512.method_7623();
            }
            ServerEditorUpdateLogic.syncInventorySlot(player, response.getSlot());
            ServerEditorUpdateLogic.queueInventoryVerification(player, response.getSlot(), normalizedStack);
        }
        catch (Exception e) {
            LOGGER.error("Failed to apply inventory item update for {} (slot {})", (Object)player.method_7334().getName(), (Object)response.getSlot(), (Object)e);
            CommonUtil.showItemUpdateFailure((class_1657)player, normalizedStack, (class_2561)ModTexts.Messages.ERROR_GENERIC);
        }
    }

    public static void onBlockInventoryItemEditorUpdate(class_3222 player, BlockInventoryItemEditorPacket.Update response) {
        class_1799 normalizedStack = ServerEditorUpdateLogic.normalize(response.getItemStack());
        if (!PermissionLogic.hasPermission(player)) {
            CommonUtil.showItemUpdateFailure((class_1657)player, normalizedStack, (class_2561)ModTexts.errorPermissionDenied(ModTexts.ITEM));
            return;
        }
        class_1937 level = player.method_37908();
        class_2338 pos = response.getBlockPos();
        class_2680 state = level.method_8320(pos);
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof class_1263) {
            class_1263 container = (class_1263)class_25862;
            try {
                container.method_5447(response.getSlot(), normalizedStack.method_7972());
                container.method_5431();
                level.method_8413(pos, state, state, 2);
                CommonUtil.showItemUpdateSuccess((class_1657)player, normalizedStack);
                if (player.field_7512 != null) {
                    player.field_7512.method_7623();
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to update block inventory at {} (slot {}) for {}", (Object)pos, (Object)response.getSlot(), (Object)player.method_7334().getName(), (Object)e);
                CommonUtil.showItemUpdateFailure((class_1657)player, normalizedStack, (class_2561)ModTexts.Messages.ERROR_GENERIC);
            }
        } else {
            CommonUtil.showItemUpdateFailure((class_1657)player, normalizedStack, (class_2561)class_2561.method_43469((String)"cadeditor.message.no_target_found", (Object[])new Object[]{ModTexts.ITEM}));
        }
    }

    public static void onEntityInventoryItemEditorUpdate(class_3222 player, EntityInventoryItemEditorPacket.Update response) {
        class_1799 normalizedStack = ServerEditorUpdateLogic.normalize(response.getItemStack());
        if (!PermissionLogic.hasPermission(player)) {
            CommonUtil.showItemUpdateFailure((class_1657)player, normalizedStack, (class_2561)ModTexts.errorPermissionDenied(ModTexts.ITEM));
            return;
        }
        class_1937 level = player.method_37908();
        class_1297 class_12972 = level.method_8469(response.getEntityId());
        if (class_12972 instanceof class_1263) {
            class_1263 container = (class_1263)class_12972;
            try {
                container.method_5447(response.getSlot(), normalizedStack.method_7972());
                container.method_5431();
                CommonUtil.showItemUpdateSuccess((class_1657)player, normalizedStack);
                if (player.field_7512 != null) {
                    player.field_7512.method_7623();
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to update entity inventory for entity {} (slot {})", (Object)response.getEntityId(), (Object)response.getSlot(), (Object)e);
                CommonUtil.showItemUpdateFailure((class_1657)player, normalizedStack, (class_2561)ModTexts.Messages.ERROR_GENERIC);
            }
        } else {
            CommonUtil.showItemUpdateFailure((class_1657)player, normalizedStack, (class_2561)class_2561.method_43469((String)"cadeditor.message.no_target_found", (Object[])new Object[]{ModTexts.ITEM}));
        }
    }

    public static void onBlockEditorUpdate(class_3222 player, BlockEditorPacket.Update update) {
        if (!PermissionLogic.hasPermission(player)) {
            CommonUtil.showPermissionError((class_1657)player, ModTexts.BLOCK);
            return;
        }
        class_1937 level = player.method_37908();
        class_2338 pos = update.getBlockPos();
        class_2680 oldState = level.method_8320(pos);
        try {
            level.method_8652(pos, update.getBlockState(), 3);
            class_2680 currentState = level.method_8320(pos);
            if (update.getTag() != null) {
                class_2586 blockEntity = level.method_8321(pos);
                if (blockEntity == null) {
                    CommonUtil.showTargetError((class_1657)player, ModTexts.BLOCK);
                    return;
                }
                blockEntity.method_58690(update.getTag(), (class_7225.class_7874)player.method_56673());
                blockEntity.method_5431();
            }
            level.method_8413(pos, oldState, currentState, 2);
            CommonUtil.showUpdateSuccess((class_1657)player, ModTexts.BLOCK);
        }
        catch (Exception e) {
            LOGGER.error("Failed to update block at {} for {}", (Object)pos, (Object)player.method_7334().getName(), (Object)e);
            CommonUtil.showMessage((class_1657)player, (class_2561)ModTexts.Messages.ERROR_GENERIC);
        }
    }

    public static void onEntityEditorUpdate(class_3222 player, EntityEditorPacket.Update update) {
        if (!PermissionLogic.hasPermission(player)) {
            CommonUtil.showPermissionError((class_1657)player, ModTexts.ENTITY);
            return;
        }
        class_1937 level = player.method_37908();
        class_1297 entity = level.method_8469(update.getEntityId());
        if (entity != null) {
            try {
                entity.method_5651(update.getTag());
                class_1937 class_19372 = entity.method_37908();
                if (class_19372 instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)class_19372;
                    serverLevel.method_14178().method_18751(entity, (class_2596)new class_2739(entity.method_5628(), entity.method_5841().method_46357()));
                }
                CommonUtil.showUpdateSuccess((class_1657)player, ModTexts.ENTITY);
            }
            catch (Exception e) {
                LOGGER.error("Failed to update entity {} for {}", (Object)update.getEntityId(), (Object)player.method_7334().getName(), (Object)e);
                CommonUtil.showMessage((class_1657)player, (class_2561)ModTexts.Messages.ERROR_GENERIC);
            }
        } else {
            CommonUtil.showTargetError((class_1657)player, ModTexts.ENTITY);
        }
    }

    private static int toMenuSlotIndex(int invIndex) {
        return invIndex >= 0 && invIndex < 9 ? 36 + invIndex : invIndex;
    }

    private static void syncMainHand(class_3222 player) {
        class_1703 menu = player.field_7512 != null ? player.field_7512 : player.field_7498;
        int stateId = menu.method_37422();
        int hotbarIdx = player.method_31548().field_7545;
        int menuSlot = 36 + hotbarIdx;
        player.field_13987.method_14364((class_2596)new class_2653(menu.field_7763, stateId, menuSlot, player.method_6047().method_7972()));
        player.field_13987.method_14364((class_2596)new class_2744(player.method_5628(), List.of(Pair.of((Object)class_1304.field_6173, (Object)player.method_6047().method_7972()))));
    }

    private static void syncInventorySlot(class_3222 player, int invIndex) {
        class_1703 menu = player.field_7512 != null ? player.field_7512 : player.field_7498;
        int stateId = menu.method_37422();
        int menuSlot = ServerEditorUpdateLogic.toMenuSlotIndex(invIndex);
        player.field_13987.method_14364((class_2596)new class_2653(menu.field_7763, stateId, menuSlot, player.method_31548().method_5438(invIndex).method_7972()));
    }

    private static void forceInventorySync(class_3222 player) {
        class_1703 menu = player.field_7512 != null ? player.field_7512 : player.field_7498;
        int stateId = menu.method_37422();
        player.field_13987.method_14364((class_2596)new class_2649(menu.field_7763, stateId, menu.method_7602(), menu.method_34255()));
        player.field_13987.method_14364((class_2596)new class_2744(player.method_5628(), List.of(Pair.of((Object)class_1304.field_6173, (Object)player.method_6047().method_7972()), Pair.of((Object)class_1304.field_6171, (Object)player.method_6079().method_7972()))));
    }

    private static void queueMainHandVerification(class_3222 player, class_1799 expected) {
        class_1799 expectedCopy = expected.method_7972();
        ServerEditorUpdateLogic.scheduleVerification(player, () -> {
            class_1799 current = player.method_6047();
            if (ServerEditorUpdateLogic.areStacksEquivalent(current, expectedCopy)) {
                CommonUtil.showItemUpdateSuccess((class_1657)player, expectedCopy);
            } else {
                ServerEditorUpdateLogic.logStackDiff("MainHand", current, expectedCopy, player);
                ServerEditorUpdateLogic.forceInventorySync(player);
                CommonUtil.showItemUpdateFailure((class_1657)player, expectedCopy, VERIFICATION_FAILED);
            }
        });
    }

    private static void queueInventoryVerification(class_3222 player, int slot, class_1799 expected) {
        int size = player.method_31548().method_5439();
        if (slot < 0 || slot >= size) {
            CommonUtil.showItemUpdateFailure((class_1657)player, expected, (class_2561)class_2561.method_43470((String)("Invalid slot: " + slot)));
            return;
        }
        class_1799 expectedCopy = expected.method_7972();
        ServerEditorUpdateLogic.scheduleVerification(player, () -> {
            class_1799 current = player.method_31548().method_5438(slot);
            if (ServerEditorUpdateLogic.areStacksEquivalent(current, expectedCopy)) {
                CommonUtil.showItemUpdateSuccess((class_1657)player, expectedCopy);
            } else {
                ServerEditorUpdateLogic.logStackDiff("InventorySlot", current, expectedCopy, player);
                ServerEditorUpdateLogic.forceInventorySync(player);
                CommonUtil.showItemUpdateFailure((class_1657)player, expectedCopy, VERIFICATION_FAILED);
            }
        });
    }

    private static void scheduleVerification(class_3222 player, Runnable action) {
        MinecraftServer server = player.method_51469().method_8503();
        server.execute(() -> server.execute(action));
    }

    private static void logStackDiff(String where, class_1799 actual, class_1799 expected, class_3222 player) {
        try {
            class_2509 ops = class_2509.field_11560;
            class_2520 actualData = class_1799.field_24671.encodeStart((DynamicOps)ops, (Object)actual).result().orElse(null);
            class_2520 expectedData = class_1799.field_24671.encodeStart((DynamicOps)ops, (Object)expected).result().orElse(null);
            LOGGER.warn("[{}] stack mismatch for {}. Actual={}, Expected={}", (Object)where, (Object)player.method_7334().getName(), (Object)actualData, (Object)expectedData);
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to diff stacks for {}", (Object)player.method_7334().getName(), (Object)ex);
        }
    }

    private static class_1799 normalize(class_1799 input) {
        if (input.method_7960()) {
            return class_1799.field_8037;
        }
        class_2509 ops = class_2509.field_11560;
        return class_1799.field_24671.encodeStart((DynamicOps)ops, (Object)input).result().flatMap(data -> class_1799.field_24671.parse((DynamicOps)ops, data).result()).orElse(input.method_7972());
    }

    private static boolean areStacksEquivalent(class_1799 a, class_1799 b) {
        if (a.method_7960() && b.method_7960()) {
            return true;
        }
        if (a.method_7960() || b.method_7960()) {
            return false;
        }
        return a.method_7947() == b.method_7947() && class_1799.method_31577((class_1799)a, (class_1799)b);
    }
}

