/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.fabric;

import com.github.rinorsi.cadeditor.common.network.NetworkHandler;
import com.github.rinorsi.cadeditor.common.network.PacketSerializer;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public final class PlatformUtilImpl {
    private static final Map<NetworkHandler<?>, class_8710.class_9154<?>> TYPES = new ConcurrentHashMap();

    private PlatformUtilImpl() {
    }

    public static Path getConfigDir() {
        return FabricLoader.getInstance().getConfigDir();
    }

    public static <P> void sendToServer(NetworkHandler.Server<P> handler, P packet) {
        ClientPlayNetworking.send(PlatformUtilImpl.wrap(handler, packet));
    }

    public static <P> void sendToClient(class_3222 player, NetworkHandler.Client<P> handler, P packet) {
        ServerPlayNetworking.send((class_3222)player, PlatformUtilImpl.wrap(handler, packet));
    }

    public static <P> void registerServerHandler(NetworkHandler.Server<P> handler) {
        class_8710.class_9154<WrappedPayload<P>> type = PlatformUtilImpl.type(handler);
        PayloadTypeRegistry.playC2S().register(type, PlatformUtilImpl.codec(handler));
        ServerPlayNetworking.registerGlobalReceiver(type, (payload, context) -> context.server().execute(() -> handler.getPacketHandler().handle(context.player(), payload.packet())));
    }

    public static <P> void registerClientHandler(NetworkHandler.Client<P> handler) {
        class_8710.class_9154<WrappedPayload<P>> type = PlatformUtilImpl.type(handler);
        PayloadTypeRegistry.playS2C().register(type, PlatformUtilImpl.codec(handler));
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientNetworking.register(type, handler);
        }
    }

    private static <P> class_9139<class_9129, WrappedPayload<P>> codec(NetworkHandler<P> handler) {
        PacketSerializer serializer = handler.getSerializer();
        return class_9139.method_56437((buf, payload) -> serializer.write(payload.packet(), (class_2540)buf), buf -> PlatformUtilImpl.wrap(handler, serializer.read((class_2540)buf)));
    }

    private static <P> class_8710.class_9154<WrappedPayload<P>> type(NetworkHandler<P> handler) {
        return TYPES.computeIfAbsent(handler, PlatformUtilImpl::createType);
    }

    private static class_8710.class_9154<?> createType(NetworkHandler<?> handler) {
        class_2960 location = handler.getLocation();
        return new class_8710.class_9154(location);
    }

    private static <P> WrappedPayload<P> wrap(NetworkHandler<P> handler, P packet) {
        return new WrappedPayload<P>(packet, PlatformUtilImpl.type(handler));
    }

    private static final class WrappedPayload<P>
    extends Record
    implements class_8710 {
        private final P packet;
        private final class_8710.class_9154<WrappedPayload<P>> type;

        private WrappedPayload(P packet, class_8710.class_9154<WrappedPayload<P>> type) {
            this.packet = packet;
            this.type = type;
        }

        public class_8710.class_9154<WrappedPayload<P>> method_56479() {
            return this.type;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{WrappedPayload.class, "packet;type", "packet", "type"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{WrappedPayload.class, "packet;type", "packet", "type"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{WrappedPayload.class, "packet;type", "packet", "type"}, this, o);
        }

        public P packet() {
            return this.packet;
        }
    }

    private static final class ClientNetworking {
        private ClientNetworking() {
        }

        private static <P> void register(class_8710.class_9154<WrappedPayload<P>> type, NetworkHandler.Client<P> handler) {
            ClientPlayNetworking.registerGlobalReceiver(type, (payload, context) -> context.client().execute(() -> handler.getPacketHandler().handle(payload.packet())));
        }
    }
}

