/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.databindings.api;

import com.github.franckyi.databindings.api.DataBindings;
import com.github.franckyi.databindings.api.DoubleProperty;
import com.github.franckyi.databindings.api.ObservableValue;
import java.util.function.DoubleSupplier;

public interface ObservableDoubleValue
extends ObservableValue<Double> {
    public static ObservableDoubleValue unmodifiable(final double value) {
        return new Unmodifiable(){

            @Override
            public Double get() {
                return value;
            }
        };
    }

    public static ObservableDoubleValue readOnly(DoubleProperty property) {
        return DataBindings.getPropertyFactory().createReadOnlyProperty(property);
    }

    public static ObservableDoubleValue observe(DoubleSupplier supplier, ObservableValue<?> ... triggers) {
        return DataBindings.getMappingFactory().createDoubleMapping(supplier, triggers);
    }

    default public double getValue() {
        return this.get() == null ? 0.0 : (Double)this.get();
    }

    default public ObservableDoubleValue add(double other) {
        return this.mapToDouble(i -> i + other);
    }

    default public ObservableDoubleValue substract(double other) {
        return this.mapToDouble(i -> i - other);
    }

    default public ObservableDoubleValue multiply(double other) {
        return this.mapToDouble(i -> i * other);
    }

    default public ObservableDoubleValue divide(double other) {
        return this.mapToDouble(i -> i / other);
    }

    default public ObservableDoubleValue add(ObservableValue<Double> other) {
        return ObservableDoubleValue.observe(() -> (Double)this.get() + (Double)other.get(), this, other);
    }

    default public ObservableDoubleValue substract(ObservableValue<Double> other) {
        return ObservableDoubleValue.observe(() -> (Double)this.get() - (Double)other.get(), this, other);
    }

    default public ObservableDoubleValue multiply(ObservableValue<Double> other) {
        return ObservableDoubleValue.observe(() -> (Double)this.get() * (Double)other.get(), this, other);
    }

    default public ObservableDoubleValue divide(ObservableValue<Double> other) {
        return ObservableDoubleValue.observe(() -> (Double)this.get() / (Double)other.get(), this, other);
    }

    public static abstract class Unmodifiable
    extends ObservableValue.Unmodifiable<Double>
    implements ObservableDoubleValue {
    }
}

