/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.api;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public final class RenderHelper {
    private static Minecraft mc() {
        return Minecraft.getInstance();
    }

    private static Font font() {
        return RenderHelper.mc().font;
    }

    public static int getFontHeight() {
        Objects.requireNonNull(RenderHelper.font());
        return 9;
    }

    public static int getFontWidth(Component text) {
        return RenderHelper.font().width((FormattedText)text);
    }

    public static void drawString(GuiGraphics guiGraphics, Component text, float x, float y, int color, boolean shadow) {
        guiGraphics.drawString(RenderHelper.font(), text, (int)x, (int)y, color, shadow);
    }

    public static void fillRectangle(GuiGraphics guiGraphics, int x0, int y0, int x1, int y1, int color) {
        guiGraphics.fill(x0, y0, x1, y1, color);
    }

    public static void drawVLine(GuiGraphics guiGraphics, int x, int y0, int y1, int color) {
        RenderHelper.fillRectangle(guiGraphics, x, y0, x + 1, y1, color);
    }

    public static void drawHLine(GuiGraphics guiGraphics, int y, int x0, int x1, int color) {
        RenderHelper.fillRectangle(guiGraphics, x0, y, x1, y + 1, color);
    }

    public static void drawRectangle(GuiGraphics guiGraphics, int x0, int y0, int x1, int y1, int color) {
        RenderHelper.drawHLine(guiGraphics, y0, x0, x1 - 1, color);
        RenderHelper.drawVLine(guiGraphics, x1 - 1, y0, y1 - 1, color);
        RenderHelper.drawHLine(guiGraphics, y1 - 1, x1, x0 + 1, color);
        RenderHelper.drawVLine(guiGraphics, x0, y1, y0 + 1, color);
    }

    public static void drawTexture(GuiGraphics guiGraphics, ResourceLocation id, int x, int y, int width, int height, int imageX, int imageY, int imageWidth, int imageHeight) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)id);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        guiGraphics.blit(id, x, y, 0, (float)imageX, (float)imageY, width, height, imageWidth, imageHeight);
    }

    public static void drawSprite(GuiGraphics guiGraphics, TextureAtlasSprite sprite, int x, int y, int imageWidth, int imageHeight) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.atlasLocation());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(x, y, 0, imageWidth, imageHeight, sprite);
    }

    public static void drawTooltip(GuiGraphics guiGraphics, List<Component> text, int x, int y) {
        guiGraphics.renderComponentTooltip(RenderHelper.font(), text, x, y);
    }

    public static void drawTooltip(GuiGraphics guiGraphics, ItemStack itemStack, int x, int y) {
        Minecraft minecraft = Minecraft.getInstance();
        Item.TooltipContext context = minecraft.level != null ? Item.TooltipContext.of((Level)minecraft.level) : (minecraft.getConnection() != null ? Item.TooltipContext.of((HolderLookup.Provider)minecraft.getConnection().registryAccess()) : Item.TooltipContext.EMPTY);
        guiGraphics.renderComponentTooltip(RenderHelper.font(), itemStack.getTooltipLines(context, (Player)minecraft.player, (TooltipFlag)TooltipFlag.Default.NORMAL), x, y);
    }

    public static void drawItem(GuiGraphics guiGraphics, ItemStack itemStack, int x, int y) {
        guiGraphics.renderFakeItem(itemStack, x, y);
    }

    public static void drawItemDecorations(GuiGraphics guiGraphics, ItemStack itemStack, int x, int y) {
        guiGraphics.renderItemDecorations(RenderHelper.font(), itemStack, x, y);
    }
}

