/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.base.node;

import com.github.franckyi.databindings.api.IntegerProperty;
import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.franckyi.guapi.api.node.Box;
import com.github.franckyi.guapi.api.node.Node;
import com.github.franckyi.guapi.api.util.Align;
import com.github.franckyi.guapi.base.node.AbstractGroup;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractBox
extends AbstractGroup
implements Box {
    private final IntegerProperty spacingProperty = IntegerProperty.create();
    private final ObjectProperty<Align> alignmentProperty = ObjectProperty.create(Align.TOP_LEFT);
    protected final Map<Node, Integer> weightMap = new HashMap<Node, Integer>();

    protected AbstractBox(int spacing, Collection<? extends Node> children) {
        super(children);
        this.setSpacing(spacing);
        this.spacingProperty().addListener(this::shouldComputeSize);
        this.alignmentProperty().addListener(this::shouldUpdateChildren);
    }

    @Override
    public int getSpacing() {
        return this.spacingProperty().getValue();
    }

    @Override
    public IntegerProperty spacingProperty() {
        return this.spacingProperty;
    }

    @Override
    public void setSpacing(int value) {
        this.spacingProperty().setValue(value);
    }

    @Override
    public Align getAlignment() {
        return (Align)((Object)this.alignmentProperty().getValue());
    }

    @Override
    public ObjectProperty<Align> alignmentProperty() {
        return this.alignmentProperty;
    }

    @Override
    public void setAlignment(Align value) {
        this.alignmentProperty().setValue(value);
    }

    @Override
    public void setWeight(Node node, int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Weight must be positive");
        }
        if (!this.getChildren().contains(node)) {
            throw new IllegalArgumentException("This WeightedVBox doesn't contain the Node " + String.valueOf(node));
        }
        Integer old = this.weightMap.put(node, value);
        if (!Objects.equals(old, value)) {
            this.shouldUpdateChildren();
        }
    }

    @Override
    public void resetWeight(Node node) {
        if (this.weightMap.remove(node) != 0) {
            this.shouldUpdateChildren();
        }
    }

    @Override
    public int getWeight(Node node) {
        Integer value = this.weightMap.get(node);
        if (value == null) {
            return 0;
        }
        return value;
    }
}

