/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.base.node;

import com.github.franckyi.databindings.api.IntegerProperty;
import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.franckyi.guapi.api.node.SpriteView;
import com.github.franckyi.guapi.base.node.AbstractControl;
import java.util.function.Supplier;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public abstract class AbstractSpriteView
extends AbstractControl
implements SpriteView {
    private final ObjectProperty<Supplier<TextureAtlasSprite>> spriteFactoryProperty = ObjectProperty.create();
    private final IntegerProperty imageWidthProperty = IntegerProperty.create();
    private final IntegerProperty imageHeightProperty = IntegerProperty.create();
    private TextureAtlasSprite cachedSprite;

    protected AbstractSpriteView() {
        this.spriteFactoryProperty().addListener(() -> {
            this.cachedSprite = null;
        });
    }

    protected AbstractSpriteView(Supplier<TextureAtlasSprite> spriteFactory) {
        this();
        this.setSpriteFactory(spriteFactory);
    }

    protected AbstractSpriteView(Supplier<TextureAtlasSprite> spriteFactory, int imageWidth, int imageHeight) {
        this(spriteFactory);
        this.setImageWidth(imageWidth);
        this.setImageHeight(imageHeight);
        this.setPrefWidth(imageWidth);
        this.setPrefHeight(imageHeight);
    }

    @Override
    public ObjectProperty<Supplier<TextureAtlasSprite>> spriteFactoryProperty() {
        return this.spriteFactoryProperty;
    }

    @Override
    public TextureAtlasSprite getSprite() {
        if (this.cachedSprite == null) {
            this.cachedSprite = this.getSpriteFactory().get();
        }
        return this.cachedSprite;
    }

    @Override
    public IntegerProperty imageWidthProperty() {
        return this.imageWidthProperty;
    }

    @Override
    public IntegerProperty imageHeightProperty() {
        return this.imageHeightProperty;
    }
}

