/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.base.theme.vanilla.delegate;

import com.github.franckyi.guapi.api.Color;
import com.github.franckyi.guapi.api.RenderHelper;
import com.github.franckyi.guapi.api.event.MouseButtonEvent;
import com.github.franckyi.guapi.api.event.MouseDragEvent;
import com.github.franckyi.guapi.api.event.MouseEvent;
import com.github.franckyi.guapi.api.event.MouseScrollEvent;
import com.github.franckyi.guapi.api.node.ListNode;
import com.github.franckyi.guapi.api.node.Node;
import com.github.franckyi.guapi.api.util.ScreenEventType;
import com.github.franckyi.guapi.base.theme.vanilla.delegate.VanillaWidgetSkinDelegate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractVanillaListNodeSkinDelegate<N extends ListNode<E>, E, T extends NodeEntry<N, E, T>>
extends AbstractSelectionList<T>
implements VanillaWidgetSkinDelegate {
    protected final N node;
    protected boolean shouldRefreshSize = true;
    protected boolean shouldRefreshList = true;
    protected boolean shouldScrollTo = false;
    protected boolean shouldChangeFocus = false;

    public AbstractVanillaListNodeSkinDelegate(N node) {
        super(Minecraft.getInstance(), 0, 0, 0, node.getItemHeight());
        this.node = node;
        Runnable rs = this::shouldRefreshSize;
        node.xProperty().addListener(rs);
        node.yProperty().addListener(rs);
        node.baseXProperty().addListener(rs);
        node.baseYProperty().addListener(rs);
        node.widthProperty().addListener(rs);
        node.heightProperty().addListener(rs);
        node.fullWidthProperty().addListener(rs);
        node.fullHeightProperty().addListener(rs);
        node.rootProperty().addListener(this::shouldRefreshList);
        node.scrollToProperty().addListener(this::shouldScrollTo);
        node.focusedElementProperty().addListener(this::shouldChangeFocus);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public N getNode() {
        return this.node;
    }

    public int getRowWidth() {
        return this.node.getWidth() - this.node.getPadding().getHorizontal() - 6;
    }

    protected int getScrollbarPosition() {
        return this.node.getRight() - 6;
    }

    public int getRowLeft() {
        return this.node.getLeft() + this.node.getPadding().getLeft();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.getEntryAtPosition(mouseX, mouseY) == null && (mouseX < (double)this.getScrollbarPosition() || mouseX > (double)this.node.getRight())) {
            this.setFocused(null);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void setFocused(@Nullable GuiEventListener listener) {
        super.setFocused(listener);
        if (listener == null) {
            this.node.setFocusedElement(null);
        } else {
            this.node.setFocusedElement(((NodeEntry)listener).item);
        }
    }

    @Override
    public boolean preRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        boolean res = false;
        if (this.shouldRefreshSize) {
            this.refreshSize();
            res = true;
        }
        if (this.shouldRefreshList) {
            this.refreshList();
            res = true;
        }
        if (this.shouldScrollTo) {
            this.scrollTo();
            res = true;
        }
        if (this.shouldChangeFocus) {
            this.changeFocus();
            res = true;
        }
        return res;
    }

    @Override
    public void postRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        for (NodeEntry entry : this.children()) {
            entry.getNode().postRender(guiGraphics, mouseX, mouseY, delta);
        }
    }

    protected void shouldRefreshSize() {
        this.shouldRefreshSize = true;
    }

    protected void shouldRefreshList() {
        this.shouldRefreshList = true;
    }

    protected void shouldScrollTo() {
        this.shouldScrollTo = true;
    }

    protected void shouldChangeFocus() {
        this.shouldChangeFocus = true;
    }

    protected void refreshSize() {
        this.width = this.node.getWidth();
        this.height = this.node.getHeight();
        this.setX(this.node.getX());
        this.setY(this.node.getY());
        this.shouldRefreshSize = false;
    }

    public int getRight() {
        return this.node.getRight();
    }

    public int getBottom() {
        return this.node.getBottom();
    }

    protected void refreshList() {
        this.clearEntries();
        this.createList();
        this.setScrollAmount(this.getScrollAmount());
        this.shouldRefreshList = false;
    }

    protected abstract void createList();

    protected void scrollTo() {
        for (NodeEntry e : this.children()) {
            if (e.getItem() != this.node.getScrollTo()) continue;
            this.centerScrollOn(e);
            break;
        }
        this.shouldScrollTo = false;
    }

    protected void changeFocus() {
        for (NodeEntry e : this.children()) {
            if (e.getItem() != this.node.getFocusedElement()) continue;
            super.setFocused((GuiEventListener)e);
            break;
        }
        this.shouldChangeFocus = false;
    }

    @Override
    public void doTick() {
        for (NodeEntry child : this.children()) {
            child.getNode().doTick();
        }
    }

    @Override
    public void mouseClicked(MouseButtonEvent event) {
        VanillaWidgetSkinDelegate.super.mouseClicked(event);
        this.handleMouseEvent(ScreenEventType.MOUSE_CLICKED, event);
    }

    @Override
    public void mouseReleased(MouseButtonEvent event) {
        VanillaWidgetSkinDelegate.super.mouseReleased(event);
        this.handleMouseEvent(ScreenEventType.MOUSE_RELEASED, event);
    }

    @Override
    public void mouseDragged(MouseDragEvent event) {
        VanillaWidgetSkinDelegate.super.mouseDragged(event);
        this.handleMouseEvent(ScreenEventType.MOUSE_DRAGGED, event);
    }

    @Override
    public void mouseScrolled(MouseScrollEvent event) {
        VanillaWidgetSkinDelegate.super.mouseScrolled(event);
        this.handleMouseEvent(ScreenEventType.MOUSE_SCOLLED, event);
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        VanillaWidgetSkinDelegate.super.mouseMoved(event);
        this.handleMouseEvent(ScreenEventType.MOUSE_MOVED, event);
    }

    protected <EE extends MouseEvent> void handleMouseEvent(ScreenEventType<EE> target, EE event) {
        for (NodeEntry child : this.children()) {
            child.getNode().handleEvent(target, event);
            if (event.getTarget() == null) continue;
            return;
        }
    }

    protected static abstract class NodeEntry<N extends ListNode<E>, E, T extends NodeEntry<N, E, T>>
    extends AbstractSelectionList.Entry<T> {
        private final AbstractVanillaListNodeSkinDelegate<N, E, T> list;
        private final E item;
        private Node node;

        public NodeEntry(AbstractVanillaListNodeSkinDelegate<N, E, T> list, E item) {
            this(list, item, null);
        }

        public NodeEntry(AbstractVanillaListNodeSkinDelegate<N, E, T> list, E item, Node node) {
            this.list = list;
            this.item = item;
            this.node = node;
        }

        public AbstractVanillaListNodeSkinDelegate<N, E, T> getList() {
            return this.list;
        }

        public E getItem() {
            return this.item;
        }

        public Node getNode() {
            return this.node;
        }

        public void setNode(Node node) {
            this.node = node;
        }

        protected void renderBackground(GuiGraphics guiGraphics, int x, int y, int entryWidth, int entryHeight) {
            if (this.getList().getFocused() == this) {
                RenderHelper.fillRectangle(guiGraphics, x - 2, y - 2, x + entryWidth + 3, y + entryHeight + 2, Color.fromRGBA(255, 255, 255, 79));
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            return this.list.node.isChildrenFocusable();
        }
    }
}

