/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.EnchantmentListSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.EntityListSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.ItemListSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.ListSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.SelectableItemListSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.SelectableTagListSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.SortedEnchantmentListSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.SpriteListSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.TagListSelectionElementModel;
import com.github.rinorsi.cadeditor.common.ColoredItemHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public final class ClientCache {
    private static List<String> itemSuggestions;
    private static List<ItemListSelectionElementModel> itemSelectionItems;
    private static List<String> blockSuggestions;
    private static List<ItemListSelectionElementModel> blockSelectionItems;
    private static List<TagListSelectionElementModel> blockTagSelectionItems;
    private static List<String> enchantmentSuggestions;
    private static List<EnchantmentListSelectionElementModel> enchantmentSelectionItems;
    private static List<String> attributeSuggestions;
    private static List<ListSelectionElementModel> attributeSelectionItems;
    private static List<String> potionSuggestions;
    private static List<ItemListSelectionElementModel> potionSelectionItems;
    private static List<String> effectSuggestions;
    private static List<SpriteListSelectionElementModel> effectSelectionItems;
    private static List<String> entitySuggestions;
    private static List<EntityListSelectionElementModel> entitySelectionItems;

    public static List<String> getItemSuggestions() {
        return itemSuggestions == null ? (itemSuggestions = ClientCache.buildSuggestions(BuiltInRegistries.ITEM)) : itemSuggestions;
    }

    public static List<ItemListSelectionElementModel> getItemSelectionItems() {
        return itemSelectionItems == null ? (itemSelectionItems = ClientCache.buildItemSelectionItems()) : itemSelectionItems;
    }

    public static List<String> getBlockSuggestions() {
        return blockSuggestions == null ? (blockSuggestions = ClientCache.buildSuggestions(BuiltInRegistries.BLOCK)) : blockSuggestions;
    }

    public static List<ItemListSelectionElementModel> getBlockSelectionItems() {
        return blockSelectionItems == null ? (blockSelectionItems = ClientCache.buildBlockSelectionItems()) : blockSelectionItems;
    }

    public static List<TagListSelectionElementModel> getBlockTagSelectionItems() {
        return blockTagSelectionItems == null ? (blockTagSelectionItems = ClientCache.buildBlockTagSelectionItems()) : blockTagSelectionItems;
    }

    public static List<String> getEnchantmentSuggestions() {
        if (enchantmentSuggestions == null) {
            enchantmentSuggestions = ClientCache.registryAccess().lookup(Registries.ENCHANTMENT).map(ClientCache::buildSuggestions).orElseGet(List::of);
        }
        return enchantmentSuggestions;
    }

    public static List<SortedEnchantmentListSelectionElementModel> getSortedEnchantmentSelectionItems(ItemStack target) {
        if (enchantmentSelectionItems == null) {
            enchantmentSelectionItems = ClientCache.buildEnchantmentSelectionItems();
        }
        return enchantmentSelectionItems.stream().map(item -> {
            boolean curse = item.getEnchantment().is(EnchantmentTags.CURSE);
            boolean canApply = ClientCache.enchantmentCanApply(item.getEnchantment(), target);
            return new SortedEnchantmentListSelectionElementModel((EnchantmentListSelectionElementModel)item, curse, canApply);
        }).sorted(Comparator.comparing(m -> m.canApply() ? 0 : 1).thenComparing(m -> m.isCurse() ? 1 : 0).thenComparing(m -> m.getName().toLowerCase(Locale.ROOT))).toList();
    }

    public static Optional<EnchantmentListSelectionElementModel> findEnchantmentSelectionItem(ResourceLocation id) {
        if (id == null) {
            return Optional.empty();
        }
        if (enchantmentSelectionItems == null) {
            enchantmentSelectionItems = ClientCache.buildEnchantmentSelectionItems();
        }
        return enchantmentSelectionItems.stream().filter(item -> item.getId().equals((Object)id)).findFirst();
    }

    private static boolean enchantmentCanApply(Holder<Enchantment> enchantment, ItemStack target) {
        if (target == null || target.isEmpty()) {
            return false;
        }
        if (target.is(Items.ENCHANTED_BOOK) || target.is(Items.BOOK)) {
            return true;
        }
        Enchantment value = (Enchantment)enchantment.value();
        if (value.canEnchant(target)) {
            return true;
        }
        Item item = target.getItem();
        Enchantment.EnchantmentDefinition definition = value.definition();
        Optional registry = ClientCache.registryAccess().lookup(Registries.ITEM);
        if (definition.primaryItems().map(set -> ClientCache.holderSetContainsItem((HolderSet<Item>)set, item, registry)).orElse(false).booleanValue()) {
            return true;
        }
        return ClientCache.holderSetContainsItem((HolderSet<Item>)definition.supportedItems(), item, registry);
    }

    private static boolean holderSetContainsItem(HolderSet<Item> holders, Item item, Optional<HolderLookup.RegistryLookup<Item>> registry) {
        if (holders == null) {
            return false;
        }
        try {
            if (holders.contains((Holder)item.builtInRegistryHolder())) {
                return true;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ResourceKey key = BuiltInRegistries.ITEM.getResourceKey((Object)item).orElse(null);
        if (key == null && registry.isPresent()) {
            key = registry.get().listElements().filter(reference -> {
                try {
                    return reference.value() == item;
                }
                catch (IllegalStateException ignored) {
                    return false;
                }
            }).map(Holder.Reference::key).findFirst().orElse(null);
        }
        for (Holder holder : holders) {
            if (key != null && holder.is(key)) {
                return true;
            }
            try {
                if (holder.value() != item) continue;
                return true;
            }
            catch (IllegalStateException illegalStateException) {
            }
        }
        return false;
    }

    public static List<String> getAttributeSuggestions() {
        return attributeSuggestions == null ? (attributeSuggestions = ClientCache.buildSuggestions(BuiltInRegistries.ATTRIBUTE)) : attributeSuggestions;
    }

    public static List<ListSelectionElementModel> getAttributeSelectionItems() {
        return attributeSelectionItems == null ? (attributeSelectionItems = ClientCache.buildAttributeSelectionItems()) : attributeSelectionItems;
    }

    public static Optional<ListSelectionElementModel> findAttributeSelectionItem(ResourceLocation id) {
        if (id == null) {
            return Optional.empty();
        }
        if (attributeSelectionItems == null) {
            attributeSelectionItems = ClientCache.buildAttributeSelectionItems();
        }
        return attributeSelectionItems.stream().filter(item -> item.getId().equals((Object)id)).findFirst();
    }

    public static List<String> getPotionSuggestions() {
        return potionSuggestions == null ? (potionSuggestions = ClientCache.buildSuggestions(BuiltInRegistries.POTION)) : potionSuggestions;
    }

    public static List<ItemListSelectionElementModel> getPotionSelectionItems() {
        return potionSelectionItems == null ? (potionSelectionItems = ClientCache.buildPotionSelectionItems()) : potionSelectionItems;
    }

    public static List<String> getEffectSuggestions() {
        return effectSuggestions == null ? (effectSuggestions = ClientCache.buildSuggestions(BuiltInRegistries.MOB_EFFECT)) : effectSuggestions;
    }

    public static List<SpriteListSelectionElementModel> getEffectSelectionItems() {
        return effectSelectionItems == null ? (effectSelectionItems = ClientCache.buildEffectSelectionItems()) : effectSelectionItems;
    }

    public static List<String> getEntitySuggestions() {
        return entitySuggestions == null ? (entitySuggestions = ClientCache.buildSuggestions(BuiltInRegistries.ENTITY_TYPE)) : entitySuggestions;
    }

    public static List<EntityListSelectionElementModel> getEntitySelectionItems() {
        return entitySelectionItems == null ? (entitySelectionItems = ClientCache.buildEntitySelectionItems()) : entitySelectionItems;
    }

    public static Optional<SpriteListSelectionElementModel> findEffectSelectionItem(ResourceLocation id) {
        if (id == null) {
            return Optional.empty();
        }
        if (effectSelectionItems == null) {
            effectSelectionItems = ClientCache.buildEffectSelectionItems();
        }
        return effectSelectionItems.stream().filter(item -> item.getId().equals((Object)id)).findFirst();
    }

    private static List<String> buildSuggestions(Registry<?> registry) {
        ArrayList<String> suggestions = new ArrayList<String>();
        registry.entrySet().stream().map(e -> ((ResourceKey)e.getKey()).location().toString()).forEach(id -> {
            suggestions.add((String)id);
            if (id.startsWith("minecraft:")) {
                suggestions.add(id.substring(10));
            }
        });
        return suggestions;
    }

    private static List<String> buildSuggestions(HolderLookup.RegistryLookup<?> lookup) {
        ArrayList<String> suggestions = new ArrayList<String>();
        lookup.listElements().forEach(holder -> {
            String id = holder.key().location().toString();
            suggestions.add(id);
            if (id.startsWith("minecraft:")) {
                suggestions.add(id.substring(10));
            }
        });
        return suggestions;
    }

    private static List<ItemListSelectionElementModel> buildItemSelectionItems() {
        return BuiltInRegistries.ITEM.entrySet().stream().map(e -> new ItemListSelectionElementModel(((Item)e.getValue()).getDescriptionId(), ((ResourceKey)e.getKey()).location(), new ItemStack((ItemLike)e.getValue()))).sorted().toList();
    }

    private static List<TagListSelectionElementModel> buildBlockTagSelectionItems() {
        return ClientCache.registryAccess().lookup(Registries.BLOCK).map(lookup -> lookup.listTags().map(named -> new SelectableTagListSelectionElementModel(named.key().location())).sorted().toList()).orElseGet(List::of);
    }

    private static List<ItemListSelectionElementModel> buildBlockSelectionItems() {
        return BuiltInRegistries.BLOCK.entrySet().stream().map(e -> new SelectableItemListSelectionElementModel(((Block)e.getValue()).getDescriptionId(), ((ResourceKey)e.getKey()).location(), new ItemStack((ItemLike)e.getValue()))).sorted().toList();
    }

    private static List<EntityListSelectionElementModel> buildEntitySelectionItems() {
        return BuiltInRegistries.ENTITY_TYPE.entrySet().stream().map(e -> new EntityListSelectionElementModel((EntityType)e.getValue(), ((ResourceKey)e.getKey()).location())).sorted().toList();
    }

    private static List<EnchantmentListSelectionElementModel> buildEnchantmentSelectionItems() {
        return ClientCache.registryAccess().lookup(Registries.ENCHANTMENT).map(lookup -> lookup.listElements().map(ref -> {
            ItemStack icon = new ItemStack((ItemLike)ClientCache.getEnchantmentTypeItem((Holder<Enchantment>)ref));
            Component categoryLabel = ClientCache.buildEnchantmentCategoryLabel((Holder<Enchantment>)ref, icon);
            return new EnchantmentListSelectionElementModel(((Enchantment)ref.value()).description().getString(), ref.key().location(), (Holder<Enchantment>)ref, icon, categoryLabel);
        }).sorted().toList()).orElseGet(List::of);
    }

    private static Component buildEnchantmentCategoryLabel(Holder<Enchantment> enchantment, ItemStack icon) {
        List<Component> labels = ((Enchantment)enchantment.value()).definition().primaryItems().map(ClientCache::describeItemSet).orElseGet(List::of);
        if (labels.isEmpty()) {
            labels = ClientCache.describeItemSet((HolderSet<Item>)((Enchantment)enchantment.value()).definition().supportedItems());
        }
        if (!labels.isEmpty()) {
            return ClientCache.joinComponents(labels);
        }
        List<Component> slotLabels = ClientCache.describeSlotGroups(((Enchantment)enchantment.value()).definition().slots());
        if (!slotLabels.isEmpty()) {
            return ClientCache.joinComponents(slotLabels);
        }
        return icon.getHoverName().copy();
    }

    private static Item getEnchantmentTypeItem(Holder<Enchantment> enchantment) {
        return ((Enchantment)enchantment.value()).definition().primaryItems().flatMap(ClientCache::pickRepresentativeItem).or(() -> ClientCache.pickRepresentativeItem((HolderSet<Item>)((Enchantment)enchantment.value()).definition().supportedItems())).or(() -> ClientCache.pickItemFromSlots(((Enchantment)enchantment.value()).definition().slots())).orElse(Items.ENCHANTED_BOOK);
    }

    private static List<Component> describeItemSet(HolderSet<Item> holders) {
        ArrayList<Component> result = new ArrayList<Component>();
        LinkedHashSet seen = new LinkedHashSet();
        holders.stream().map(Holder::value).filter(item -> item != Items.AIR).forEach(item -> {
            if (seen.add(item.getDescriptionId())) {
                result.add((Component)new ItemStack((ItemLike)item).getHoverName().copy());
            }
        });
        return ClientCache.limitComponentList(result);
    }

    private static List<Component> describeSlotGroups(List<EquipmentSlotGroup> slots) {
        LinkedHashSet<String> seen = new LinkedHashSet<String>();
        ArrayList<Component> result = new ArrayList<Component>();
        for (EquipmentSlotGroup slot : slots) {
            String raw = slot.name().toLowerCase(Locale.ROOT).replace('_', ' ');
            if (!seen.add(raw)) continue;
            result.add((Component)Component.literal((String)ClientCache.capitalizeWords(raw)));
        }
        return ClientCache.limitComponentList(result);
    }

    private static List<Component> limitComponentList(List<Component> components) {
        int max = 3;
        if (components.size() <= max) {
            return components;
        }
        ArrayList<Component> limited = new ArrayList<Component>(components.subList(0, max));
        limited.add((Component)Component.literal((String)"\u2026"));
        return limited;
    }

    private static Component joinComponents(List<Component> components) {
        MutableComponent result = Component.empty();
        for (int i = 0; i < components.size(); ++i) {
            if (i > 0) {
                result.append((Component)Component.literal((String)", "));
            }
            result.append((Component)components.get(i).copy());
        }
        return result;
    }

    private static String capitalizeWords(String input) {
        if (input.isEmpty()) {
            return input;
        }
        StringBuilder builder = new StringBuilder(input.length());
        boolean capitalizeNext = true;
        for (char c : input.toCharArray()) {
            if (c == ' ') {
                capitalizeNext = true;
                builder.append(c);
                continue;
            }
            if (capitalizeNext) {
                builder.append(Character.toTitleCase(c));
                capitalizeNext = false;
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private static Optional<Item> pickRepresentativeItem(HolderSet<Item> holders) {
        return holders.stream().map(Holder::value).filter(item -> item != Items.AIR).min(Comparator.comparing(item -> BuiltInRegistries.ITEM.getKey(item).toString()));
    }

    private static Optional<Item> pickItemFromSlots(List<EquipmentSlotGroup> slots) {
        if (slots.contains(EquipmentSlotGroup.ARMOR) || slots.contains(EquipmentSlotGroup.BODY)) {
            return Optional.of(Items.IRON_CHESTPLATE);
        }
        if (slots.contains(EquipmentSlotGroup.HEAD)) {
            return Optional.of(Items.DIAMOND_HELMET);
        }
        if (slots.contains(EquipmentSlotGroup.CHEST)) {
            return Optional.of(Items.DIAMOND_CHESTPLATE);
        }
        if (slots.contains(EquipmentSlotGroup.LEGS)) {
            return Optional.of(Items.DIAMOND_LEGGINGS);
        }
        if (slots.contains(EquipmentSlotGroup.FEET)) {
            return Optional.of(Items.DIAMOND_BOOTS);
        }
        if (slots.contains(EquipmentSlotGroup.MAINHAND) || slots.contains(EquipmentSlotGroup.HAND)) {
            return Optional.of(Items.DIAMOND_SWORD);
        }
        if (slots.contains(EquipmentSlotGroup.OFFHAND)) {
            return Optional.of(Items.SHIELD);
        }
        return Optional.empty();
    }

    private static List<ListSelectionElementModel> buildAttributeSelectionItems() {
        return BuiltInRegistries.ATTRIBUTE.entrySet().stream().map(e -> new ListSelectionElementModel(((Attribute)e.getValue()).getDescriptionId(), ((ResourceKey)e.getKey()).location())).sorted().toList();
    }

    private static List<ItemListSelectionElementModel> buildPotionSelectionItems() {
        return BuiltInRegistries.POTION.entrySet().stream().map(e -> BuiltInRegistries.POTION.getHolder((ResourceKey)e.getKey()).map(holder -> new ItemListSelectionElementModel(Potion.getName(Optional.of(holder), (String)(Items.POTION.getDescriptionId() + ".effect.")), ((ResourceKey)e.getKey()).location(), ColoredItemHelper.createColoredPotionItem(((ResourceKey)e.getKey()).location(), Integer.MIN_VALUE))).orElse(null)).filter(Objects::nonNull).sorted().toList();
    }

    private static List<SpriteListSelectionElementModel> buildEffectSelectionItems() {
        return BuiltInRegistries.MOB_EFFECT.entrySet().stream().map(e -> BuiltInRegistries.MOB_EFFECT.getHolder((ResourceKey)e.getKey()).map(holder -> new SpriteListSelectionElementModel(((MobEffect)holder.value()).getDescriptionId(), ((ResourceKey)e.getKey()).location(), () -> Minecraft.getInstance().getMobEffectTextures().get((Holder)holder))).orElse(null)).filter(Objects::nonNull).sorted().toList();
    }

    private static HolderLookup.Provider registryAccess() {
        return ClientUtil.registryAccess();
    }
}

