/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.KeyBindings;
import com.github.rinorsi.cadeditor.client.ModScreenHandler;
import com.github.rinorsi.cadeditor.client.logic.ClientEditorRequestLogic;
import com.github.rinorsi.cadeditor.client.logic.ClientVaultActionLogic;
import com.github.rinorsi.cadeditor.common.EditorType;
import com.github.rinorsi.cadeditor.common.ModTexts;
import com.github.rinorsi.cadeditor.mixin.CreativeModeInventoryScreenMixin;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ClientEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void onKeyInput() {
        try {
            if (KeyBindings.getEditorKey().consumeClick()) {
                ClientEditorRequestLogic.requestWorldEditor(EditorType.STANDARD);
            } else if (KeyBindings.getNBTEditorKey().consumeClick()) {
                ClientEditorRequestLogic.requestWorldEditor(EditorType.NBT);
            } else if (KeyBindings.getSNBTEditorKey().consumeClick()) {
                ClientEditorRequestLogic.requestWorldEditor(EditorType.SNBT);
            } else if (KeyBindings.getVaultKey().consumeClick()) {
                ModScreenHandler.openVault();
            }
        }
        catch (Exception e) {
            ClientUtil.showMessage((Component)ModTexts.Messages.ERROR_GENERIC);
            LOGGER.error("\u5904\u7406\u6e38\u620f\u5185\u6309\u952e\u65f6\u51fa\u9519\uff08CAD Editor\uff09", (Throwable)e);
        }
    }

    public static boolean onScreenEvent(AbstractContainerScreen<?> screen, int keyCode, int scanCode) {
        try {
            if (KeyBindings.getEditorKey().matches(keyCode, scanCode)) {
                return ClientEditorRequestLogic.requestInventoryItemEditor(EditorType.STANDARD, screen);
            }
            if (KeyBindings.getNBTEditorKey().matches(keyCode, scanCode)) {
                return ClientEditorRequestLogic.requestInventoryItemEditor(EditorType.NBT, screen);
            }
            if (KeyBindings.getSNBTEditorKey().matches(keyCode, scanCode)) {
                return ClientEditorRequestLogic.requestInventoryItemEditor(EditorType.SNBT, screen);
            }
            if (KeyBindings.getVaultKey().matches(keyCode, scanCode)) {
                CreativeModeInventoryScreen creativeScreen;
                CreativeModeTab.Type type;
                if (screen instanceof CreativeModeInventoryScreen && (type = ((CreativeModeInventoryScreenMixin)(creativeScreen = (CreativeModeInventoryScreen)screen)).getSelectedTab().getType()) == CreativeModeTab.Type.SEARCH) {
                    return false;
                }
                if (!ClientVaultActionLogic.openVaultSelection(screen)) {
                    ModScreenHandler.openVault();
                }
                return true;
            }
        }
        catch (Exception e) {
            ClientUtil.showMessage((Component)ModTexts.Messages.ERROR_GENERIC);
            LOGGER.error("\u5904\u7406\u754c\u9762\u6309\u952e\u65f6\u51fa\u9519\uff08CAD Editor\uff09", (Throwable)e);
        }
        return false;
    }
}

