/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client;

import com.github.rinorsi.cadeditor.PlatformUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.FriendlyByteBuf;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Vault {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int CURRENT_VERSION = 0;
    private static final Path VAULT_FILE_OLD = PlatformUtil.getConfigDir().resolve("ibeeditor-clipboard.dat");
    private static final Path VAULT_FILE_LEGACY = PlatformUtil.getConfigDir().resolve("ibeeditor-vault.dat");
    private static final Path VAULT_FILE = PlatformUtil.getConfigDir().resolve("cadeditor-vault.dat");
    private static final FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
    private static Vault INSTANCE;
    private int version = 0;
    private List<CompoundTag> items = new ArrayList<CompoundTag>();
    private List<CompoundTag> entities = new ArrayList<CompoundTag>();

    private Vault() {
    }

    public List<CompoundTag> getItems() {
        return this.items;
    }

    public List<CompoundTag> getEntities() {
        return this.entities;
    }

    public boolean saveItem(CompoundTag tag) {
        if (this.items.contains(tag)) {
            return false;
        }
        this.items.add(tag);
        Vault.save();
        return true;
    }

    public boolean saveEntity(CompoundTag tag) {
        if (this.entities.contains(tag)) {
            return false;
        }
        this.entities.add(tag);
        Vault.save();
        return true;
    }

    public void clear() {
        this.items.clear();
        this.entities.clear();
    }

    public static void load() {
        if (Files.exists(VAULT_FILE, new LinkOption[0])) {
            Vault.loadFromFile(VAULT_FILE);
        } else if (Files.exists(VAULT_FILE_LEGACY, new LinkOption[0])) {
            LOGGER.info("\u68c0\u6d4b\u5230\u65e7\u4fdd\u9669\u5e93\u6587\u4ef6\uff0c\u6b63\u5728\u8fc1\u79fb");
            Vault.loadFromFile(VAULT_FILE_LEGACY);
            Vault.save();
            try {
                Files.deleteIfExists(VAULT_FILE_LEGACY);
            }
            catch (IOException e) {
                LOGGER.error("\u5220\u9664\u65e7\u4fdd\u9669\u5e93\u6587\u4ef6\u65f6\u51fa\u9519", (Throwable)e);
            }
        } else if (Files.exists(VAULT_FILE_OLD, new LinkOption[0])) {
            LOGGER.info("\u68c0\u6d4b\u5230\u65e7\u526a\u8d34\u677f\u6587\u4ef6\uff0c\u6b63\u5728\u8f6c\u6362\u4e3a\u4fdd\u9669\u5e93\u6587\u4ef6");
            Vault.loadFromFile(VAULT_FILE_OLD);
            try {
                Files.delete(VAULT_FILE_OLD);
            }
            catch (IOException e) {
                LOGGER.error("\u5220\u9664\u65e7\u526a\u8d34\u677f\u6587\u4ef6\u65f6\u51fa\u9519", (Throwable)e);
            }
            Vault.INSTANCE.version = 0;
            Vault.save();
        } else {
            LOGGER.info("\u751f\u6210\u7a7a\u4fdd\u9669\u5e93");
            INSTANCE = new Vault();
            Vault.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadFromFile(Path path) {
        INSTANCE = new Vault();
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            buffer.clear();
            Vault.readIntoBuffer(is);
            buffer.readerIndex(0);
            Vault.INSTANCE.version = Vault.readVersion();
            int itemCount = Vault.readSize("items");
            IntStream.range(0, itemCount).forEach(i -> Vault.INSTANCE.items.add(Vault.safeReadNbt()));
            int entityCount = Vault.readSize("entities");
            IntStream.range(0, entityCount).forEach(i -> Vault.INSTANCE.entities.add(Vault.safeReadNbt()));
            LOGGER.info("\u4fdd\u9669\u5e93\u5df2\u52a0\u8f7d");
        }
        catch (VaultFileFormatException e) {
            LOGGER.warn("\u4fdd\u9669\u5e93\u6587\u4ef6\u683c\u5f0f\u65e0\u6548\uff1a{}", (Object)e.getMessage());
        }
        catch (IOException e) {
            LOGGER.error("\u52a0\u8f7d\u4fdd\u9669\u5e93\u65f6\u51fa\u9519", (Throwable)e);
        }
        finally {
            buffer.clear();
        }
    }

    private static void readIntoBuffer(InputStream is) throws IOException {
        int read;
        byte[] chunk = new byte[8192];
        while ((read = is.read(chunk)) != -1) {
            buffer.writeBytes(chunk, 0, read);
        }
    }

    private static int readVersion() throws VaultFileFormatException {
        if (buffer.readableBytes() < 4) {
            throw new VaultFileFormatException("\u7f3a\u5c11\u7248\u672c\u5934");
        }
        int version = buffer.readInt();
        if (version < 0 || version > 0) {
            throw new VaultFileFormatException("\u4e0d\u652f\u6301\u7684\u7248\u672c\uff1a" + version);
        }
        return version;
    }

    private static int readSize(String label) throws VaultFileFormatException {
        if (buffer.readableBytes() < 4) {
            throw new VaultFileFormatException(label + " \u6570\u91cf\u7f3a\u5931");
        }
        int size = buffer.readInt();
        if (size < 0) {
            throw new VaultFileFormatException(label + " \u6570\u91cf\u4e3a\u8d1f\u6570\uff1a" + size);
        }
        return size;
    }

    private static CompoundTag safeReadNbt() {
        int i = buffer.readerIndex();
        try {
            CompoundTag result = buffer.readNbt();
            if (result == null || result.isEmpty()) {
                throw new RuntimeException("Tag is empty, this must be an error");
            }
            return result;
        }
        catch (Exception e) {
            buffer.readerIndex(i);
            byte b0 = buffer.readByte();
            if (b0 != 10) {
                throw e;
            }
            buffer.readerIndex(i);
            try {
                return NbtIo.read((DataInput)new ByteBufInputStream((ByteBuf)buffer));
            }
            catch (IOException e0) {
                throw new RuntimeException(e0);
            }
        }
    }

    public static void save() {
        try (OutputStream os = Files.newOutputStream(VAULT_FILE, new OpenOption[0]);){
            buffer.clear();
            buffer.writeInt(Vault.INSTANCE.version);
            buffer.writeInt(Vault.INSTANCE.items.size());
            Vault.INSTANCE.items.forEach(arg_0 -> ((FriendlyByteBuf)buffer).writeNbt(arg_0));
            buffer.writeInt(Vault.INSTANCE.entities.size());
            Vault.INSTANCE.entities.forEach(arg_0 -> ((FriendlyByteBuf)buffer).writeNbt(arg_0));
            buffer.readerIndex(0);
            buffer.readBytes(os, buffer.readableBytes());
            LOGGER.info("\u4fdd\u9669\u5e93\u5df2\u4fdd\u5b58");
        }
        catch (IOException e) {
            LOGGER.error("\u4fdd\u5b58\u4fdd\u9669\u5e93\u65f6\u51fa\u9519", (Throwable)e);
        }
        finally {
            buffer.clear();
        }
    }

    public static Vault getInstance() {
        return INSTANCE;
    }

    private static final class VaultFileFormatException
    extends IOException {
        private VaultFileFormatException(String message) {
            super(message);
        }
    }
}

