/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.context;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public abstract class EditorContext<T extends EditorContext<T>> {
    private CompoundTag tag;
    protected Component errorTooltip;
    protected boolean canSaveToVault;
    private boolean isSaveToVault = false;
    private boolean isCopyCommand = false;
    private final Consumer<T> action;

    public EditorContext(CompoundTag tag, Component errorTooltip, boolean canSaveToVault, Consumer<T> action) {
        this.tag = tag;
        this.errorTooltip = errorTooltip;
        this.canSaveToVault = canSaveToVault;
        this.action = action;
    }

    public CompoundTag getTag() {
        return this.tag;
    }

    public void setTag(CompoundTag tag) {
        this.tag = tag;
    }

    public Component getErrorTooltip() {
        return this.errorTooltip;
    }

    public boolean hasPermission() {
        return this.errorTooltip == null;
    }

    public void update() {
        if (this.isSaveToVault() && this.canSaveToVault()) {
            this.saveToVault();
        }
        if (this.isCopyCommand()) {
            Minecraft.getInstance().keyboardHandler.setClipboard(this.getCommand());
            ClientUtil.showMessage((Component)this.getCopySuccessMessage());
        }
        if (this.hasPermission() && this.action != null) {
            this.action.accept(this);
        }
    }

    public boolean canSaveToVault() {
        return this.canSaveToVault;
    }

    public boolean isSaveToVault() {
        return this.isSaveToVault;
    }

    public void setSaveToVault(boolean isSaveToVault) {
        this.isSaveToVault = isSaveToVault;
    }

    public boolean isCopyCommand() {
        return this.isCopyCommand;
    }

    public void setCopyCommand(boolean copyCommand) {
        this.isCopyCommand = copyCommand;
    }

    public void saveToVault() {
    }

    public abstract MutableComponent getTargetName();

    public MutableComponent getCommandTooltip() {
        return ModTexts.copyCommand(this.getCommandName());
    }

    public abstract String getCommandName();

    protected abstract String getCommand();

    protected MutableComponent getCopySuccessMessage() {
        return ModTexts.Messages.successCopyClipboard(this.getCommandName());
    }
}

