/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.logic;

import com.github.rinorsi.cadeditor.client.ClientContext;
import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.ModScreenHandler;
import com.github.rinorsi.cadeditor.client.context.BlockEditorContext;
import com.github.rinorsi.cadeditor.client.context.EntityEditorContext;
import com.github.rinorsi.cadeditor.client.context.ItemEditorContext;
import com.github.rinorsi.cadeditor.common.EditorType;
import com.github.rinorsi.cadeditor.common.ModTexts;
import com.github.rinorsi.cadeditor.common.network.BlockEditorPacket;
import com.github.rinorsi.cadeditor.common.network.BlockInventoryItemEditorPacket;
import com.github.rinorsi.cadeditor.common.network.EntityEditorPacket;
import com.github.rinorsi.cadeditor.common.network.EntityInventoryItemEditorPacket;
import com.github.rinorsi.cadeditor.common.network.MainHandItemEditorPacket;
import com.github.rinorsi.cadeditor.common.network.NetworkManager;
import com.github.rinorsi.cadeditor.common.network.PlayerInventoryItemEditorPacket;
import com.github.rinorsi.cadeditor.mixin.AbstractContainerScreenMixin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundSetCreativeModeSlotPacket;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public final class ClientEditorRequestLogic {
    public static void requestWorldEditor(EditorType editorType) {
        if (!(ClientEditorRequestLogic.requestEntityEditor(editorType) || ClientEditorRequestLogic.requestBlockEditor(editorType) || ClientEditorRequestLogic.requestMainHandItemEditor(editorType))) {
            ClientEditorRequestLogic.requestSelfEditor(editorType);
        }
    }

    public static boolean requestEntityEditor(EditorType editorType) {
        HitResult hitResult = Minecraft.getInstance().hitResult;
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult res = (EntityHitResult)hitResult;
            Entity entity = res.getEntity();
            if (ClientContext.isModInstalledOnServer()) {
                NetworkManager.sendToServer(NetworkManager.ENTITY_EDITOR_REQUEST, new EntityEditorPacket.Request(editorType, entity.getId()));
            } else {
                CompoundTag tag = new CompoundTag();
                entity.save(tag);
                ModScreenHandler.openEditor(editorType, new EntityEditorContext(tag, (Component)ModTexts.errorServerModRequired(ModTexts.ENTITY), true, null));
            }
            return true;
        }
        return false;
    }

    public static boolean requestBlockEditor(EditorType editorType) {
        BlockHitResult res;
        HitResult hitResult = Minecraft.getInstance().hitResult;
        if (hitResult instanceof BlockHitResult && (res = (BlockHitResult)hitResult).getType() != HitResult.Type.MISS) {
            BlockPos blockPos = res.getBlockPos();
            if (ClientContext.isModInstalledOnServer()) {
                NetworkManager.sendToServer(NetworkManager.BLOCK_EDITOR_REQUEST, new BlockEditorPacket.Request(editorType, blockPos));
            } else {
                ClientLevel level = Minecraft.getInstance().level;
                BlockState blockState = level.getBlockState(blockPos);
                BlockEntity blockEntity = level.getBlockEntity(blockPos);
                CompoundTag tag = null;
                if (blockEntity != null) {
                    tag = blockEntity.saveWithId(ClientUtil.registryAccess());
                }
                ModScreenHandler.openEditor(editorType, new BlockEditorContext(blockState, tag, (Component)ModTexts.errorServerModRequired(ModTexts.BLOCK), null));
            }
            return true;
        }
        return false;
    }

    public static boolean requestMainHandItemEditor(EditorType editorType) {
        ItemStack item = Minecraft.getInstance().player.getMainHandItem();
        if (item.isEmpty()) {
            return false;
        }
        if (ClientContext.isModInstalledOnServer()) {
            NetworkManager.sendToServer(NetworkManager.MAIN_HAND_ITEM_EDITOR_REQUEST, new MainHandItemEditorPacket.Request(editorType));
        } else if (Minecraft.getInstance().player.isCreative()) {
            ModScreenHandler.openEditor(editorType, new ItemEditorContext(item, null, true, context -> Minecraft.getInstance().player.connection.send((Packet)new ServerboundSetCreativeModeSlotPacket(Minecraft.getInstance().player.getInventory().selected + 36, context.getItemStack().copy()))));
        } else {
            ModScreenHandler.openEditor(editorType, new ItemEditorContext(item, (Component)ModTexts.errorServerModRequired(ModTexts.ITEM), true, null));
        }
        return true;
    }

    public static void requestSelfEditor(EditorType editorType) {
        LocalPlayer entity = Minecraft.getInstance().player;
        if (ClientContext.isModInstalledOnServer()) {
            NetworkManager.sendToServer(NetworkManager.ENTITY_EDITOR_REQUEST, new EntityEditorPacket.Request(editorType, entity.getId()));
        }
    }

    public static boolean requestInventoryItemEditor(EditorType editorType, AbstractContainerScreen<?> screen) {
        Slot slot = ((AbstractContainerScreenMixin)screen).getHoveredSlot();
        if (slot != null && slot.hasItem()) {
            EntityHitResult res;
            BlockHitResult res2;
            int slotIndex = slot.getContainerSlot();
            if (slot.container instanceof Inventory) {
                boolean creativeInventoryScreen = false;
                if (screen instanceof CreativeModeInventoryScreen) {
                    CreativeModeInventoryScreen c = (CreativeModeInventoryScreen)screen;
                    creativeInventoryScreen = true;
                    if (c.isInventoryOpen()) {
                        slotIndex = ClientUtil.convertCreativeInventorySlot(slotIndex);
                    }
                }
                if (ClientContext.isModInstalledOnServer()) {
                    NetworkManager.sendToServer(NetworkManager.PLAYER_INVENTORY_ITEM_EDITOR_REQUEST, new PlayerInventoryItemEditorPacket.Request(editorType, slotIndex, creativeInventoryScreen));
                } else if (Minecraft.getInstance().player.isCreative()) {
                    ModScreenHandler.openEditor(editorType, new ItemEditorContext(slot.getItem(), null, true, context -> slot.set(context.getItemStack().copy())));
                } else {
                    ModScreenHandler.openEditor(editorType, new ItemEditorContext(slot.getItem(), (Component)ModTexts.errorServerModRequired(ModTexts.ITEM), true, null));
                }
                return true;
            }
            HitResult hitResult = Minecraft.getInstance().hitResult;
            if (hitResult instanceof BlockHitResult && Minecraft.getInstance().level.getBlockEntity((res2 = (BlockHitResult)hitResult).getBlockPos()) instanceof Container) {
                if (ClientContext.isModInstalledOnServer()) {
                    NetworkManager.sendToServer(NetworkManager.BLOCK_INVENTORY_ITEM_EDITOR_REQUEST, new BlockInventoryItemEditorPacket.Request(editorType, slotIndex, res2.getBlockPos()));
                }
                return true;
            }
            hitResult = Minecraft.getInstance().hitResult;
            if (hitResult instanceof EntityHitResult && (res = (EntityHitResult)hitResult).getEntity() instanceof Container && ClientContext.isModInstalledOnServer()) {
                NetworkManager.sendToServer(NetworkManager.ENTITY_INVENTORY_ITEM_EDITOR_REQUEST, new EntityInventoryItemEditorPacket.Request(editorType, slotIndex, res.getEntity().getId()));
            }
        }
        return false;
    }
}

