/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.logic;

import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.ModScreenHandler;
import com.github.rinorsi.cadeditor.client.context.BlockEditorContext;
import com.github.rinorsi.cadeditor.client.context.EntityEditorContext;
import com.github.rinorsi.cadeditor.client.context.ItemEditorContext;
import com.github.rinorsi.cadeditor.client.logic.ClientEditorUpdateLogic;
import com.github.rinorsi.cadeditor.common.ModTexts;
import com.github.rinorsi.cadeditor.common.network.BlockEditorPacket;
import com.github.rinorsi.cadeditor.common.network.BlockInventoryItemEditorPacket;
import com.github.rinorsi.cadeditor.common.network.EntityEditorPacket;
import com.github.rinorsi.cadeditor.common.network.EntityInventoryItemEditorPacket;
import com.github.rinorsi.cadeditor.common.network.MainHandItemEditorPacket;
import com.github.rinorsi.cadeditor.common.network.PlayerInventoryItemEditorPacket;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public final class ClientEditorResponseLogic {
    public static void onMainHandItemEditorResponse(MainHandItemEditorPacket.Response response) {
        ModScreenHandler.openEditor(response.getEditorType(), new ItemEditorContext(response.getItemStack(), ClientEditorResponseLogic.getErrorTooltip(response.hasPermission(), ModTexts.ITEM), true, context -> ClientEditorUpdateLogic.updateMainHandItem(response, context)));
        ClientEditorResponseLogic.notifyPermission(response.hasPermission(), ModTexts.ITEM);
    }

    public static void onPlayerInventoryItemEditorResponse(PlayerInventoryItemEditorPacket.Response response) {
        ModScreenHandler.openEditor(response.getEditorType(), new ItemEditorContext(response.getItemStack(), ClientEditorResponseLogic.getErrorTooltip(response.hasPermission(), ModTexts.ITEM), true, context -> ClientEditorUpdateLogic.updatePlayerInventoryItem(response, context)));
        ClientEditorResponseLogic.notifyPermission(response.hasPermission(), ModTexts.ITEM);
    }

    public static void onBlockInventoryItemEditorResponse(BlockInventoryItemEditorPacket.Response response) {
        ModScreenHandler.openEditor(response.getEditorType(), new ItemEditorContext(response.getItemStack(), ClientEditorResponseLogic.getErrorTooltip(response.hasPermission(), ModTexts.ITEM), true, context -> ClientEditorUpdateLogic.updateBlockInventoryItem(response, context)));
        ClientEditorResponseLogic.notifyPermission(response.hasPermission(), ModTexts.ITEM);
    }

    public static void onEntityInventoryItemEditorResponse(EntityInventoryItemEditorPacket.Response response) {
        ModScreenHandler.openEditor(response.getEditorType(), new ItemEditorContext(response.getItemStack(), ClientEditorResponseLogic.getErrorTooltip(response.hasPermission(), ModTexts.ITEM), true, context -> ClientEditorUpdateLogic.updateEntityInventoryItem(response, context)));
        ClientEditorResponseLogic.notifyPermission(response.hasPermission(), ModTexts.ITEM);
    }

    public static void onBlockEditorResponse(BlockEditorPacket.Response response) {
        ModScreenHandler.openEditor(response.getEditorType(), new BlockEditorContext(response.getBlockState(), response.getTag(), ClientEditorResponseLogic.getErrorTooltip(response.hasPermission(), ModTexts.BLOCK), context -> ClientEditorUpdateLogic.updateBlock(response, context)));
        ClientEditorResponseLogic.notifyPermission(response.hasPermission(), ModTexts.BLOCK);
    }

    public static void onEntityEditorResponse(EntityEditorPacket.Response response) {
        ModScreenHandler.openEditor(response.getEditorType(), new EntityEditorContext(response.getTag(), ClientEditorResponseLogic.getErrorTooltip(response.hasPermission(), ModTexts.ENTITY), true, context -> ClientEditorUpdateLogic.updateEntity(response, context)));
        ClientEditorResponseLogic.notifyPermission(response.hasPermission(), ModTexts.ENTITY);
    }

    private static Component getErrorTooltip(boolean hasPermission, MutableComponent arg) {
        return hasPermission ? null : ModTexts.errorPermissionDenied(arg);
    }

    private static void notifyPermission(boolean hasPermission, MutableComponent target) {
        if (!hasPermission) {
            ClientUtil.showMessage((Component)ModTexts.Messages.errorPermissionDenied(target));
        }
    }
}

