/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.logic;

import com.github.rinorsi.cadeditor.client.ClientContext;
import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.ModScreenHandler;
import com.github.rinorsi.cadeditor.client.Vault;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.VaultItemListSelectionElementModel;
import com.github.rinorsi.cadeditor.common.ModTexts;
import com.github.rinorsi.cadeditor.common.network.GiveVaultItemPacket;
import com.github.rinorsi.cadeditor.common.network.NetworkManager;
import com.github.rinorsi.cadeditor.mixin.AbstractContainerScreenMixin;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundSetCreativeModeSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public final class ClientVaultActionLogic {
    public static void giveVaultItem(int slot, ItemStack itemStack) {
        NetworkManager.sendToServer(NetworkManager.GIVE_VAULT_ITEM, new GiveVaultItemPacket(slot, itemStack));
    }

    public static boolean openVaultSelection(AbstractContainerScreen<?> screen) {
        CreativeModeInventoryScreen creative;
        Slot hoveredSlot = ((AbstractContainerScreenMixin)screen).getHoveredSlot();
        if (hoveredSlot == null || !(hoveredSlot.container instanceof Inventory)) {
            return false;
        }
        ArrayList<VaultItemListSelectionElementModel> elements = new ArrayList<VaultItemListSelectionElementModel>();
        LinkedHashMap<String, ItemStack> stacksById = new LinkedHashMap<String, ItemStack>();
        List<CompoundTag> storedItems = Vault.getInstance().getItems();
        for (int i = 0; i < storedItems.size(); ++i) {
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)ClientUtil.registryAccess(), (CompoundTag)storedItems.get(i));
            if (stack.isEmpty()) continue;
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"cadeditor", (String)("vault_item_" + i));
            elements.add(new VaultItemListSelectionElementModel(id, stack));
            stacksById.put(id.toString(), stack.copy());
        }
        if (elements.isEmpty()) {
            return false;
        }
        int slotIndex = hoveredSlot.getContainerSlot();
        if (screen instanceof CreativeModeInventoryScreen && (creative = (CreativeModeInventoryScreen)screen).isInventoryOpen()) {
            slotIndex = ClientUtil.convertCreativeInventorySlot(slotIndex);
        }
        int targetSlot = slotIndex;
        Slot slotRef = hoveredSlot;
        ModScreenHandler.openListSelectionScreen(ModTexts.VAULT, "vault_item", elements, selectedId -> {
            ItemStack chosen = (ItemStack)stacksById.get(selectedId);
            if (chosen == null) {
                return;
            }
            ItemStack copy = chosen.copy();
            if (ClientContext.isModInstalledOnServer()) {
                ClientVaultActionLogic.giveVaultItem(targetSlot, copy);
            } else if (Minecraft.getInstance().player != null && Minecraft.getInstance().player.isCreative()) {
                int slotToUpdate = targetSlot + 36;
                Minecraft.getInstance().player.connection.send((Packet)new ServerboundSetCreativeModeSlotPacket(slotToUpdate, copy));
                slotRef.set(copy);
                slotRef.setChanged();
            } else {
                ClientUtil.showMessage((Component)ModTexts.Messages.errorServerModRequired(ModTexts.VAULT));
            }
        });
        return true;
    }
}

