/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.controller.entry.entity;

import com.github.rinorsi.cadeditor.client.ClientCache;
import com.github.rinorsi.cadeditor.client.ClientUtil;
import com.github.rinorsi.cadeditor.client.ModScreenHandler;
import com.github.rinorsi.cadeditor.client.Vault;
import com.github.rinorsi.cadeditor.client.context.ItemEditorContext;
import com.github.rinorsi.cadeditor.client.screen.controller.entry.EntryController;
import com.github.rinorsi.cadeditor.client.screen.model.entry.entity.EntityEquipmentEntryModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.VaultItemListSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.view.entry.entity.EntityEquipmentEntryView;
import com.github.rinorsi.cadeditor.common.EditorType;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class EntityEquipmentEntryController
extends EntryController<EntityEquipmentEntryModel, EntityEquipmentEntryView> {
    private boolean placeholder;

    public EntityEquipmentEntryController(EntityEquipmentEntryModel model, EntityEquipmentEntryView view) {
        super(model, view);
    }

    @Override
    public void bind() {
        super.bind();
        ((EntityEquipmentEntryView)this.view).setListButtonsVisible(false);
        ((EntityEquipmentEntryView)this.view).getDeleteButton().setVisible(false);
        ((EntityEquipmentEntryView)this.view).getUpButton().setVisible(false);
        ((EntityEquipmentEntryView)this.view).getDownButton().setVisible(false);
        ((EntityEquipmentEntryView)this.view).getChooseItemButton().onAction(() -> this.openItemSelection(null));
        ((EntityEquipmentEntryView)this.view).getLoadVaultButton().onAction(this::openVaultSelection);
        ((EntityEquipmentEntryView)this.view).getChooseItemButton().setDisable(false);
        ((EntityEquipmentEntryView)this.view).getSlotLabel().setLabel((Component)((EntityEquipmentEntryModel)this.model).getSlotLabel());
        ((EntityEquipmentEntryView)this.view).getItemView().itemProperty().bind(((EntityEquipmentEntryModel)this.model).itemStackProperty());
        ((EntityEquipmentEntryModel)this.model).itemStackProperty().addListener(stack -> this.updateItemName());
        this.updateItemName();
        ((EntityEquipmentEntryView)this.view).getDropChanceField().setValidator(((EntityEquipmentEntryModel)this.model)::isDropChanceTextValid);
        ((EntityEquipmentEntryView)this.view).getDropChanceField().setText(((EntityEquipmentEntryModel)this.model).formatDropChance());
        ((EntityEquipmentEntryView)this.view).getDropChanceField().textProperty().addListener(value -> {
            if (!((EntityEquipmentEntryView)this.view).getDropChanceField().isValid()) {
                ((EntityEquipmentEntryModel)this.model).setValid(false);
                return;
            }
            if (!Objects.equals(value, ((EntityEquipmentEntryModel)this.model).formatDropChance())) {
                ((EntityEquipmentEntryModel)this.model).setDropChanceFromText((String)value);
            }
        });
        ((EntityEquipmentEntryModel)this.model).dropChanceProperty().addListener(value -> {
            String formatted = ((EntityEquipmentEntryModel)this.model).formatDropChance();
            if (!Objects.equals(formatted, ((EntityEquipmentEntryView)this.view).getDropChanceField().getText())) {
                ((EntityEquipmentEntryView)this.view).getDropChanceField().setText(formatted);
            }
        });
        ((EntityEquipmentEntryView)this.view).getDropChanceField().validProperty().addListener(((EntityEquipmentEntryModel)this.model)::setValid);
        ((EntityEquipmentEntryView)this.view).getDropChanceField().onKeyPress(event -> {
            float next;
            if (event.isConsumed()) {
                return;
            }
            int key = event.getKeyCode();
            if (key != 265 && key != 264) {
                return;
            }
            String text = ((EntityEquipmentEntryView)this.view).getDropChanceField().getText();
            if (!((EntityEquipmentEntryModel)this.model).isDropChanceTextValid(text)) {
                return;
            }
            float current = Float.parseFloat(text);
            float step = 0.05f;
            if (event.isShiftKeyDown()) {
                step = 0.1f;
            } else if (event.isControlKeyDown()) {
                step = 0.01f;
            }
            if (key == 264) {
                step = -step;
            }
            if (Math.abs((next = Math.max(0.0f, Math.min(1.0f, current + step))) - current) < 1.0E-4f) {
                return;
            }
            ((EntityEquipmentEntryModel)this.model).setDropChance(next);
            event.consume();
        });
        ((EntityEquipmentEntryView)this.view).getOpenEditorButton().onAction(() -> this.openEditor(EditorType.STANDARD));
        ((EntityEquipmentEntryView)this.view).getOpenSnbtEditorButton().onAction(() -> this.openEditor(EditorType.SNBT));
        ((EntityEquipmentEntryView)this.view).getClearButton().onAction(() -> {
            this.placeholder = false;
            ((EntityEquipmentEntryModel)this.model).setItemStack(ItemStack.EMPTY);
        });
    }

    private void updateItemName() {
        ItemStack stack = ((EntityEquipmentEntryModel)this.model).getItemStack();
        MutableComponent name = stack.isEmpty() ? Component.literal((String)"-").withStyle(style -> style.withColor(0xA0A0A0)) : stack.getHoverName().copy();
        ((EntityEquipmentEntryView)this.view).getItemNameLabel().setLabel((Component)name);
        boolean empty = stack.isEmpty();
        ((EntityEquipmentEntryView)this.view).getOpenSnbtEditorButton().setDisable(empty);
    }

    private void openEditor(EditorType type) {
        if (((EntityEquipmentEntryModel)this.model).getItemStack().isEmpty()) {
            this.placeholder = true;
            ((EntityEquipmentEntryModel)this.model).setItemStack(new ItemStack((ItemLike)Items.STICK));
            this.openEditorNow(type);
            return;
        }
        this.placeholder = false;
        this.ensureItemStack(() -> this.openEditorNow(type));
    }

    private void openEditorNow(EditorType type) {
        ItemStack initial = ((EntityEquipmentEntryModel)this.model).getItemStack().copy();
        ItemEditorContext context = new ItemEditorContext(initial, null, false, ctx -> {
            ItemStack result = ctx.getItemStack().copy();
            ((EntityEquipmentEntryModel)this.model).setItemStack(result);
            if (this.placeholder) {
                if (result.is(Items.STICK)) {
                    ((EntityEquipmentEntryModel)this.model).setItemStack(ItemStack.EMPTY);
                }
                this.placeholder = false;
            }
            this.placeholder = false;
        });
        ModScreenHandler.openEditor(type, context);
    }

    private void ensureItemStack(Runnable onReady) {
        if (!((EntityEquipmentEntryModel)this.model).getItemStack().isEmpty()) {
            onReady.run();
            return;
        }
        this.openItemSelection(onReady);
    }

    private void openItemSelection(Runnable afterSelection) {
        ModScreenHandler.openListSelectionScreen(ModTexts.ITEM, "equipment", ClientCache.getItemSelectionItems(), selection -> {
            if (selection == null || selection.isEmpty()) {
                return;
            }
            try {
                ResourceLocation id = ResourceLocation.parse((String)selection);
                Item item = (Item)BuiltInRegistries.ITEM.get(id);
                if (item != null) {
                    ((EntityEquipmentEntryModel)this.model).setItemStack(new ItemStack((ItemLike)item));
                    this.placeholder = false;
                    if (afterSelection != null) {
                        afterSelection.run();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private void openVaultSelection() {
        ArrayList<VaultItemListSelectionElementModel> elements = new ArrayList<VaultItemListSelectionElementModel>();
        LinkedHashMap<String, ItemStack> stacksById = new LinkedHashMap<String, ItemStack>();
        List<CompoundTag> storedItems = Vault.getInstance().getItems();
        for (int i = 0; i < storedItems.size(); ++i) {
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)ClientUtil.registryAccess(), (CompoundTag)storedItems.get(i));
            if (stack.isEmpty()) continue;
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"cadeditor", (String)("equipment_vault_item_" + i));
            elements.add(new VaultItemListSelectionElementModel(id, stack));
            stacksById.put(id.toString(), stack.copy());
        }
        if (elements.isEmpty()) {
            return;
        }
        ModScreenHandler.openListSelectionScreen(ModTexts.VAULT, "vault_item_equipment", elements, selectedId -> {
            ItemStack chosen = (ItemStack)stacksById.get(selectedId);
            if (chosen == null) {
                return;
            }
            ((EntityEquipmentEntryModel)this.model).setItemStack(chosen.copy());
            this.placeholder = false;
        });
    }
}

