/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.controller.entry.item;

import com.github.franckyi.databindings.api.ObservableList;
import com.github.rinorsi.cadeditor.client.ClientCache;
import com.github.rinorsi.cadeditor.client.ModScreenHandler;
import com.github.rinorsi.cadeditor.client.context.ItemEditorContext;
import com.github.rinorsi.cadeditor.client.screen.controller.entry.EntryController;
import com.github.rinorsi.cadeditor.client.screen.model.entry.item.ItemContainerSlotEntryModel;
import com.github.rinorsi.cadeditor.client.screen.view.entry.item.ItemContainerSlotEntryView;
import com.github.rinorsi.cadeditor.common.EditorType;
import com.github.rinorsi.cadeditor.common.ModTexts;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemContainerSlotEntryController
extends EntryController<ItemContainerSlotEntryModel, ItemContainerSlotEntryView> {
    public ItemContainerSlotEntryController(ItemContainerSlotEntryModel model, ItemContainerSlotEntryView view) {
        super(model, view);
    }

    @Override
    public void bind() {
        super.bind();
        ((ItemContainerSlotEntryView)this.view).setListButtonsVisible(false);
        ((ItemContainerSlotEntryView)this.view).getDeleteButton().setVisible(false);
        ((ItemContainerSlotEntryView)this.view).getUpButton().setVisible(false);
        ((ItemContainerSlotEntryView)this.view).getDownButton().setVisible(false);
        ((ItemContainerSlotEntryView)this.view).getSlotLabel().setLabel(((ItemContainerSlotEntryModel)this.model).getSlotLabel());
        ((ItemContainerSlotEntryModel)this.model).listIndexProperty().addListener(value -> ((ItemContainerSlotEntryView)this.view).getSlotLabel().setLabel(((ItemContainerSlotEntryModel)this.model).getSlotLabel()));
        ((ItemContainerSlotEntryView)this.view).getItemView().itemProperty().bind(((ItemContainerSlotEntryModel)this.model).itemStackProperty());
        ((ItemContainerSlotEntryModel)this.model).itemStackProperty().addListener(stack -> this.updateItemName());
        this.updateItemName();
        ((ItemContainerSlotEntryView)this.view).getChooseItemButton().onAction(() -> this.openItemSelection(null));
        ((ItemContainerSlotEntryView)this.view).getOpenEditorButton().onAction(() -> this.openEditor(EditorType.STANDARD));
        ((ItemContainerSlotEntryView)this.view).getOpenSnbtEditorButton().onAction(() -> this.openEditor(EditorType.SNBT));
        ((ItemContainerSlotEntryView)this.view).getClearButton().onAction(() -> {
            ((ItemContainerSlotEntryModel)this.model).setItemStack(ItemStack.EMPTY);
            this.updateItemName();
        });
    }

    private void updateItemName() {
        MutableComponent name;
        ItemStack stack = ((ItemContainerSlotEntryModel)this.model).getItemStack();
        MutableComponent mutableComponent = name = stack.isEmpty() ? Component.literal((String)"-").withStyle(style -> style.withColor(0xA0A0A0)) : stack.getHoverName().copy();
        if (!stack.isEmpty() && stack.getCount() > 1) {
            name.append((Component)Component.literal((String)(" x" + stack.getCount())).withStyle(ChatFormatting.DARK_GRAY));
        }
        ((ItemContainerSlotEntryView)this.view).getItemNameLabel().setLabel((Component)name);
        this.updateItemTooltip(stack);
        ((ItemContainerSlotEntryView)this.view).getOpenSnbtEditorButton().setDisable(stack.isEmpty());
    }

    private void updateItemTooltip(ItemStack stack) {
        ObservableList<Component> tooltip = ((ItemContainerSlotEntryView)this.view).getItemNameLabel().getTooltip();
        tooltip.clear();
        if (stack.isEmpty()) {
            tooltip.add((Component)ModTexts.choose(ModTexts.ITEM).copy().withStyle(ChatFormatting.GRAY));
            return;
        }
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        tooltip.add((Component)Component.literal((String)id.toString()).withStyle(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)ModTexts.COUNT.copy().withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)": ").withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)String.valueOf(stack.getCount())).withStyle(ChatFormatting.GOLD)));
        tooltip.add((Component)ModTexts.OPEN_SNBT_EDITOR.copy().withStyle(ChatFormatting.GRAY));
    }

    private void openItemSelection(Runnable afterSelection) {
        ModScreenHandler.openListSelectionScreen(ModTexts.ITEM, "container_slot", ClientCache.getItemSelectionItems(), selection -> {
            if (selection == null || selection.isEmpty()) {
                return;
            }
            try {
                ResourceLocation id = ResourceLocation.parse((String)selection);
                Item item = (Item)BuiltInRegistries.ITEM.get(id);
                if (item != null) {
                    ((ItemContainerSlotEntryModel)this.model).setItemStack(new ItemStack((ItemLike)item));
                    this.updateItemName();
                    if (afterSelection != null) {
                        afterSelection.run();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private void openEditor(EditorType type) {
        this.ensureItemStack(() -> this.openEditorNow(type));
    }

    private void openEditorNow(EditorType type) {
        ItemStack initial = ((ItemContainerSlotEntryModel)this.model).getItemStack().copy();
        ItemEditorContext context = new ItemEditorContext(initial, null, false, ctx -> {
            ItemStack result = ctx.getItemStack().copy();
            ((ItemContainerSlotEntryModel)this.model).setItemStack(result);
            this.updateItemName();
        });
        ModScreenHandler.openEditor(type, context);
    }

    private void ensureItemStack(Runnable onReady) {
        if (!((ItemContainerSlotEntryModel)this.model).getItemStack().isEmpty()) {
            onReady.run();
            return;
        }
        this.openItemSelection(onReady);
    }
}

