/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.controller.selection;

import com.github.franckyi.guapi.api.Guapi;
import com.github.franckyi.guapi.api.mvc.AbstractController;
import com.github.rinorsi.cadeditor.client.ClientConfiguration;
import com.github.rinorsi.cadeditor.client.screen.model.selection.ListSelectionScreenModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.ListSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.SelectableListSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.view.selection.ListSelectionScreenView;
import com.github.rinorsi.cadeditor.common.ModTexts;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ListSelectionScreenController
extends AbstractController<ListSelectionScreenModel, ListSelectionScreenView> {
    public ListSelectionScreenController(ListSelectionScreenModel model, ListSelectionScreenView view) {
        super(model, view);
    }

    @Override
    public void bind() {
        ((ListSelectionScreenView)this.view).getHeaderLabel().setLabel((Component)ModTexts.title(ModTexts.choose(((ListSelectionScreenModel)this.model).getTitle())));
        ((ListSelectionScreenView)this.view).getSearchField().textProperty().addListener(this::filter);
        if (((ListSelectionScreenModel)this.model).isMultiSelect()) {
            ((ListSelectionScreenModel)this.model).getElements().forEach(item -> this.initializeSelectableItem((ListSelectionElementModel)item));
        } else {
            ((ListSelectionScreenModel)this.model).getElements().forEach(item -> {
                if (item.getId().toString().equals(((ListSelectionScreenModel)this.model).getInitialValue())) {
                    ((ListSelectionScreenView)this.view).getListView().setFocusedElement((ListSelectionElementModel)item);
                }
            });
            ((ListSelectionScreenView)this.view).getListView().focusedElementProperty().addListener(this::refreshButton);
        }
        ((ListSelectionScreenView)this.view).getCancelButton().onAction(Guapi.getScreenHandler()::hideScene);
        if (((ListSelectionScreenModel)this.model).isMultiSelect()) {
            ((ListSelectionScreenView)this.view).getDoneButton().onAction(() -> {
                if (((ListSelectionScreenModel)this.model).getMultiAction() != null) {
                    List selectedIds = ((ListSelectionScreenModel)this.model).getElements().stream().filter(SelectableListSelectionElementModel.class::isInstance).map(SelectableListSelectionElementModel.class::cast).filter(SelectableListSelectionElementModel::isSelected).map(item -> ((ListSelectionElementModel)((Object)item)).getId()).collect(Collectors.toCollection(() -> new ArrayList()));
                    ((ListSelectionScreenModel)this.model).getMultiAction().accept(selectedIds);
                }
                Guapi.getScreenHandler().hideScene();
            });
        } else {
            ((ListSelectionScreenView)this.view).getDoneButton().onAction(() -> {
                ((ListSelectionScreenModel)this.model).getAction().accept(((ListSelectionElementModel)((ListSelectionScreenView)this.view).getListView().getFocusedElement()).getId().toString());
                Guapi.getScreenHandler().hideScene();
            });
        }
        this.refreshButton();
        this.filter("");
    }

    private void filter(String filter) {
        ((ListSelectionScreenView)this.view).getListView().getItems().setAll((Collection<ListSelectionElementModel>)((ListSelectionScreenModel)this.model).getElements().stream().filter((? super T item) -> item.matches(filter)).limit(ClientConfiguration.INSTANCE.getSelectionScreenMaxItems()).toList());
        this.refreshButton();
    }

    private void refreshButton() {
        if (((ListSelectionScreenModel)this.model).isMultiSelect()) {
            boolean anySelected = ((ListSelectionScreenModel)this.model).getElements().stream().filter(SelectableListSelectionElementModel.class::isInstance).map(SelectableListSelectionElementModel.class::cast).anyMatch(SelectableListSelectionElementModel::isSelected);
            ((ListSelectionScreenView)this.view).getDoneButton().setDisable(!anySelected);
        } else {
            ((ListSelectionScreenView)this.view).getDoneButton().setDisable(((ListSelectionScreenView)this.view).getListView().getFocusedElement() == null);
        }
    }

    private void initializeSelectableItem(ListSelectionElementModel item) {
        if (item instanceof SelectableListSelectionElementModel) {
            SelectableListSelectionElementModel selectable = (SelectableListSelectionElementModel)((Object)item);
            ResourceLocation id = item.getId();
            selectable.setSelected(((ListSelectionScreenModel)this.model).getInitiallySelected().contains(id));
            selectable.selectedProperty().addListener(this::refreshButton);
        }
    }
}

