/*
 * Decompiled with CFR 0.152.
 */
package com.github.rinorsi.cadeditor.client.screen.controller.selection.element;

import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.franckyi.guapi.api.mvc.AbstractController;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.ListSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.model.selection.element.SelectableListSelectionElementModel;
import com.github.rinorsi.cadeditor.client.screen.view.selection.element.ListSelectionElementView;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class ListSelectionElementController<M extends ListSelectionElementModel, V extends ListSelectionElementView>
extends AbstractController<M, V> {
    private Component fullDisplayName;

    public ListSelectionElementController(M model, V view) {
        super(model, view);
    }

    @Override
    public void bind() {
        this.fullDisplayName = ((ListSelectionElementModel)this.model).getDisplayName();
        ((ListSelectionElementView)this.view).getNameLabel().getTooltip().setAll((Component[])new Component[]{this.fullDisplayName.copy()});
        ((ListSelectionElementView)this.view).getRoot().widthProperty().addListener(newValue -> this.updateDisplayName());
        this.updateDisplayName();
        ((ListSelectionElementView)this.view).getIdLabel().setLabel((Component)GuapiHelper.text(((ListSelectionElementModel)this.model).getId().toString()).withStyle(ChatFormatting.ITALIC));
        Object object = this.model;
        if (object instanceof SelectableListSelectionElementModel) {
            SelectableListSelectionElementModel selectable = (SelectableListSelectionElementModel)object;
            ((ListSelectionElementView)this.view).enableSelection();
            ((ListSelectionElementView)this.view).getSelectionCheckBox().checkedProperty().bindBidirectional(selectable.selectedProperty());
            this.updateDisplayName();
        }
    }

    private void updateDisplayName() {
        ((ListSelectionElementView)this.view).getNameLabel().setLabel(this.truncateDisplayName(this.fullDisplayName));
    }

    private Component truncateDisplayName(Component component) {
        if (component == null) {
            return Component.empty();
        }
        int maxWidth = this.computeAvailableWidth();
        if (maxWidth <= 0) {
            return Component.empty();
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft == null || minecraft.font == null) {
            return component.copy();
        }
        Font font = minecraft.font;
        if (font.width((FormattedText)component) <= maxWidth) {
            return component.copy();
        }
        String ellipsis = "...";
        int ellipsisWidth = font.width(ellipsis);
        int availableWidth = Math.max(0, maxWidth - ellipsisWidth);
        String trimmed = font.plainSubstrByWidth(component.getString(), availableWidth);
        while (!trimmed.isEmpty() && font.width(trimmed) > availableWidth) {
            trimmed = trimmed.substring(0, trimmed.length() - 1);
        }
        if (trimmed.isEmpty()) {
            return Component.literal((String)ellipsis).withStyle(component.getStyle());
        }
        return Component.literal((String)trimmed).withStyle(component.getStyle()).append((Component)Component.literal((String)ellipsis).withStyle(component.getStyle()));
    }

    private int computeAvailableWidth() {
        int width = ((ListSelectionElementView)this.view).getRoot().getWidth() - ((ListSelectionElementView)this.view).getRoot().getPadding().getHorizontal();
        if (((ListSelectionElementView)this.view).getSelectionCheckBox() != null) {
            width -= ((ListSelectionElementView)this.view).getSelectionCheckBox().getWidth() + ((ListSelectionElementView)this.view).getRoot().getSpacing();
        }
        return Math.max(width, 0);
    }
}

